/**
 *  utiils
 * @type {{isNum: (function(*=): boolean), isZipCode: (function(*): boolean), isEmpty: Validate.isEmpty, isSimpleIP: (function(*=): boolean), XSS_Check: Validate.XSS_Check, isIntegerInRange: Validate.isIntegerInRange, isEMailAddr: Validate.isEMailAddr, isURL: Validate.isURL, isDate: (function(*, *): boolean), isSSN: Validate.isSSN, isDecimal: Validate.isDecimal, isNotEmpty: Validate.isNotEmpty, isAlphaLatin: (function(*=): boolean)}}
 */
var Validate = {
    isSimpleIP: function(ip) {
        //ipRegExp = /^(([0-2]*[0-9]+[0-9]+)\.([0-2]*[0-9]+[0-9]+)\.([0-2]*[0-9]+[0-9]+)\.([0-2]*[0-9]+[0-9]+))$/;
        var ipRegExp = /^(1|2)?\d?\d([.](1|2)?\d?\d){3}$/;
        return ipRegExp.test(ip);
    },
    isAlphaLatin : function(string){
        alphaRegExp = /^[0-9a-z]+$/i;
        return alphaRegExp.test(string);
    },
    isNotEmpty : function(string){
        if (string == 'undefined' || typeof string == 'undefined' || typeof string == undefined)
            return false;
        return /\S/.test(string);
    },
    isEmpty : function(string){
        if (string == 'undefined' || typeof string == 'undefined' || typeof string == undefined || string == '')
            return true;
        return !/\S/.test(string);
    },
    isIntegerInRange : function(n, Nmin, Nmax){
        var num = Number(n);
        if (isNaN(num)) {
            return false;
        }
        if (num != Math.round(num)) {
            return false;
        }
        return (num >= Nmin && num <= Nmax);
    },
    isNum : function(number){
        numRegExp = /^[0-9]+$/;
        return numRegExp.test(number);
    },
    isEMailAddr : function(string){

        if (Validate.isEmpty(string)) {
            return true;
        }
        emailRegExp = /^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.([a-z]){2,4})$/;
        return emailRegExp.test(string);
    },
    isZipCode : function(zipcode){
        //    zpcRegExp = /^[1-9][0-9]{3}\s?[a-zA-Z]{2}$/;
        return true;
    },
    isDate : function(date, format){
        return true;
    },
    isURL : function(string){
        if (!string)
            return false;
        string = string.toLowerCase();
        urlRegExp = /^(((ht|f)tp(s?))\:\/\/)([0-9a-zA-Z\-]+\.)+[a-zA-Z]{2,6}(\:[0-9]+)?(\/\S*)?$/;
        return urlRegExp.test(string);
    },
    isSSN : function(number){
        if (!number)
            return false;
        ssnRegExp = /^\d{6}-\d{7}$/;
        return ssnRegExp.test(number);
    },
    isDecimal : function(number){
        if (!number)
            return false;
        decimalRegExp = /^-?(0|[1-9]{1}\d{0,})(\.(\d{1}\d{0,}))?$/;
        return decimalRegExp.test(number);
    },
    XSS_Check : function(strTemp){
        if(strTemp != null){
            strTemp = strTemp.replace(/\<|\>|\"|\'|\%|\;|\(|\)|\&|\+|\-/g,"");
            strTemp = strTemp.replace(/\</g, "&lt;");
            strTemp = strTemp.replace(/\>/g, "&gt;");
            strTemp = strTemp.replace(/&/gi, "&amp;");
            strTemp = strTemp.replace(/\"/gi, "&quot;");
            return strTemp;
        }
    },
    getUniqueObjectArray:function(data, key) {
        return data.filter(function(item, i) {
            return data.findIndex(function (item2, j) {
                return item.accountId === item2.accountId;
            }) === i;
        });
    }


};

//========================================================//
// format
// format 관련 Function Object
//========================================================//
var Format = {
    //날짜형 change
    //날짜포멧 정의 ( yyyy-MM-dd )
    date: function(date, fmt) {
        var format = "yyyy-MM-dd";
        if ( fmt != null ) format = fmt;

        var nDate = date.replace(/\/|\-/g, "");
        var nFormat = format.replace(/\/|\-/g, "");

        if (nDate.length != nFormat.length) return "";

        var yS = nFormat.indexOf("y");
        var mS = nFormat.indexOf("M");
        var dS = nFormat.indexOf("d");

        var year = nDate.substr(yS, 4);
        var month = nDate.substr(mS, 2);
        var day = nDate.substr(dS, 2);

        // 날짜가 넘어갈경우 마지막 날짜처리
        if (month > 12) month = 12;
        if (month == "01" || month == "03" || month == "05" || month == "07" || month == "08" || month == "10" || month == "12" )
        {
            if (day > 31) day = 31;
        } else {
            if (day > 30) day = 30;
        }

        format = format.replace("yyyy", year);
        format = format.replace("MM", month);
        format = format.replace("dd", day);

        return format;
    },
    getTimeStamp : function () {
        var d = new Date();

        var s =
            this.leadingZeros(d.getFullYear(), 4) + '-' +
            this.leadingZeros(d.getMonth() + 1, 2) + '-' +
            this.leadingZeros(d.getDate(), 2) + ' ' +

            this.leadingZeros(d.getHours(), 2) + ':' +
            this.leadingZeros(d.getMinutes(), 2) + ':' +
            this.leadingZeros(d.getSeconds(), 2);
        return s;
    },
    leadingZeros : function(n, digits) {
        var zero = '';
        n = n.toString();

        if (n.length < digits) {
            for (var i = 0; i < digits - n.length; i++)
                zero += '0';
        }
        return zero + n;
    },
    //금액 change
    decimal: function(number, decimals, dec_point, thousands_sep) {
        if (0 == number || "0" == number) return "0";
        if (null == number || "" == number) return "";
        //number = number.replace(",","");
        number = String(number).replace(/,/g,"");

        if (0 < number.indexOf(".")) {
            if (3 >= number.substr(0, number.indexOf(".")).length) return number.substr(0, number.indexOf(".")+1) + string.rPad(number.substr(number.indexOf(".")+1), "0", decimals, true);
        } else {
            if (3 >= number.length){
                if (decimals == 0){
                    return string.rPad(number, "0", decimals);
                } else {
                }
            }
        }

        dec_point = ".";
        thousands_sep = ",";
        var n = number, prec = decimals, dec = dec_point, sep = thousands_sep;
        n = !isFinite(+n) ? 0 : +n;
        prec = !isFinite(+prec) ? 0 : Math.abs(prec);
        sep = sep == undefined ? ',' : sep;

        var s = n.toFixed(prec),
            abs = Math.abs(n).toFixed(prec),
            _, i;

        if (abs >= 1000) {
            _ = abs.split(/\D/);
            i = _[0].length % 3 || 3;

            _[0] = s.slice(0,i + (n < 0)) +
                _[0].slice(i).replace(/(\d{3})/g, sep+'$1');

            s = _.join(dec || '.');
        } else {
            s = abs.replace('.', dec_point);
        }
        return s;
    },
    //숫자형 change
    number: function(number) {
        return Format.decimal(number);
    },
    //날짜 포멧 자동셋팅
    setDateType: function(date) {
        if (typeof(date) == "object")
        {
            date.datepicker();
            date.change(function() {
                $(this).val(Format.date($(this).val()));
            });
        }
        else if (typeof(date) == "string")
        {
            var sdate = "#" + date.replace(/#/g, "");

            $(sdate).datepicker();
            $(sdate).change(function() {
                $(this).val(Format.date($(this).val()));
            });
        }
    },
    //월 포멧 자동셋팅
    setMonthType: function(month) {
        if (typeof(month) == "object")
        {
            $.fn.dzMonthCal({id:$(month).attr("id"),type:"mon",min:2010, max:2015,icon:"n"});

            month.change(function() {
                $(this).val(Format.date($(this).val(), "yyyy-MM"));
            });
        }
        else if (typeof(month) == "string")
        {
            var sdate = "#" + month.replace(/#/g, "");

            $.fn.dzMonthCal({id:month,type:"mon",min:2010, max:2015,icon:"n"});

            $(sdate).change(function() {
                $(this).val(Format.date($(this).val(), "yyyy-MM"));
            });
        }
    },
    //금액 포멧 자동셋팅
    setDecimalType: function(amt, decimals) {
        if (typeof(amt) == "object")
        {
            amt.change(function () {
                $(this).val(Format.decimal($(this).val(), decimals));
            });
        }
        else if (typeof(amt) == "string")
        {
            var samt = "#" + amt.replace(/#/g, "");

            $(samt).change(function () {
                $(this).val(Format.decimal($(this).val(), decimals));
            });
        }
    },
    //숫자 포멧 자동셋팅
    setNumberType: function(amt) {
        if (typeof(amt) == "object")
        {
            amt.change(function () {
                $(this).val(Format.number($(this).val()));
            });
        }
        else if (typeof(amt) == "string")
        {
            var samt = "#" + amt.replace(/#/g, "");

            $(samt).change(function () {
                $(this).val(Format.number($(this).val()));
            });
        }
    }

};

//========================================================//
// string
// string 관련 Function Object
//========================================================//
var StringUtil = {
    lPad: function(sOrgStr, sPaddingChar, iNum, fix) {
        if (sOrgStr == null || sPaddingChar == null || iNum == null) return "";

        var sReturn
        var sPaddingStr = "";

        for (var i=0; i < iNum; i++) {
            sPaddingStr += sPaddingChar;
        }

        if (fix) sReturn = (sPaddingStr + sOrgStr).substring((sPaddingStr + sOrgStr).length-iNum, (sPaddingStr + sOrgStr).length);
        else sReturn = (sPaddingStr + sOrgStr);

        return	sReturn;
    },
    rPad: function(sOrgStr, sPaddingChar, iNum, fix) {
        if (sOrgStr == null || sPaddingChar == null || iNum == null) return "";

        var sReturn
        var sPaddingStr = "";

        for (var i=0; i < iNum; i++) {
            sPaddingStr += sPaddingChar;
        }

        if (fix) sReturn = (sOrgStr + sPaddingStr).substring(0, iNum);
        else sReturn = (sOrgStr + sPaddingStr);

        return	sReturn;
    }
};

//========================================================//
// date
// 날짜 및 시간 관련 Function Object
//========================================================//
var SysDate = {
    // 오늘날짜
    date: function() {
        var data;
        var jsonObj = { service : 'dateService', method : 'selectSysDate' };
        $.ajax({
            async: false,
            url: "action.dox",
            data: jsonObj,
            type: "POST",
            success: function(xml) {
                data = xml.string;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("System ajax call Failed!");
            }
        });
        return data;
    },
    // 오늘날짜시간
    dateTime: function() {
        var data;
        var jsonObj = { service : 'dateService', method : 'selectSysDateTime' };
        $.ajax({
            async: false,
            url: "action.dox",
            data: jsonObj,
            type: "POST",
            success: function(xml) {
                data = xml.string;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("System ajax call Failed!");
            }
        });
        return data;
    },
    // 현재월
    month: function() {
        var data;
        var jsonObj = { service : 'dateService', method : 'selectSysMonth' };
        $.ajax({
            async: false,
            url: "action.dox",
            data: jsonObj,
            type: "POST",
            success: function(xml) {
                data = xml.string;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("System ajax call Failed!");
            }
        });
        return data;
    },
    // 현재월 첫일
    firstDate: function() {
        var data;
        var jsonObj = { service : 'dateService', method : 'selectSysFirstDate' };
        $.ajax({
            async: false,
            url: "action.dox",
            data: jsonObj,
            type: "POST",
            success: function(xml) {
                data = xml.string;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("System ajax call Failed!");
            }
        });
        return data;
    },
    // 현재월 말일
    lastDate: function() {
        var data;
        var jsonObj = { service : 'dateService', method : 'selectSysLastDate' };
        $.ajax({
            async: false,
            url: "action.dox",
            data: jsonObj,
            type: "POST",
            success: function(xml) {
                data = xml.string;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("System ajax call Failed!");
            }
        });
        return data;
    },
    // 날짜 더하기
    addDate: function(addday) {
        var data;
        var jsonObj = { service : 'dateService', method : 'selectSysAddDate', addDay : addday };
        $.ajax({
            async: false,
            url: "action.dox",
            data: jsonObj,
            type: "POST",
            success: function(xml) {
                data = xml.string;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("System ajax call Failed!");
            }
        });
        return data;
    }

};


//]]>
