var Format = {
    //날짜형 change
    //날짜포멧 정의 ( yyyy-MM-dd )
    date: function(date, fmt) {
        var format = "yyyy-MM-dd";
        if ( fmt != null ) format = fmt;

        var nDate = date.replace(/\/|\-/g, "");
        var nFormat = format.replace(/\/|\-/g, "");

        if (nDate.length != nFormat.length) return "";

        var yS = nFormat.indexOf("y");
        var mS = nFormat.indexOf("M");
        var dS = nFormat.indexOf("d");

        var year = nDate.substr(yS, 4);
        var month = nDate.substr(mS, 2);
        var day = nDate.substr(dS, 2);

        // 날짜가 넘어갈경우 마지막 날짜처리
        if (month > 12) month = 12;
        if (month == "01" || month == "03" || month == "05" || month == "07" || month == "08" || month == "10" || month == "12" )
        {
            if (day > 31) day = 31;
        } else {
            if (day > 30) day = 30;
        }

        format = format.replace("yyyy", year);
        format = format.replace("MM", month);
        format = format.replace("dd", day);

        return format;
    },
    //금액 change
    decimal: function(number, decimals, dec_point, thousands_sep) {
        if (0 == number || "0" == number) return "0";
        if (null == number || "" == number) return "";
        //number = number.replace(",","");
        number = String(number).replace(/,/g,"");

        if (0 < number.indexOf(".")) {
            if (3 >= number.substr(0, number.indexOf(".")).length) return number.substr(0, number.indexOf(".")+1) + string.rPad(number.substr(number.indexOf(".")+1), "0", decimals, true);
        } else {
            if (3 >= number.length){
                if (decimals == 0){
                    return string.rPad(number, "0", decimals);
                } else {
                }
            }
        }

        dec_point = ".";
        thousands_sep = ",";
        var n = number, prec = decimals, dec = dec_point, sep = thousands_sep;
        n = !isFinite(+n) ? 0 : +n;
        prec = !isFinite(+prec) ? 0 : Math.abs(prec);
        sep = sep == undefined ? ',' : sep;

        var s = n.toFixed(prec),
            abs = Math.abs(n).toFixed(prec),
            _, i;

        if (abs >= 1000) {
            _ = abs.split(/\D/);
            i = _[0].length % 3 || 3;

            _[0] = s.slice(0,i + (n < 0)) +
                _[0].slice(i).replace(/(\d{3})/g, sep+'$1');

            s = _.join(dec || '.');
        } else {
            s = abs.replace('.', dec_point);
        }
        return s;
    },
    //숫자형 change
    number: function(number) {
        return Format.decimal(number);
    },
    //날짜 포멧 자동셋팅
    setDateType: function(date) {
        if (typeof(date) == "object")
        {
            date.datepicker();
            date.change(function() {
                $(this).val(Format.date($(this).val()));
            });
        }
        else if (typeof(date) == "string")
        {
            var sdate = "#" + date.replace(/#/g, "");

            $(sdate).datepicker();
            $(sdate).change(function() {
                $(this).val(Format.date($(this).val()));
            });
        }
    },
    //월 포멧 자동셋팅
    setMonthType: function(month) {
        if (typeof(month) == "object")
        {
            $.fn.dzMonthCal({id:$(month).attr("id"),type:"mon",min:2010, max:2015,icon:"n"});

            month.change(function() {
                $(this).val(Format.date($(this).val(), "yyyy-MM"));
            });
        }
        else if (typeof(month) == "string")
        {
            var sdate = "#" + month.replace(/#/g, "");

            $.fn.dzMonthCal({id:month,type:"mon",min:2010, max:2015,icon:"n"});

            $(sdate).change(function() {
                $(this).val(Format.date($(this).val(), "yyyy-MM"));
            });
        }
    },
    //금액 포멧 자동셋팅
    setDecimalType: function(amt, decimals) {
        if (typeof(amt) == "object")
        {
            amt.change(function () {
                $(this).val(Format.decimal($(this).val(), decimals));
            });
        }
        else if (typeof(amt) == "string")
        {
            var samt = "#" + amt.replace(/#/g, "");

            $(samt).change(function () {
                $(this).val(Format.decimal($(this).val(), decimals));
            });
        }
    },
    //숫자 포멧 자동셋팅
    setNumberType: function(amt) {
        if (typeof(amt) == "object")
        {
            amt.change(function () {
                $(this).val(Format.number($(this).val()));
            });
        }
        else if (typeof(amt) == "string")
        {
            var samt = "#" + amt.replace(/#/g, "");

            $(samt).change(function () {
                $(this).val(Format.number($(this).val()));
            });
        }
    }

};