(function (g) {
  var lang_approval_list = {
    ko: {
      'lang-org-tit': 'K-APPROVAL 조직 구성 관리',
      'lang-approval-tit': '결재선 관리',
      'lang-approval-set-tit-list':'결재선 리스트',
      'lang-approval-add': '결재선 추가',
      'lang-tit-pop-line-remove': '결재라인 삭제',
      'lang-desc-pop-remove': '결재라인을 삭제 하시겠습니까?',
      'lang-tit-pop-apply-remove': '결재선 적용 삭제',
      'lang-desc-pop-apply-remove': '결재선을 삭제 하시겠습니까?',
      'lang-btn-run-delete-now': '삭제',
      'lang-btn-delete-cancel': '취소',
      'lang-approval-set-tit':'결재선 설정',
      'lang-approval-apply-tit':'결재선 적용',
      'lang-approval-linenm':'결재선 이름',
      'lang-approval-desc':'설명',
      'lang-approval-detail-Setting':'세부설정',
      'lang-approval-detail-none':'없음',
      'lang-approval-detail-group':'조직',
      'lang-approval-detail-jirafield':'지라필드',
      'lang-approval-detail-jirafieldval':'필드값',
      'lang-approval-order':'결재순서',
      'lang-approval-order-type':'결재순서',
      'lang-approval-save':'저장',
      'lang-approval-register':'등록',
      'lang-approval-gomain':'메인으로',
      'lang-approval-ty-gomain':'메인으로',
      'lang-approval-apply-save':'저장',
      'lang-approval-apply-gomain':'메인으로',
      'lang-org-user-tit':'멤버관리',
      'lang-org-user-search':'멤버검색',
      'lang-org-user-btnsearch':'검색',
      'lang-tit-org-remove':'삭제',
      'lang-desc-org-remove':'삭제하시겠습니까?',
      'lang-pop-org-cancel':'취소',
      'lang-pop-org-yes':'삭제',
      'lang-tit-role-delete':'직책명 삭제',
      'lang-desc-role-delete':'직책명을 삭제 하시겠습니까?',
      'lang-desc-approval-req':'결재선을 입력해주세요!',
      'lang-org-user-apply':'적용',
      'lang-org-user-close':'닫기',
      'lang-org-user-username':'성명',
      'lang-org-user-displayname':'전체이름',
      'lang-org-user-orgaffliate':'소속조직',
      'lang-org-user-role':'소속조직',
      'lang-org-user-orgleader':'조직장 여부',
      'lang-org-user-email':'이메일',
      'lang-org-user-jiragroup':'Jira 그룹',
      'lang-report-tit': '보고서',
      'lang-report-lbl-search': '이슈검색',
      'lang-table': {
        'tit-no': '결재선 번호',
        'tit-name': '결재선 이름',
        'tit-desc': '설명',
        'tit-order': '결재순서',
        'tit-info': '결재선 적용 정보',
        'tit-control': '조작'
      },
      'lang-set-table': {
        'tit-order': '순서',
        'tit-type': '결재 유형',
        'tit-order-nm': '결재순서 이름',
        'tit-user-type': '결재자 유형',
        'tit-user-select': '결재자 지정',
        'tit-control': '조작'
      },
      'lang-set-table-type': {
        'tit-order-type': '순서',
        'tit-type-type': '결재 유형',
        'tit-order-nm-type': '결재순서 이름',
        'tit-user-type-type': '결재자 유형',
        'tit-user-select-type': '결재자 지정',
        'tit-control-type': '조작'
      },
      'lang-apply-table': {
        'tit-mapping': '매핑#',
        'tit-prj': '프로젝트',
        'tit-issue-type': '이슈유형',
        'tit-workflow-nm': '워크플로이름',
        'tit-workflow-state': '결재적용 워크플로의 상태',
        'tit-approval-ok': '승인시 전환',
        'tit-approval-return': '반려시 전환',
        'tit-apply-yn': '적용여부',
        'tit-delete': '삭제'
      },
      'lang-org-mng-table': {
        'tit-name': '이름',
        'tit-role': '직책',
        'tit-leader': '조직장 여부 ',
        'tit-org': '소속 조직'
      },
      'lang-org-role-table': {
        'tit-order': '순서',
        'tit-name': '직책명',
        'tit-control': '조작'
      },
      'lang-org-user-table': {
        'tit-select': '순서',
        'tit-name': '성명',
        'tit-org': '소속조직',
        'tit-role': '직책',
        'tit-email': '이메일 주소',
        'tit-group': 'Jira 그룹',
        'tit-edit': '편집'
      },
      'lang-report-table': {
        'tit-no': '순서',
        'tit-prj': '프로젝트',
        'tit-issueTy': '이슈유형',
        'tit-issueKey': '이슈키',
        'tit-pathNm': '결재선이름',
        'tit-approvalTy': '결재유형',
        'tit-approvalUser': '결재자',
        'tit-time': '시간',
        'tit-result': '결재상태',
        'tit-path' : '결재경로'
      },
      'lang-approval-type-option': ['사용자이름', '전체이름', '이메일주소','소속조직'],
      'lang-tab-org': ['조직구조', '직책', '팀원'],
      'lang-issue-search': ['이슈유형', '결재선이름'],
    }
  }; // lang_list

  var utils = {
    getEl: function (sel, context) {
      return (context || document).querySelector(sel);
    },
    getEls: function (sel, context) {
      return (context || document).querySelectorAll(sel);
    },
    getArrList: function (nodeList) {
      return Array.prototype.slice.call(nodeList);
    },
    singleTranslation: function (sel, key) {
      if(this.getEl(sel) != null){
        this.getEl(sel).innerHTML = i18next.t(key);
      }
    },
    multiTranslation: function (sel, context, callback) {
      var list = this.getArrList(this.getEls(sel, context));
      list.forEach(function (el, idx) {
        callback(el, idx);
      });
    },
    singleTranslationTxt: function (sel, key) {
      this.getEl(sel).textContent = i18next.t(key);
    }
  };

// table

  var setApprovalLanguage = function (lang) {

    document.documentElement.setAttribute('lang', lang);
    if (lang !== 'ko') return;

    var updateContent = function () {
      // intro
      utils.singleTranslation('.lang-org-tit', 'lang-org-tit');
      utils.singleTranslation('.lang-approval-tit', 'lang-approval-tit');
      utils.singleTranslation('.lang-approval-set-tit-list', 'lang-approval-set-tit-list');
      utils.singleTranslation('.lang-approval-add', 'lang-approval-add');
      utils.singleTranslation('.lang-tit-pop-line-remove', 'lang-tit-pop-line-remove');
      utils.singleTranslation('.lang-desc-pop-remove', 'lang-desc-pop-remove');
      utils.singleTranslation('.lang-btn-run-delete-now', 'lang-btn-run-delete-now');
      utils.singleTranslation('.lang-btn-delete-cancel', 'lang-btn-delete-cancel');
      utils.singleTranslation('.lang-approval-set-tit', 'lang-approval-set-tit');
      utils.singleTranslation('.lang-approval-linenm', 'lang-approval-linenm');
      utils.singleTranslation('.lang-approval-desc', 'lang-approval-desc');
      utils.singleTranslation('.lang-approval-detail-Setting', 'lang-approval-detail-Setting');
      utils.singleTranslation('.lang-approval-detail-none', 'lang-approval-detail-none');
      utils.singleTranslation('.lang-approval-detail-group', 'lang-approval-detail-group');
      utils.singleTranslation('.lang-approval-detail-jirafield', 'lang-approval-detail-jirafield');
      utils.singleTranslation('.lang-approval-detail-jirafieldval', 'lang-approval-detail-jirafieldval');
      utils.singleTranslation('.lang-approval-order', 'lang-approval-order');
      utils.singleTranslation('.lang-approval-order-type', 'lang-approval-order-type');
      utils.singleTranslation('.lang-approval-save', 'lang-approval-save');
      utils.singleTranslation('.lang-approval-register', 'lang-approval-register');
      utils.singleTranslation('.lang-approval-gomain', 'lang-approval-gomain');
      utils.singleTranslation('.lang-approval-ty-gomain', 'lang-approval-ty-gomain');
      utils.singleTranslation('.lang-tit-pop-apply-remove', 'lang-tit-pop-apply-remove');
      utils.singleTranslation('.lang-approval-apply-tit', 'lang-approval-apply-tit');
      utils.singleTranslation('.lang-desc-pop-apply-remove', 'lang-desc-pop-apply-remove');
      utils.singleTranslation('.lang-approval-apply-save', 'lang-approval-apply-save');
      utils.singleTranslation('.lang-approval-apply-gomain', 'lang-approval-apply-gomain');
      utils.singleTranslation('.lang-org-user-tit', 'lang-org-user-tit');
      utils.singleTranslation('.lang-org-user-search', 'lang-org-user-search');
      utils.singleTranslation('.lang-org-user-btnsearch', 'lang-org-user-btnsearch');
      utils.singleTranslation('.lang-tit-org-remove', 'lang-tit-org-remove');
      utils.singleTranslation('.lang-desc-org-remove', 'lang-desc-org-remove');
      utils.singleTranslation('.lang-pop-org-cancel', 'lang-pop-org-cancel');
      utils.singleTranslation('.lang-pop-org-yes', 'lang-pop-org-yes');
      utils.singleTranslation('.lang-tit-role-delete', 'lang-tit-role-delete');
      utils.singleTranslation('.lang-desc-role-delete', 'lang-desc-role-delete');
      utils.singleTranslation('.lang-org-user-apply', 'lang-org-user-apply');
      utils.singleTranslation('.lang-org-user-close', 'lang-org-user-close');
      utils.singleTranslation('.lang-report-tit', 'lang-report-tit');
      utils.singleTranslation('.lang-report-lbl-search', 'lang-report-lbl-search');



      utils.multiTranslation('.lang-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-table.' + category;
        el.textContent = i18next.t(langKind);
      });

      utils.multiTranslation('.lang-report-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-report-table.' + category;
        el.textContent = i18next.t(langKind);
      });

      utils.multiTranslation('.lang-org-user-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-org-user-table.' + category;
        el.textContent = i18next.t(langKind);
      });


      // tab
      utils.multiTranslation('.lang-tab-org', null, function (el, idx) {
        el.textContent = i18next.t('lang-tab-org', { returnObjects: true })[idx];
      });

      utils.multiTranslation('.lang-set-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-set-table.' + category;
        el.textContent = i18next.t(langKind);
      });

      utils.multiTranslation('.lang-set-table-type', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-set-table-type.' + category;
        el.textContent = i18next.t(langKind);
      });

      utils.multiTranslation('.lang-apply-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-apply-table.' + category;
        el.textContent = i18next.t(langKind);
      });

      utils.multiTranslation('.lang-org-role-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-org-role-table.' + category;
        el.textContent = i18next.t(langKind);
      });

      utils.multiTranslation('.lang-org-mng-table', null, function (el, idx) {
        var category = el.getAttribute('data-category');
        var langKind = 'lang-org-mng-table.' + category;
        el.textContent = i18next.t(langKind);
      });



      // select interval
      // utils.multiTranslation(
      //     'option',
      //     utils.getEl('.select lang-approval-type-option'),
      //     function (el, idx) {
      //       el.textContent = i18next.t('lang-approval-type-option', {
      //         returnObjects: true
      //       })[idx];
      //     }
      // );


      // utils.multiTranslation(
      //     'option',
      //     utils.getEl('.select lang-issue-search'),
      //     function (el, idx) {
      //       el.textContent = i18next.t('lang-issue-search', {
      //         returnObjects: true
      //       })[idx];
      //     }
      // );



    };

    i18next
      .init({
        lng: 'ko',
        debug: true,
        resources: {
          ko: {
            translation: lang_approval_list.ko
          }
        }
      })
      .then(function (t) {
        updateContent();
      });
  };

  g.setApprovalLanguage = setApprovalLanguage;
  g.lang_approval_list = lang_approval_list;
})(window);
