/**
 * kapproval.js
 * 최초생성일: 2021. 04. 11
 *  설명:박재형
 *  결재선 관리 페이지
 */
var approvalDelRowNum;
var approvalEditKey;
var approvalAcceptIdx;

/**
 * 시작
 */
var init = function () {
    openSpinner();

    /** 결재선 리스트 조회   */
    var data;
    Api.call(apiUrl.getApprovalLineList(),'GET',data,resultLineList);

}

/**
 * 결재 라인 삭제
 */
var approalListLineDelete = function () {
    openSpinner();
    var linenum = approvalDelRowNum;
    /** 결재선 라인 삭제    */
    var data;
    Api.call(apiUrl.removeApprovalLine(linenum),'DELETE',data,resultDeleteLine);
}

var resultDeleteLine = function (data) {

    if(data.resultCode == 200){
        AJS.flag(toast.successLineDelete);
        AJS.dialog2('#approval-lineRemove-dialog-main').hide();
        AJS.$('#approval_main').empty();
        init();
    }
    closeSpinner();
}


var resultLineList = function (data) {
    if(data.resultCode == 200){
        console.log(data);
        var arr = data.resultData;
        arr.forEach(function(item,index,arr2){
            viewApprovalList(item,index);
        });
        closeSpinner();
    }

}
/**
 * 결재선 적용
 */
var saveApprovalApplyLine = function () {
    /**
     * 스피너 시작
     */
    openSpinner();

    var config = JSON;

    var lineList = new Array();	// 배열 선언
    var tbody = document.getElementById("approvalLine_accept");

    var newTrs = Array.prototype.slice.call(tbody.querySelectorAll('tr'));
        newTrs.forEach((el, idx) => {
            var line = new Object();
            var cells = el.getElementsByTagName("td");
            console.log('saveApprovalApplyLine',cells);
            var num = cells[0].firstChild.data;
            var workflowNm = cells[3].children[0].id;
            var toggleAccept = cells[7].children[0].checked;
            var prjid = cells[1].children[0].id;
            var issueid = cells[2].children[0].id;


            line.num = num;
            line.prjname = cells[1].children[0].displayValue;
            line.issueType = cells[2].children[0].displayValue;

            line.prjId = AJS.$('#' + prjid).val();
            line.issueTypeId =AJS.$('#' + issueid).val();
            line.workflownm = AJS.$('#' + workflowNm).text();
            line.workflowstatus = cells[4].children[0].displayValue;
            line.convertapproval = cells[5].children[0].displayValue;
            line.returnapproval = cells[6].children[0].displayValue;
            line.isapply = toggleAccept;

            lineList.push(line);
        });

    config.lineNum = approvalEditKey;

    var aTotalJson = JSON;

    aTotalJson.lineList = lineList;


    /** 결재선 라인 저장  */
    Api.call(apiUrl.saveApplyConfig(),'PUT',aTotalJson,resultApplyLine);
}

var resultApplyLine = function (data) {
    if(data.resultCode == 200){
        AJS.$('#approval_main').empty();
        AJS.$('#approvalLinenmWarnTxt').addClass('hidden');
        closeSpinner();

    }

    setTimeout(function() {
        closeSpinner();
    }, 500);

    AJS.flag(toast.successLineSave);
}

/**
 * 결제 라인 저장
 */
var saveApprovalLine = function () {
    if(Validate.isEmpty( AJS.$('#txtLineNm').val())){
        AJS.$('#approvalLinenmWarnTxt').removeClass('hidden');
        return;
    }

    /**
     * 스피너 시작
     */
    openSpinner();

    var config = JSON;

    var lineList = new Array();	// 배열 선언
    var tbody = document.getElementById("approvalLine_rows");

    var newTrs = Array.prototype.slice.call(tbody.querySelectorAll('tr'));
    newTrs.forEach((el, idx) => {
        var line = new Object();
        var cells = el.getElementsByTagName("td");
        console.log('cells',cells);
        var num = cells[0].firstChild.data;
        var select_approval_type = cells[1].children[0].id;
        var txt_order_nm = cells[2].children[0].id;
        var select_approval_position = cells[3].children[0].id;
        var select_approval_fix = cells[4].children[0].id;

        line.num = num;
        line.approvalType = AJS.$('#' + select_approval_type).val();
        line.approvalOrderNm = AJS.$('#' + txt_order_nm).val();
        line.approvalPosition = AJS.$('#' + select_approval_position).val();
        line.approvalFix = AJS.$('#' + select_approval_fix).val();
        lineList.push(line);
    });

    config.lineNum = approvalEditKey;
    config.lineName = AJS.$('#txtLineNm').val();

    var aTotalJson = JSON;

    aTotalJson.lineList = lineList;


    /** 결재선 라인 저장  */
    Api.call(apiUrl.saveConfig(),'PUT',aTotalJson,resultConfig);
}


var resultConfig = function (data) {

    if(data.resultCode == 200){
        AJS.$('#approval_main').empty();
         var arr = data.resultData;
        arr.forEach(function(item,index,arr2){
            approvalEditKey = item.lineNum;
        });
        AJS.$('#approvalLinenmWarnTxt').addClass('hidden');
        AJS.flag(toast.successLineSave);

    }else{
        if(data.errorCode =="exist"){
            AJS.$('#approvalLinenmWarnTxt').removeClass('hidden');
            AJS.$('#approvalLinenmWarnTxt').text("결재선 이름이 중복되었습니다");
        }
    }
    setTimeout(function() {
        closeSpinner();
        //display('saveSucess');
    }, 500);
}

/**
 * 결제 라인 생성
 */

var approval_config_row_add = function() {
    var idx = AJS.$('#approvalLine_rows tr').length;
    var num = idx + Number(1);
    var table = document.getElementById("approvalLine_rows");
    var row = table.insertRow(idx);
    //this adds row in 0 index i.e. first place
    row.innerHTML = "<tr>\n" +
        "                        <td headers=\"basic-number\">" + num  + "</td>\n" +
        "                        <td headers=\"basic-approvalTy\">\n" +
        "                            <aui-select\n" +
        "                                    id=\"select_approval_type" + num + "\"\n" +
        "                                    name=\"select_approval_type" + num + "\"\n" +
        "                                    placeholder=\"합의\">\n" +
        "                                <aui-option value=\"0\" selected=\"selected\">합의</aui-option>\n" +
        "                                <aui-option value=\"1\">결재</aui-option>\n" +
        "                                <aui-option value=\"2\">참조</aui-option>\n" +
        "                            </aui-select>\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <input class=\"text\" type=\"text\" id=\"txt_group_nm" + num + "\" name=\"txt_group_nm" + num + "\" title=\"txt_group_nm\" placeholder=\"합의자\">\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <aui-select onchange=\"select_approvalUser_type(this," + num + ")\"\n"  +
        "                                    id=\"select_approvalUser_type" + num + "\" \n" +
        "                                    name=\"select_approvalUser_type" + num + "\" >\n" +
        "                                <aui-option value=\"0\" selected=\"selected\">기안자가 직접선택</aui-option>\n" +
        "                                <aui-option value=\"1\">개인</aui-option>\n" +
        "                                <aui-option value=\"2\">역할</aui-option>\n" +
        "                            </aui-select>\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <aui-select \n" +
        "                                    id=\"select_approvalUser_fix" + num + "\" \n" +
        "                                    name=\"product\">\n" +
        "                                <aui-option value=\"직접선택\" selected=\"selected\">직접선택</aui-option>\n" +
        "                                <aui-option value=\"박재형\">박재형</aui-option>\n" +
        "                                <aui-option value=\"팀장\">팀장</aui-option>\n" +
        "                            </aui-select>\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'bottom');\" class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-down\" id=\"span_bottom\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'down');\" class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-down\" id=\"span_down\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'up');\" class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-up\" id=\"span_up\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'top');\" class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-up\" id=\"span_top\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span class=\"aui-icon aui-icon-small aui-iconfont-trash\" style=\"color:red;\" onclick=\"onClickTrash(this,event,'edit','');\">Insert meaningful text here for accessibility</span>\n" +
        "                        </td>\n" +
        "                    </tr>";
}

var approval_add_config_line = function () {
    var idx = AJS.$('#approvalLine_rows tr').length;
    var table = document.getElementById("approvalLine_rows");
    var num = idx + Number(1);
    var row = table.insertRow(idx);
    row.innerHTML ="<tr>\n" +
        "                        <td headers=\"basic-number\">" + num  + "</td>\n" +
        "                        <td headers=\"basic-fname\">\n" +
        "                            <aui-select\n" +
        "                                    id=\"select_approval_type" + num + "\"\n" +
        "                                    name=\"product\"\n" +
        "                                    placeholder=\"합의\">\n" +
        "                                <aui-option value=\"0\" selected=\"selected\">합의</aui-option>\n" +
        "                                <aui-option value=\"1\" >결재</aui-option>\n" +
        "                                <aui-option value=\"2\" >참조</aui-option>\n" +
        "                            </aui-select>\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <input class=\"text\" type=\"text\" id=\"txt_group_nm" + num + "\" name=\"text-input\" title=\"Text input\" placeholder=\"합의자\">\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <aui-select type=\"select\"  onchange=\"select_approvalUser_type(this," + num + ")\"\n" +
        "                                    id=\"select_approvalUser_type" + num + "\" \n" +
        "                                    name=\"select_approvalUser_type" + num + "\" >\n" +
        "                                <aui-option value=\"0\" selected=\"selected\">기안자가 직접선택</aui-option>\n" +
        "                                <aui-option value=\"1\">개인</aui-option>\n" +
        "                                <aui-option value=\"2\">역할</aui-option>\n" +
        "                            </aui-select>\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <aui-select \n" +
        "                                    id=\"select_approvalUser_fix" + num + "\" \n" +
        "                                    name=\"select_approvalUser_fix" + num + "\">\n" +
        "                                <aui-option value=\"직접선택\" selected=\"selected\">직접선택</aui-option>\n" +
        "                                <aui-option value=\"박재형\">박재형</aui-option>\n" +
        "                                <aui-option value=\"팀장\">팀장</aui-option>\n" +
        "                            </aui-select>\n" +
        "                        </td>\n" +
        "                        <td>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'bottom');\" class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-down\" id=\"span_bottom\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'down');\" class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-down\" id=\"span_down\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'up');\" class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-up\" id=\"span_up\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span onClick=\"rowMoveEvent(this,'top');\" class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-up\" id=\"span_top\">Insert meaningful text here for accessibility</span>\n" +
        "                            <span class=\"aui-icon aui-icon-small aui-iconfont-trash\" style=\"color:red;\" onclick=\"onClickTrash(this,event,'edit','');\">Insert meaningful text here for accessibility</span>\n" +
        "                        </td>\n" +
        "                    </tr>";
}

var select_approvalUser_type = function (event,num) {

    var seletedID ='#select_approvalUser_type' + num + ' option:selected';
    var value = AJS.$(seletedID).val();
    var id = AJS.$("#select_approvalUser_fix" + num);
    var child = AJS.$("#select_approvalUser_fix" + num).children('datalist');

    if(value == 1){
        child.empty();
        child.append("<aui-option value='박재형' selected='selected'>박재형</aui-option>" +
                        "<aui-option value='한승철'>한승철</aui-option>" +
                        "<aui-option value='오훈'>오훈</aui-option>");
        id.val(value);
    }else if(value == 2){
        child.empty();
        child.append("<aui-option value='팀장' selected='selected'>팀장</aui-option>" +
            "<aui-option value='부서장'>부서장</aui-option>" +
            "<aui-option value='CEO'>CEO</aui-option>");
        id.val(value);
    }else{
        child.empty();
        child.append("<aui-option value='직접선택' selected='selected'>직접선택</aui-option>");
        id.val(value);
    }

}

/**
 * 결재선 적용
 */

var approva_add_accept = function () {
    //approvalEditKey = 0;
    var idx = AJS.$('#approvalLine_accept tr').length;
    // var mainLine = AJS.$('#approval_main tr').length;
    // approvalEditKey = mainLine + Number(1);
    var num = idx + Number(1);
    approvalAcceptIdx = num;
    var table = document.getElementById("approvalLine_accept");
    var row = table.insertRow(idx);
    row.innerHTML ="<tr>\n" +
        "                    <td headers=\"basic-number\">" + num  + "</td>\n" +
        "                    <td headers=\"basic-fname\">\n" +
        "                        <aui-select type=\"select\" \n" +
        "                                id=\"select_prj" + num + "\"\n" +
        "                                placeholder=\"선택\" name=\"select_prj" + num + "\"\n" +
        "                                onchange=\"select_prj(this," + num + ")\">\n" +
        "                        </aui-select>\n" +
        "                    </td>\n" +
        "                    <td>\n" +
        "                        <aui-select type=\"select\" \n" +
        "                                id=\"select_issue" + num + "\"\n" +
        "                                placeholder=\"선택\" name=\"select_issue" + num + "\"\n" +
        "                                onchange=\"select_issue(this," + num + ")\">\n" +
        "                        </aui-select>\n" +
        "                    </td>\n" +
        "                    <td headers=\"basic-lname\">\n" +
        "                        <aui-label for=\"my-toggle\" id=\"lbl_workflow" + num + "\"></aui-label>\n" +
        "                    </td>\n" +
        "                    <td headers=\"basic-lname\">\n" +
        "                        <aui-select type=\"select\" \n" +
        "                                id=\"select_workflow_status" + num + "\"\n" +
        "                                placeholder=\"선택\" name=\"select_workflow_status" + num + "\"\n" +
        "                                onchange=\"select_workflow_status(this," + num + ")\">\n" +
        "                        </aui-select>\n" +
        "                    </td>\n" +
        "                    <td headers=\"basic-username\">\n" +
        "                        <aui-select type=\"select\" \n" +
        "                                id=\"select_convert_approval" + num + "\"\n" +
        "                                placeholder=\"선택\" name=\"select_convert_approval" + num + "\"\n" +
        "                                onchange=\"select_convert_approval(this," + num + ")\">\n" +
        "                        </aui-select>\n" +
        "                    </td>\n" +
        "                    <td headers=\"basic-username\">\n" +
        "                        <aui-select type=\"select\" \n" +
        "                                id=\"select_return_approval" + num + "\"\n" +
        "                                placeholder=\"선택\" name=\"select_return_approval" + num + "\"\n" +
        "                                onchange=\"select_return_approval(this," + num + ")\">\n" +
        "                        </aui-select>\n" +
        "                        <!-- <span class=\"aui-lozenge aui-lozenge-inprogress\">결재중</span> → <span class=\"aui-lozenge aui-lozenge-success\">반려</span>   -->\n" +
        "                    </td>\n" +
        "                    <td headers=\"basic-username\">\n" +
        "                        <aui-toggle label=\"toggle button\" id=\"acceptLine_toggle" + num + "\" onchange=\"onChangeToggle(" + num + ")\"></aui-toggle>\n" +
        "                    </td>\n" +
        "                    <td headers=\"basic-username\">\n" +
        "                        <span class=\"aui-icon aui-icon-small aui-iconfont-trash\" style=\"color:red;\" onclick=\"onClickTrash(this,event,'accept','');\">Insert meaningful text here for accessibility</span>\n" +
        "                    </td>\n" +
        "                </tr>";

    setProjects();
}

/**
 * 결재선 프로젝트 선택
 * @param event
 * @param num
 */
var select_prj = function (event,num) {
    approvalAcceptIdx =num;
    var data;
    var seletedID ='#select_prj' + num + ' option:selected';
    var value = AJS.$(seletedID).val();
    var issuechild = AJS.$("#select_issue" + num).children('datalist');
    issuechild.empty();
    AJS.$("#select_workflow_status" + num).children('datalist').empty();
    Api.call(apiUrl.getIssueType(value),'GET',data,resultIssueType);

}

/**
 * 결재선 이슈 선택
 * @param event
 * @param num
 */
var select_issue = function (event,num) {
    approvalAcceptIdx =num;
    var data;
    var seletedissueID ='#select_issue' + num + ' option:selected';
    var issueValue = AJS.$(seletedissueID).val();
    AJS.$("#lbl_workflow" + num).empty();

    var seletedPrjID ='#select_prj' + num + ' option:selected';
    var prjValue = AJS.$(seletedPrjID).val();

    Api.call(apiUrl.getWorkflows(prjValue,issueValue),'GET',data,resultWorkFlows);

}


var resultWorkFlows = function (data) {
    if(data.resultCode == 200){
        var arrayWorknm = data.resultData.arrayWorknm;
        var arraySteps = data.resultData.arraySteps;
        AJS.$("#lbl_workflow" +approvalAcceptIdx).text(arrayWorknm);
        AJS.$("#select_workflow_status" + approvalAcceptIdx).children('datalist').empty();


        arraySteps.forEach(function(item,index,arr2){
            var num = index + Number(1);
            var child = AJS.$("#select_workflow_status" + approvalAcceptIdx).children('datalist');
            child.append("<aui-option value='" + item.id + "' selected='selected' >" + item.name + "</aui-option>");
        });

    }
}

/**
 * 워크플로우 선택
 * @param event
 * @param num
 */
var select_workflow_status = function (event,num) {
    approvalAcceptIdx =num;
    var data;
    var id ='#select_workflow_status' + num + ' option:selected';
    var value = AJS.$(id).val();
    var txt = AJS.$(id).text();
    var workflowNm = AJS.$("#lbl_workflow" + approvalAcceptIdx).text();

    Api.call(apiUrl.getTransApproval(value,txt,workflowNm),'GET',data,resultTransApproval);
}

var resultTransApproval = function (data) {
    if(data.resultCode == 200){
        var actions = data.resultData.actions;
        AJS.$("#select_convert_approval"+ approvalAcceptIdx).children('datalist').empty();
        AJS.$("#select_return_approval"+ approvalAcceptIdx).children('datalist').empty();

        actions.forEach(function(item,index,arr2){
            var num = index + Number(1);
            var child = AJS.$("#select_convert_approval"+ approvalAcceptIdx).children('datalist');
            var returnChild = AJS.$("#select_return_approval"+ approvalAcceptIdx).children('datalist');
            if(index == 0){
                child.append("<aui-option value='" + item.id + "' selected='selected' >" + item.name + "</aui-option>");
            }else{
                returnChild.append("<aui-option value='" + item.id + "' selected='selected' >" + item.name + "</aui-option>");
            }

        });

    }
}


var select_convert_approval = function (event,num) {
    
}

var select_return_approval = function (event,num) {

}
/**
 * 적용여부 토글
 */
var onChangeToggle = function (num) {
    var toggle = document.getElementById('acceptLine_toggle'+num);
    var isChecked = toggle.checked;

}

var onClickTrash = function (el,e,ty,num) {
    e.preventDefault();
    if(ty =='edit'){
        AJS.dialog2('#approval-lineRemove-dialog').show();
    }else if(ty =='accept'){
        AJS.dialog2('#approval-lineRemove-dialog-accept').show();
    }
    else{
        AJS.dialog2('#approval-lineRemove-dialog-main').show();
        approvalDelRowNum = num;
    }
}


/**
 * 결재선관리 리스트 조회
 * @param item
 * @param index
 */
var viewApprovalList = function (item,index) {
    var idx = AJS.$('#approval_main tr').length;
    var table = document.getElementById("approval_main");
    var row = table.insertRow(idx);
    var number = index + Number(1);
    row.innerHTML ="<tr>\n" +
        "                <td>" + number  + "</td>\n" +
        "                <td>" + item.lineName  + "</td>\n" +
        "                <td>" + item.lineDesc  + "</td>\n" +
        "                <td>" + item.lineOrder  + "</td>\n" +
        "                <td>" + item.lineApplyInfo  + " </td>\n" +
        "                <td>\n" +
        "                    <span class=\"aui-icon aui-icon-small aui-iconfont-edit-filled\" style=\"color:blue;\" onclick=\"onClickEdit(event," + item.lineNum  + ");\">Insert meaningful text here for accessibility</span>\n" +
        "                    <span class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-down\" onClick=\"rowMoveEvent(this,'bottom');\">Insert meaningful text here for accessibility</span>\n" +
        "                    <span class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-down\" onClick=\"rowMoveEvent(this,'down');\">Insert meaningful text here for accessibility</span>\n" +
        "                    <span class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-up\" onClick=\"rowMoveEvent(this,'up');\">Insert meaningful text here for accessibility</span>\n" +
        "                    <span class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-up\" onClick=\"rowMoveEvent(this,'top');\">Insert meaningful text here for accessibility</span>\n" +
        "                    <span class=\"aui-icon aui-icon-small aui-iconfont-trash\" style=\"color:red;\" onclick=\"onClickTrash(this,event,'view'," + item.lineNum  + ");\">Insert meaningful text here for accessibility</span>\n" +
        "                </td>\n" +
        "            </tr>";
};


var openSpinner = function () {
    AJS.$('.kapp-spinner').addClass('is-active');
}

var closeSpinner = function () {
    AJS.$('.kapp-spinner').removeClass('is-active');
}

/**
 * 결재선관리 라인 편집
 * @param e
 * @param num
 */
var onClickEdit = function (e,num) {
    e.preventDefault();
    AJS.$('#approvalLine_accept').empty();
    AJS.$('#approvalLine_rows').empty();
    var data;
    /**  결재선관리 라인 편집   */
    Api.call(apiUrl.editApprovalLine(num ),'GET',data,resultEditLine);
}


var resultEditLine = function (data) {
    if(data.resultCode == 200){
        display("lineEdit");
        ApprovalEidtMode(data.resultData);
        ApprovalEidtAcceptMode(data.resultData);
    }
}

var ApprovalEidtAcceptMode = function (data) {
    var entity = data.entity;
    approvalEditKey  = entity.lineNum;

    var applyListEntity = data.applyListEntity;
    var prjList = data.prjList;
    console.log('applyListEntity',applyListEntity);

    var table = document.getElementById("approvalLine_accept");

    var num = 0;
    for(var i =0 ; i < applyListEntity.length; i++){
        num = i + Number(1);
        var row = table.insertRow(i);
        var obj = applyListEntity[i];


        row.innerHTML ="<tr>\n" +
            "                    <td>" + num  + "</td>\n" +
            "                    <td>\n" +
            "                        <aui-select \n" +
            "                                id=\"select_prj" + num + "\"\n" +
            "                                 name=\"select_prj" + num + "\"\n" +
            "                                onchange=\"select_prj(this," + num + ")\" placeholder=\"선택\">\n" +
            "                        </aui-select>\n" +
            "                    </td>\n" +
            "                    <td>\n" +
            "                        <aui-select\n" +
            "                                id=\"select_issue" + num + "\"\n" +
            "                                name=\"select_issue" + num + "\"\n" +
            "                                onchange=\"select_issue(this," + num + ")\" placeholder=\"선택\">\n" +
            "                        </aui-select>\n" +
            "                    </td>\n" +
            "                    <td>\n" +
            "                        <aui-label for=\"my-toggle\" id=\"lbl_workflow" + num + "\"></aui-label>\n" +
            "                    </td>\n" +
            "                    <td>\n" +
            "                        <aui-select \n" +
            "                                id=\"select_workflow_status" + num + "\"\n" +
            "                                onchange=\"select_workflow_status(this," + num + ")\"  name=\"select_workflow_status" + num + "\"\n" +
            "                                placeholder=\"선택\">\n" +
+
            "                        </select>\n" +
            "                    </td>\n" +
            "                    <td headers=\"basic-username\">\n" +
            "                        <aui-select \n" +
            "                                id=\"select_convert_approval" + num + "\"\n" +
            "                                onchange=\"select_convert_approval(this," + num + ")\"  name=\"select_convert_approval" + num + "\"\n" +
            "                                placeholder=\"선택\">\n" +
            "                        </aui-select>\n" +
            "                    </td>\n" +
            "                    <td headers=\"basic-username\">\n" +
            "                        <aui-select\n" +
            "                                id=\"select_return_approval" + num + "\"\n" +
            "                                onchange=\"select_return_approval(this," + num + ")\"  name=\"select_return_approval" + num + "\"\n" +
            "                                placeholder=\"선택\">\n" +
            "                        </aui-select>\n" +
            "                        <!-- <span class=\"aui-lozenge aui-lozenge-inprogress\">결재중</span> → <span class=\"aui-lozenge aui-lozenge-success\">반려</span>   -->\n" +
            "                    </td>\n" +
            "                    <td>\n" +
            "                        <aui-toggle label=\"toggle button\" id=\"acceptLine_toggle" + num + "\" ></aui-toggle>\n" +
            "                    </td>\n" +
            "                    <td headers=\"basic-username\">\n" +
            "                        <span class=\"aui-icon aui-icon-small aui-iconfont-trash\" style=\"color:red;\" onclick=\"onClickTrash(this,event,'accept','');\">Insert meaningful text here for accessibility</span>\n" +
            "                    </td>\n" +
            "                </tr>";


           approvalAcceptIdx = num;

           for(var j =0 ; j < prjList.length; j++){
               var prjobj = prjList[j];
               const host = location.protocol + "//" + location.host;
               var iconurl = host +  prjobj.icon;
               AJS.$('#select_prj' + num).append( "<aui-option img-src ='" + iconurl +"'  " + (obj.prjId == prjobj.id ? 'selected' : '') + "  value=" + prjobj.id +" >" + prjobj.name +"</aui-option>");
           }

           for(var k =0 ; k < obj.issueTypes.length; k++){
                var issue = obj.issueTypes[k];
                const host = location.protocol + "//" + location.host;
                var iconurl = host +  issue.icon;
                AJS.$('#select_issue' + num).append( "<aui-option img-src ='" + iconurl +"' " + (obj.issueTypeId == issue.id ? 'selected' : '') + " value=" + issue.id +" >" + issue.name +"</aui-option>");
           }

           AJS.$('#select_workflow_status' + num).append( "<aui-option value=" + obj.workflowstatus +"  selected > " + obj.workflowstatus +"</aui-option>");
           AJS.$('#select_convert_approval' + num).append( "<aui-option value=" + obj.convertapproval +" selected > " + obj.convertapproval +"</aui-option>");
           AJS.$('#select_return_approval' + num).append( "<aui-option value=" + obj.returnapproval +" selected > " + obj.returnapproval +"</aui-option>");
           AJS.$('#lbl_workflow' + num).val(obj.workflownm);


           var toggle = document.getElementById('acceptLine_toggle' + num);
           toggle.setAttribute('checked',true);
    }
}
var ApprovalEidtMode = function (data) {
    var entity = data.entity;
    AJS.$('#txtLineNm').val(entity.lineName);
    approvalEditKey  = entity.lineNum;

    var lineListEntity = data.lineListEntity;

    var table = document.getElementById("approvalLine_rows");

    var num = 0;
    for(var i =0 ; i < lineListEntity.length; i++){
        num = i + Number(1);
        var row = table.insertRow(i);
        var obj = lineListEntity[i];

        row.innerHTML ="<tr>\n" +
            "                        <td>" + num  + "</td>\n" +
            "                        <td>\n" +
            "                            <select \n" +
            "                                    id=\"select_approval_type" + num + "\"\n" +
            "                                    class=\"select\" name=\"product\"\n" +
            "                                    >\n" +
            "                                <option value=\"0\" >합의</option>\n" +
            "                                <option value=\"1\" >결재</option>\n" +
            "                                <option value=\"2\" >참조</option>\n" +
            "                            </select>\n" +
            "                        </td>\n" +
            "                        <td>\n" +
            "                            <input class=\"text\"  type=\"text\" value=\"" + obj.approvalOrderNm  +  "\" id=\"txt_group_nm" + num + "\"  name=\"txt_group_nm" + num + "\" title=\"Text input\" placeholder=\"합의자\">\n" +
            "                        </td>\n" +
            "                        <td>\n" +
            "                            <select class=\"select\" onchange=\"select_approvalUser_type(this," + num + ")\"\n" +
            "                                    id=\"select_approvalUser_type" + num + "\" \n" +
            "                                    name=\"select_approvalUser_type" + num + "\" >\n" +
            "                                <option value=\"0\">기안자가 직접선택</option>\n" +
            "                                <option value=\"1\">개인</option>\n" +
            "                                <option value=\"2\">역할</option>\n" +
            "                            </select>\n" +
            "                        </td>\n" +
            "                        <td>\n" +
            "                            <select \n" +
            "                                    class=\"select\" id=\"select_approvalUser_fix" + num + "\" \n" +
            "                                    name=\"select_approvalUser_fix" + num + "\">\n" +
            "                            </select>\n" +
            "                        </td>\n" +
            "                        <td>\n" +
            "                            <span onClick=\"rowMoveEvent(this,'bottom');\" class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-down\" id=\"span_bottom\">Insert meaningful text here for accessibility</span>\n" +
            "                            <span onClick=\"rowMoveEvent(this,'down');\" class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-down\" id=\"span_down\">Insert meaningful text here for accessibility</span>\n" +
            "                            <span onClick=\"rowMoveEvent(this,'up');\" class=\"aui-icon aui-icon-small aui-iconfont-new-arrow-up\" id=\"span_up\">Insert meaningful text here for accessibility</span>\n" +
            "                            <span onClick=\"rowMoveEvent(this,'top');\" class=\"aui-icon aui-icon-small aui-iconfont-chevron-double-up\" id=\"span_top\">Insert meaningful text here for accessibility</span>\n" +
            "                            <span class=\"aui-icon aui-icon-small aui-iconfont-trash\" style=\"color:red;\" onclick=\"onClickTrash(this,event,'edit','');\">Insert meaningful text here for accessibility</span>\n" +
            "                        </td>\n" +
            "                    </tr>";
         var aprvalTy;
         if(obj.approvalType == "합의"){
             aprvalTy ="0";
         }else if(obj.approvalType =="결재"){
             aprvalTy ="1";
         }else{
             aprvalTy ="2";
         }

         AJS.$('#select_approval_type' + num).val(aprvalTy);
         AJS.$('#select_approvalUser_type' + num).val(obj.approvalPosition);
         AJS.$('#select_approvalUser_fix' + num).append( "<option value=" + obj.approvalFix +"  selected > " + obj.approvalFix +"</option>");
         AJS.$('#select_approvalUser_fix' + num).val(obj.approvalFix);
    }



}

var rowMoveEvent = function (el,action) {

    if(action == 'up'){
        var $tr = AJS.$(el).parent().parent(); // 클릭한 버튼이 속한 tr 요소
        $tr.prev().before($tr); // 현재 tr 의 이전 tr 앞에 선택한 tr 넣기
    }else if(action == 'down'){
        var $tr = AJS.$(el).parent().parent(); // 클릭한 버튼이 속한 tr 요소
        $tr.next().after($tr); // 현재 tr 의 다음 tr 뒤에 선택한 tr 넣기
    }else if(action == 'top'){
        var num = el.parentNode.parentNode.rowIndex;
        console.log('num',num);
       if(num != 2){
           var $tr = AJS.$(el).closest('tr');
           $tr.closest('tbody').find('tr:first').before($tr);
       }
    }else if(action == 'bottom'){
        var num = el.parentNode.parentNode.rowIndex;
        var idx = AJS.$('#approval_main tr').length;
        var row = num - Number(1);
        if(row != idx ){
            var $tr = AJS.$(el).closest('tr');
            $tr.closest('tbody').find('tr:last').after($tr);
        }

    }
}



var setProjects = function () {
    openSpinner();

    /** 결재선 리스트 조회   */
    var data;
    Api.call(apiUrl.getProjectsList(),'GET',data,resultProjectList);
}

var resultProjectList  = function (data) {
    if(data.resultCode == 200){

        var arr = data.resultData;
        arr.forEach(function(item,index,arr2){
            console.log('resultProjectList',item);
            selectPrjList(item,index);


        });
        closeSpinner();
    }
}

var selectPrjList = function (item,index) {
    var num = index + Number(1);
    var child = AJS.$("#select_prj" + approvalAcceptIdx).children('datalist');
    const host = location.protocol + "//" + location.host;
    var iconurl = host +  item.icon;
    child.append("<aui-option img-src ='" + iconurl +"' value='" + item.id + "' selected='selected' >" + item.name + "</aui-option>");

}

var selectIsuueList = function (item,value,index) {
    var num = index + Number(1);
    var child = AJS.$("#select_issue" + approvalAcceptIdx).children('datalist');
    const host = location.protocol + "//" + location.host;
    var iconurl = host +  item.icon;
    child.append("<aui-option img-src ='" + iconurl +"' value='" + item.id + "' selected='selected' >" + item.name + "</aui-option>");
}

var resultIssueType = function (data) {

    if(data.resultCode == 200){
        console.log(data);
        var arr = data.resultData;
        arr.forEach(function(item,index,arr2){
            console.log(item,index,arr2);
            selectIsuueList(item,index,arr2);
        });

    }
}
