/**
 * 조직구성도 저장
 * @param data
 */
var saveOrgs = function (data) {
    var configData = JSON;
    configData.orglist = data;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/org/save/orgList',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(configData),
        success: function(data) {
            console.log('resultSaveAllList',data);
            resultSaveAllList(data)
        },
        error: function(data) {
            resultSaveAllList(data)
        }
    });
}

var resultSaveAllList = function (data) {
    console.log('resultSaveAllList',data);
    if (data.resultCode == 200) {
        AJS.flag(toasts.successLineSave);
        var data;
        Api.call(AJS.contextPath() + '/rest/kapproval/1.0/org/select/orgList', 'GET', data, resultGetOrgLists);
    }else{
        closeSpinner();
    }
}

var resultGetOrgLists = function (data) {
    parent.resultGetOrgList(data);
}

/**
 * 직책 저장
 * @param data
 */
var saveOrgPosition = function (data) {
    var configDataLinelist = JSON;
    configDataLinelist.lineList = data;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/org/save/position',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(configDataLinelist),
        success: function(data) {
            resultSavePositions(data)
        },
        error: function(data) {
            resultSavePositions(data)
        }
    });

}

var resultSavePositions = function (data) {
    parent.resultSavedPosition(data);
}


var doBulkApproval = function(data,approvalType,dcrmk,pw){
    var list = JSON;
    list.bulkList = data;
    list.approvalType = approvalType;
    list.dcrmk = dcrmk;
    list.pw = pw;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/config/bulk/approval',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(list),
        success: function(data) {
            resultdoBulkApproval(data)
        },
        error: function(data) {
            resultdoBulkApproval(data)
        }
    });


}
var saveOrgUserList = function(data){
    var configUserDataLinelist = JSON;
    configUserDataLinelist.lineList = data;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/org/save/userList',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(configUserDataLinelist),
        success: function(data) {
            resultSaveUserLists(data)
        },
        error: function(data) {
            resultSaveUserLists(data)
        }
    });

}

var saveSuppeusers = function(data){
    var configUserDataLinelist = JSON;
    configUserDataLinelist.lineList = data;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/setting/save/superusers',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(configUserDataLinelist),
        success: function(data) {
            resultSaveSuppeusers(data)
        },
        error: function(data) {
            resultSaveSuppeusers(data)
        }
    });

}

var resultSaveSuppeusers = function(data){
    parent.returnSaveSuppeusers(data);
}

var resultSaveUserLists = function (data) {
    parent.resultSaveUserList(data);
}


var resultdoBulkApproval = function (data) {
    parent.resultdoBulkState(data);
}


/**
 * 결재선 라인 저장
 * @param approvalEditKey
 * @param txtLineNm
 * @param txtLineDesc
 * @param v_language
 * @param data
 * @param detailConf
 * @param orgList
 * @param filed
 * @param filedValues
 * @param tpyeEditState
 * @param editSeq
 */
var saveNewConfig = function (approvalEditKey,txtLineNm,txtLineDesc,v_language,
                              data,detailConf,orgList,filed,filedValues,tpyeEditState,editSeq) {

    var configKey = JSON;
    var configDataLinelist = JSON;

    configKey.lineNum = approvalEditKey;
    configKey.lineName = txtLineNm;
    configKey.lineDesc = txtLineDesc;
    configKey.locale = v_language;
    configKey.detailConf = detailConf;
    configKey.orgList = orgList;
    configKey.filed = filed;
    configKey.filedValues = filedValues;
    configKey.tpyeEditState = tpyeEditState;
    configKey.editLineSeq = editSeq;

    configDataLinelist.lineList = data;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/config/save/approvalLine',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(configDataLinelist),
        success: function(data) {
            resultConfigs(data)
        },
        error: function(data) {
            resultConfigs(data)
        }
    });
}

var resultConfigs = function (data) {
    parent.resultApprovalConfig(data);
}

/**
 * 결재선 적용
 * @param approvalEditKey
 * @param lineList
 */
var saveNewApplyConfig = function (approvalEditKey,lineList) {
    var configAppleyKey = JSON;
    var configApplyLinelist = JSON;

    configAppleyKey.lineNum = approvalEditKey;
    configApplyLinelist.lineList = lineList;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/config/save/approvalApplyLine',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(configApplyLinelist),
        success: function(data) {
            resultApplyLines(data)
        },
        error: function(data) {
            resultApplyLines(data)
        }
    });
}

var saveLdapInfo = function (ldapInfo) {
    var ldap = JSON;
    ldap.data = ldapInfo;

    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/org/save/ldapinfo',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'PUT',
        dataType: 'json',
        data: JSON.stringify(ldap),
        success: function(data) {
            resultLdap(data)
        },
        error: function(data) {
            resultLdap(data)
        }
    });
}

var resultLdap = function (data) {
    parent.resultSaveLdapInfo(data);
}

var resultApplyLines = function (data) {
    parent.resultNewApplyLine(data);
}


var fileUploadlCall = function(csvData){
    var arryData = JSON;
    arryData.file = csvData;
    AJS.$.ajax({
        url: AJS.contextPath() + '/rest/kapproval/1.0/file/csv/upload',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json'
        },
        type: 'POST',
        dataType: 'json',
        data: JSON.stringify(arryData),
        success: function(data) {
            resultCsvDataUpload(data)
        },
        error: function(data) {
            resultCsvDataUpload(data)
        }
    });

    // var settings = {
    //     "url": AJS.contextPath() + '/rest/kapproval/1.0/file/csv/upload/test',
    //     "method": "POST",
    //     "timeout": 600000,
    //     "processData": false,
    //     "mimeType": "multipart/form-data",
    //     "contentType": false,
    //     "data": formData
    // };
    //
    // AJS.$.ajax(settings).done(function (response) {
    //     console.log(response);
    // });

}

var resultCsvDataUpload = function (data) {
    parent.resultCsvUpload(data);
}

var closeSpinner = function () {
    AJS.$('.kapp-spinner').removeClass('is-active');
}