var Api = {
    /**
     * ajax로 호출하여 데이터를 처리한다.
     * data형식 object(json형태)
     * @param callurl : string 호출 주소
     * @param type : httpmethod
     * @param data : json object
     * @param callback : callback function
     */
    call: function (callurl, type,data, callback ) {
        AJS.$.ajax({
            url : callurl,
            type : type,
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json'
            },
            data : JSON.stringify(data),
            dataType : "json",
            timeout		: 15000,
            cache: false,
            success	: function(data) {
                callback(data);
            },
            error : function(xhr, textStatus, errorThrown) {
                callback(xhr,textStatus,errorThrown);
            }
        });
    },
};