/**
 * ============================================================================
 * rest 호출 주
 *
 * @author		<A Href="mailto:jhpark@osci.kr</A>
 * @version		1.0
 * @since		1.0
 *
 * History
 * 1.0	2021. 04. 07.	jhpark	Initial Version
 * ============================================================================
 */
var ctx = AJS.contextPath();
var apiUrl = {
    saveConfig: function() {
        return ctx + '/rest/kapproval/1.0/config/save/approvalLine';
    },
    saveApplyConfig: function() {
        return ctx + '/rest/kapproval/1.0/config/save/approvalApplyLine';
    },
    getApprovalLineList: function() {
        return ctx + '/rest/kapproval/1.0/config/select/approvalList';
    },
    getPendingApprovalList: function() {
        return ctx + '/rest/kapproval/1.0/config/all/pendingList';
    },
    removeApprovalLine:function (linenum) {
        return ctx + '/rest/kapproval/1.0/config/delete/line?lineNum=' + linenum ;
    },
    editApprovalLine:function (linenum) {
        return ctx + '/rest/kapproval/1.0/config/edit/line?lineNum=' + linenum ;
    },
    saveLineName:function (lineNum,lineNm) {
        return ctx + '/rest/kapproval/1.0/config/save/line/name?lineNum=' + lineNum + '&lineNm=' + lineNm;
    },
    saveLineDesc:function (lineNum,lineDesc) {
        return ctx + '/rest/kapproval/1.0/config/save/line/desc?lineNum=' + lineNum + '&lineDesc=' + lineDesc;
    },
    getProjectsList: function() {
        return ctx + '/rest/kapproval/1.0/config/select/all/projects';
    },
    getIssueType: function(id) {
        return ctx + '/rest/kapproval/1.0/config/select/issueType?id=' + id;
    },
    getWorkflows: function(prjid,issueid) {
        return ctx + '/rest/kapproval/1.0/config/select/getWorkFlows?prjid=' + prjid +'&issueid=' + issueid;
    },
    getTransApproval: function(id,value,workflowNm) {
        return ctx + '/rest/kapproval/1.0/config/select/getTransApproval?id=' + id +'&value=' + value +'&workflowNm=' + workflowNm;
    },
    getOrgMemberInfo: function(username) {
        return ctx + '/rest/kapproval/1.0/org/user/search/info?username=' + username;
    },
    getMemberInfoModify: function(username) {
        return ctx + '/rest/kapproval/1.0/org/user/search/info/modify?username=' + username;
    },
    savePosition: function() {
        return ctx + '/rest/kapproval/1.0/org/save/position';
    },
    saveUserList: function() {
        return ctx + '/rest/kapproval/1.0/org/save/userList';
    },
    saveOrgList: function() {
        return ctx + '/rest/kapproval/1.0/org/save/orgList';
    },
    getAlluserList: function(page) {
        return ctx + '/rest/kapproval/1.0/org/user/getAllUser?page=' + page;
    },
    getAllPosition: function() {
        return ctx + '/rest/kapproval/1.0/org/select/position';
    },
    getCustomField: function() {
        return ctx + '/rest/kapproval/1.0/org/all/customfield';
    },
    deletePosition: function(id) {
        return ctx + '/rest/kapproval/1.0/org/remove/position?id=' + id;
    },
    getLocale: function() {
        return ctx + '/rest/kapproval/1.0/org/select/getLanguage';
    },
    getMemberSearch: function(option,value) {
        return ctx + '/rest/kapproval/1.0/org/user/search/info?option=' + option +'&value=' + value;
    },
    getAllReport: function(page,start_date,end_date) {
        return ctx + '/rest/kapproval/1.0/report/get/all/Report?pagecnt=' + page + '&start_date=' + start_date + '&end_date=' + end_date;
    },
    getReoportSearch: function(option,value,start_date,end_date) {
        return ctx + '/rest/kapproval/1.0/report/search/info?option=' + option +'&value=' + value + '&start_date=' + start_date + '&end_date=' + end_date;
    },
    getSelectOrgList: function() {
        return ctx + '/rest/kapproval/1.0/org/select/orgList';
    },
    getSelectJiraFiledList: function() {
        return ctx + '/rest/kapproval/1.0/org/select/jiraFileds';
    },
    getJiraFiledValueList: function(filed) {
        return ctx + '/rest/kapproval/1.0/org/select/jiraFiledsValue?filed=' + filed;
    },
    getApprovalTypelist: function(lineNum) {
        return ctx + '/rest/kapproval/1.0/org/select/apprvoalTypelist?lineNum=' + lineNum;
    },
    getEditTypelLine: function(seq) {
        return ctx + '/rest/kapproval/1.0/config/select/getEditTypelLine?seq=' + seq;
    },
    removeTypeLine: function(seq) {
        return ctx + '/rest/kapproval/1.0/config/delete/removeTypeLine?seq=' + seq;
    },
    editApprovalAllLine:function (linenum) {
        return ctx + '/rest/kapproval/1.0/config/editAll/line?lineNum=' + linenum ;
    },
    setSettingLineType: function(typeValue) {
        return ctx + '/rest/kapproval/1.0/setting/save/LineType?typeValue=' + typeValue;
    },
    setSettingPasswordUse: function(typeValue) {
        return ctx + '/rest/kapproval/1.0/setting/save/passwordtype?typeValue=' + typeValue;
    },
    getSettingInit: function() {
        return ctx + '/rest/kapproval/1.0/setting/get/settingInfo';
    },
    deleteSuperuser: function(id) {
        return ctx + '/rest/kapproval/1.0/setting/remove/superuser?id=' + id;
    },
    getAllSuperUsers: function() {
        return ctx + '/rest/kapproval/1.0/setting/all/superuser';
    },

}

