/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.utills;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.utills.StringUtil;

public class ValidationUtil {
    public static boolean checkContainsKey(String requirementKey, HashMap param) {
        boolean flag = false;
        if (param == null) {
            return false;
        }
        if (param.containsKey(requirementKey) && !StringUtil.fixNull(param.get(requirementKey)).equals("")) {
            flag = true;
        }
        return flag;
    }

    public static boolean checkContainsKeys(String[] requirementKeys, HashMap param) {
        if (param == null) {
            return false;
        }
        for (String requirementKey : requirementKeys) {
            boolean flag = false;
            for (Object key : param.keySet()) {
                String stringKey = StringUtil.fixNull(key.toString());
                if (!requirementKey.equals(stringKey) || StringUtil.fixNull(param.get(key)).equals("")) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAnyContainsKeys(String[] keys, HashMap<String, Object> param) {
        if (param == null) {
            return false;
        }
        for (String key : keys) {
            if (!param.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static KappResult checkContainsKeysValue(String[] requirementKeys, HashMap param) {
        KappResult kappResult = new KappResult();
        String emptyList = "";
        if (param == null) {
            kappResult.setResultCode(400);
            kappResult.setResultMsg("Parameter Is Not Valid. Parameter is null ]");
        }
        for (String requirementKey : requirementKeys) {
            boolean flag = false;
            for (Object key : param.keySet()) {
                String stringKey = StringUtil.fixNull(key.toString());
                if (!requirementKey.equals(stringKey) || StringUtil.fixNull(param.get(key)).equals("")) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            emptyList = emptyList.isEmpty() ? "[" + requirementKey : emptyList + ", " + requirementKey;
        }
        if (!emptyList.isEmpty()) {
            kappResult.setResultCode(400);
            kappResult.setResultMsg("Parameter Is Not Valid. " + emptyList + "]");
        }
        return kappResult;
    }

    public static boolean checkDuplicate3Character(String d) {
        int p = d.length();
        byte[] b = d.getBytes();
        for (int i = 0; i < p * 2 / 3; ++i) {
            byte b1 = b[i + 1];
            byte b2 = b[i + 2];
            if (b[i] != b1 || b[i] != b2) continue;
            return true;
        }
        return false;
    }

    public static HashMap<String, Object> checkContainKeyFillValue(String requirementKey, HashMap<String, Object> param) {
        if (param == null) {
            return null;
        }
        if (!param.containsKey(requirementKey)) {
            param.put(requirementKey, "");
        }
        return param;
    }

    public static HashMap<String, Object> checkContainKeysFillValue(String[] requirementKeys, HashMap<String, Object> param) {
        if (param == null) {
            return null;
        }
        for (String requirementKey : requirementKeys) {
            if (param.containsKey(requirementKey)) continue;
            param.put(requirementKey, "");
        }
        return param;
    }

    public static HashMap<String, Object> checkContainKeysCopyMap(String[] requirementKeys, HashMap<String, Object> param) {
        if (param == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String requirementKey : requirementKeys) {
            if (!param.containsKey(requirementKey)) {
                result.put(requirementKey, "");
                continue;
            }
            result.put(requirementKey, param.get(requirementKey));
        }
        return result;
    }

    public static boolean checkListData(List list) {
        boolean isCheck = false;
        if (list != null && list.size() > 0) {
            isCheck = true;
        }
        return isCheck;
    }

    public static boolean checkPermissionServiceCode(HttpServletRequest request, String[] service_code_list) {
        String service_code = "";
        try {
            service_code = StringUtil.fixNull(request.getHeader("service-code"));
        }
        catch (Exception e) {
            return false;
        }
        if ("".equals(service_code)) {
            return false;
        }
        for (String serviceCode : service_code_list) {
            if (!service_code.equals(serviceCode)) continue;
            return true;
        }
        return false;
    }

    public static Map convertObjectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            try {
                map.put(fields[i].getName(), fields[i].get(obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

