/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.utills;

import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class PageBean<t> {
    private final URI self;
    private final URI nextPage;
    private final int maxResults;
    private final long startAt;
    private final Long total;
    private final Boolean isLast;
    private final List<t> values;

    public PageBean(URI self, URI nextPage, int maxResults, long startAt, Long total, Boolean isLastPage, List<t> values) {
        this.self = self;
        this.nextPage = nextPage;
        this.maxResults = maxResults;
        this.startAt = startAt;
        this.total = total;
        this.isLast = isLastPage;
        this.values = values;
    }

    public URI getSelf() {
        return this.self;
    }

    public URI getNextPage() {
        return this.nextPage;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public long getStartAt() {
        return this.startAt;
    }

    public Long getTotal() {
        return this.total;
    }

    public Boolean getIsLast() {
        return this.isLast;
    }

    public List<t> getValues() {
        return this.values;
    }

    public static <t> Builder<t> from(PageRequest request, Page<t> response) {
        return new Builder<t>(request, response);
    }

    public static final class Builder<t> {
        private final long startAt;
        private final Long total;
        private final int maxResults;
        private Boolean isLastPage;
        private final List<t> values;
        private URI self;
        private URI nextPage;

        public Builder(PageRequest request, Page<t> response) {
            this.maxResults = request.getLimit();
            this.startAt = response.getStart();
            this.total = response.getTotal();
            this.values = response.getValues();
            this.isLastPage = response.isLast();
        }

        public Builder<t> setLinks(String self, int limit) {
            this.self = UriBuilder.fromUri((String)self).replaceQueryParam("startAt", new Object[]{this.startAt}).replaceQueryParam("maxResults", new Object[]{limit}).build(new Object[0]);
            if (!this.isLastPage.booleanValue()) {
                this.nextPage = UriBuilder.fromUri((String)self).replaceQueryParam("startAt", new Object[]{this.startAt + (long)this.values.size()}).replaceQueryParam("maxResults", new Object[]{limit}).build(new Object[0]);
            }
            return this;
        }

        public <e> PageBean<e> build(Function<t, e> toBeanFunction) {
            List beans = this.values.stream().map(toBeanFunction).collect(Collectors.toList());
            return new PageBean(this.self, this.nextPage, this.maxResults, this.startAt, this.total, this.isLastPage, beans);
        }
    }
}

