/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.userprofile;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import javax.annotation.Nullable;

public class UserData {
    private static final String MRIM_LOGIN_USER_PROPERTY = "USER_MRIM_LOGIN";
    private static final String IS_ENABLED_USER_PROPERTY = "USER_MRIM_STATUS";
    private final UserPropertyManager userPropertyManager;
    private final UserSearchService userSearchService;

    public UserData(UserPropertyManager userPropertyManager, UserSearchService userSearchService) {
        this.userPropertyManager = userPropertyManager;
        this.userSearchService = userSearchService;
    }

    public String getMrimLogin(ApplicationUser user) {
        String mrimLogin = this.userPropertyManager.getPropertySet(user).getString(MRIM_LOGIN_USER_PROPERTY);
        if (mrimLogin == null) {
            mrimLogin = user.getEmailAddress();
        }
        return mrimLogin;
    }

    public void setMrimLogin(ApplicationUser user, String mrimLogin) {
        this.userPropertyManager.getPropertySet(user).setString(MRIM_LOGIN_USER_PROPERTY, mrimLogin);
    }

    public boolean isEnabled(ApplicationUser user) {
        String enabled = this.userPropertyManager.getPropertySet(user).getString(IS_ENABLED_USER_PROPERTY);
        if (enabled == null) {
            return false;
        }
        return Boolean.parseBoolean(enabled);
    }

    public void setEnabled(ApplicationUser user, boolean enabled) {
        this.userPropertyManager.getPropertySet(user).setString(IS_ENABLED_USER_PROPERTY, Boolean.toString(enabled));
    }

    @Nullable
    public ApplicationUser getUserByMrimLogin(String mrimLogin) {
        return null;
    }
}

