/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.servlets;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.applyListEntity;
import kr.osci.apps.kapproval.service.impl.configServiceImpl;
import net.java.ao.Query;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class emailServlet
extends HttpServlet {
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudo;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final ProjectManager projectManager;
    @ComponentImport
    protected final LocaleManager localeManager;
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final WorkflowSchemeManager workflowSchemeManager;
    @Autowired
    private configServiceImpl configService;

    @Inject
    public emailServlet(TemplateRenderer renderer, WebSudoManager webSudo, ProjectManager projectManager, LocaleManager localeManager, configServiceImpl configService2, PluginLicenseManager licenseManager, ActiveObjects activeObjects, WorkflowSchemeManager workflowSchemeManager, IssueManager issueManager) {
        this.renderer = renderer;
        this.webSudo = webSudo;
        this.licenseManager = licenseManager;
        this.activeObjects = activeObjects;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.localeManager = localeManager;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        resp.setContentType("text/html;charset=utf-8");
        try {
            String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
            HttpServletRequest httpRequest = req;
            String issuekey = httpRequest.getParameter("issuekey");
            String ty = httpRequest.getParameter("ty");
            String userkey = httpRequest.getParameter("userkey");
            MutableIssue issue = this.issueManager.getIssueObject(issuekey);
            ApplicationUser currentUser = ComponentAccessor.getUserManager().getUserByKey(userkey);
            if (issue == null) {
                this.renderer.render("views/email.vm", map, (Writer)resp.getWriter());
                return;
            }
            Locale locale = this.localeManager.getLocaleFor(currentUser);
            String language = locale.getLanguage();
            KappResult result = this.configService.externalApproval(ty, issuekey, userkey, "Email", "");
            map.put("resultCode", result.getResultCode());
            map.put("resultMsg", result.getResultMsg());
            map.put("status", issue.getStatus().getName());
            map.put("prj", issue.getProjectObject().getName());
            map.put("summary", issue.getSummary().toString());
            map.put("createdate", issue.getCreated().toLocalDateTime());
            map.put("baseUrl", baseUrl);
            map.put("language", language);
            map.put("issuekey", issuekey);
            map.put("ty", ty);
            map.put("userkey", userkey);
            map.put("imageKeyPath", "kr.osci.apps.kapproval_jira");
            this.renderer.render("views/email.vm", map, (Writer)resp.getWriter());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.renderer.render("views/email.vm", map, (Writer)resp.getWriter());
            return;
        }
        catch (KappExceptionHandler kappExceptionHandler) {
            kappExceptionHandler.printStackTrace();
            this.renderer.render("views/email.vm", map, (Writer)resp.getWriter());
            return;
        }
    }

    public String warkstatusName(String prjNm, String issueNm, String workflnm, String statusid) throws Exception {
        String workStatus = "";
        applyListEntity[] applyListEntities = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ?", new Object[]{prjNm, issueNm, workflnm}));
        if (Arrays.asList(applyListEntities).size() > 0) {
            for (applyListEntity applyListEntity2 : Arrays.asList(applyListEntities)) {
                if (!statusid.equals("")) {
                    int approvalStatusid = applyListEntity2.getWorkFlowStatusid();
                    if (Integer.parseInt(statusid) > approvalStatusid) continue;
                    workStatus = applyListEntity2.getWorkFlowStatus();
                    break;
                }
                workStatus = applyListEntity2.getWorkFlowStatus();
            }
        }
        return workStatus;
    }
}

