/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.servlets;

import com.atlassian.plugin.servlet.PluginHttpRequestWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Named
@MultipartConfig
public class FileUploadServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(FileUploadServlet.class);
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudo;

    @Inject
    public FileUploadServlet(TemplateRenderer renderer, WebSudoManager webSudo) {
        this.renderer = renderer;
        this.webSudo = webSudo;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            PluginHttpRequestWrapper prw = (PluginHttpRequestWrapper)req;
            HttpServletRequest multReq = req;
            MultipartHttpServletRequest mult = (MultipartHttpServletRequest)multReq;
            List files = mult.getFiles("file");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(0x1400000L);
            List fileItems = upload.parseRequest(req);
            FileItem file = (FileItem)fileItems.get(0);
            try (InputStream source = file.getInputStream();){
                log.debug("Request content type: " + req.getContentType());
                log.debug("Request parameterMap size: " + req.getParameterMap().size());
                log.debug("Request parts size: " + req.getParts().size());
                Part filePart = req.getPart("file");
                String fileName = Paths.get(FileUploadServlet.getSubmittedFileName(filePart), new String[0]).getFileName().toString();
                InputStream inputStream = filePart.getInputStream();
            }
            catch (ServletException e) {
                log.error("Error creating escalate rules.", (Throwable)e);
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    private static String getSubmittedFileName(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String fileName = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return fileName.substring(fileName.lastIndexOf(47) + 1).substring(fileName.lastIndexOf(92) + 1);
        }
        return null;
    }
}

