/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.issueMngEntity;
import kr.osci.apps.kapproval.entity.replaceUserEntity;
import kr.osci.apps.kapproval.entity.signUserMng;
import kr.osci.apps.kapproval.entity.signUserMngEntity;
import kr.osci.apps.kapproval.service.reportService;
import net.java.ao.Preload;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Named
@Preload
public class reportServiceImpl
implements reportService {
    private static final Logger log = LoggerFactory.getLogger(reportServiceImpl.class);
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public reportServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public KappResult getAllReportData(int pagecnt, String stdate, String eddate) throws KappExceptionHandler, Exception {
        return this.searchAllReport(pagecnt, stdate, eddate);
    }

    @Override
    public KappResult getReoportSearch(String option, String value, String stdate, String eddate) throws KappExceptionHandler, Exception {
        return this.searchReport(option, value, stdate, eddate);
    }

    private KappResult searchReport(String option, String value, String stdate, String eddate) throws Exception {
        KappResult ka = new KappResult();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<signUserMng> arraySignList = new ArrayList<signUserMng>();
        signUserMngEntity[] signUserMngEntitys = null;
        List pageResult = new ArrayList();
        if (option.equals("issueType")) {
            signUserMngEntitys = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_NAME like ? AND DATATIME BETWEEN ?::timestamp AND ?::timestamp", new Object[]{"%" + value + "%", stdate, eddate}));
        } else if (option.equals("approvalPathname")) {
            try {
                signUserMngEntitys = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("LINE_NAME LIKE ? AND DATATIME BETWEEN ?::timestamp AND ?::timestamp", new Object[]{"%" + value + "%", stdate, eddate}));
            }
            catch (Exception e) {
                log.error("signUserMngEntitys error  ::::::" + e.getMessage());
                e.printStackTrace();
            }
        }
        for (void var13_16 : signUserMngEntitys) {
            signUserMng sm = new signUserMng();
            String regDatetime = sdf.format(var13_16.getDatatime());
            sm.setPkid(var13_16.getID());
            sm.setApprovalType(var13_16.getApprovalType());
            sm.setApprovalUser(var13_16.getApprovalUser());
            sm.setApprovalOrderNm(var13_16.getApprovalOrderNm());
            sm.setApprvoalUserkey(var13_16.getApprvoalUserkey());
            sm.setReplaceUser(this.getReplaceUser(var13_16.getApprvoalUserkey(), "display"));
            sm.setReplaceUserKey(this.getReplaceUser(var13_16.getApprvoalUserkey(), "key"));
            sm.setYnReplaceApprvoal(var13_16.getYnReplaceApprvoal());
            sm.setLastApprovalUser(var13_16.getLastApprovalUser());
            sm.setYnCompleted(var13_16.getYnCompleted());
            sm.setDatatime(var13_16.getDatatime());
            sm.setDcRmk(var13_16.getDcRmk());
            sm.setStatus(var13_16.getStatus());
            sm.setWorkflowStatusId(var13_16.getWorkflowStatusId());
            sm.setIssueid(var13_16.getIssueid());
            sm.setIssueKey(var13_16.getIssueKey());
            sm.setLineNum(var13_16.getLineNum());
            sm.setPrjid(var13_16.getPrjid());
            sm.setApprovalTime(regDatetime);
            sm.setButtonStatus(var13_16.getButtonStatus());
            sm.setPrjName(var13_16.getPrjName());
            sm.setIssueName(var13_16.getIssueName());
            sm.setLineName(var13_16.getLineName());
            arraySignList.add(sm);
        }
        Collections.sort(arraySignList, new Comparator<signUserMng>(){

            @Override
            public int compare(signUserMng b1, signUserMng b2) {
                return b2.getPkid() - b1.getPkid();
            }
        });
        PageRequest pageRequest = PageRequests.request((Long)0L, (Integer)10);
        Page isuePage = Pages.toPage(arraySignList, (PageRequest)pageRequest);
        pageResult = isuePage.getValues();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("TOTAL_COUNT", isuePage.getTotal());
        map.put("TOTAL_PAGE", Integer.valueOf((int)Math.ceil((double)isuePage.getTotal().longValue() * 1.0 / (double)isuePage.getSize())));
        map.put("PAGE_SIZE", Integer.valueOf(isuePage.getSize()));
        map.put("PAGE_START", Long.valueOf(isuePage.getStart()));
        map.put("NEXT", Boolean.valueOf(isuePage.isLast()));
        map.put("arraySignList", (Serializable)((Object)pageResult));
        ka.setResultData(map);
        return ka;
    }

    private KappResult searchAllReport(int pagecnt, String stdate, String eddate) throws Exception {
        KappResult ka = new KappResult();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List pageResult = new ArrayList();
        ArrayList arraySignList = new ArrayList();
        issueMngEntity[] issueMngEntities = (issueMngEntity[])this.activeObjects.find(issueMngEntity.class);
        Arrays.asList(issueMngEntities).stream().forEach(entity -> {
            signUserMngEntity[] signUserMngEntitys;
            for (signUserMngEntity se : signUserMngEntitys = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND DATATIME BETWEEN ?::timestamp AND ?::timestamp", new Object[]{entity.getIssueKey(), stdate, eddate}))) {
                signUserMng sm = new signUserMng();
                String regDatetime = sdf.format(se.getDatatime());
                sm.setPkid(se.getID());
                sm.setApprovalType(se.getApprovalType());
                sm.setApprovalUser(se.getApprovalUser());
                sm.setApprovalOrderNm(se.getApprovalOrderNm());
                sm.setApprvoalUserkey(se.getApprvoalUserkey());
                try {
                    sm.setReplaceUser(this.getReplaceUser(se.getApprvoalUserkey(), "display"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    sm.setReplaceUserKey(this.getReplaceUser(se.getApprvoalUserkey(), "key"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sm.setYnReplaceApprvoal(se.getYnReplaceApprvoal());
                sm.setLastApprovalUser(se.getLastApprovalUser());
                sm.setYnCompleted(se.getYnCompleted());
                sm.setDatatime(se.getDatatime());
                sm.setDcRmk(se.getDcRmk());
                sm.setStatus(se.getStatus());
                sm.setWorkflowStatusId(se.getWorkflowStatusId());
                sm.setIssueid(se.getIssueid());
                sm.setIssueKey(se.getIssueKey());
                sm.setLineNum(se.getLineNum());
                sm.setPrjid(se.getPrjid());
                sm.setApprovalTime(regDatetime);
                sm.setButtonStatus(se.getButtonStatus());
                sm.setPrjName(se.getPrjName());
                sm.setIssueName(se.getIssueName());
                sm.setLineName(se.getLineName());
                sm.setApprovalPath(se.getApprovalPath());
                arraySignList.add(sm);
            }
        });
        Collections.sort(arraySignList, new Comparator<signUserMng>(){

            @Override
            public int compare(signUserMng b1, signUserMng b2) {
                return b2.getPkid() - b1.getPkid();
            }
        });
        PageRequest pageRequest = PageRequests.request((Long)Long.valueOf(pagecnt), (Integer)10);
        Page isuePage = Pages.toPage(arraySignList, (PageRequest)pageRequest);
        pageResult = isuePage.getValues();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("TOTAL_COUNT", isuePage.getTotal());
        map.put("TOTAL_PAGE", Integer.valueOf((int)Math.ceil((double)isuePage.getTotal().longValue() * 1.0 / 10.0)));
        map.put("PAGE_SIZE", Integer.valueOf(isuePage.getSize()));
        map.put("PAGE_START", Long.valueOf(isuePage.getStart()));
        map.put("NEXT", Boolean.valueOf(isuePage.isLast()));
        map.put("arraySignList", (Serializable)((Object)pageResult));
        ka.setResultData(map);
        return ka;
    }

    private String getReplaceUser(String userkey, String ty) throws Exception {
        replaceUserEntity[] replaceUserEntities = (replaceUserEntity[])this.activeObjects.find(replaceUserEntity.class, Query.select().where("LOGIN_USERKEY = ? ", new Object[]{userkey}));
        String retValue = new String();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (replaceUserEntity entity : replaceUserEntities) {
            ApplicationUser appuser = ComponentAccessor.getUserManager().getUserByKey(entity.getReplaceUserkey());
            retValue = ty.equals("key") ? appuser.getKey() : appuser.getDisplayName();
        }
        return retValue;
    }
}

