/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.replaceUserEntity;
import kr.osci.apps.kapproval.entity.replaceUserMng;
import kr.osci.apps.kapproval.service.impl.configServiceImpl;
import kr.osci.apps.kapproval.service.profileService;
import net.java.ao.DBParam;
import net.java.ao.Preload;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Named
@Preload
public class profileServiceImpl
implements profileService {
    private static final Logger log = LoggerFactory.getLogger(profileServiceImpl.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @Autowired
    private configServiceImpl configService;

    @Inject
    public profileServiceImpl(ActiveObjects activeObjects, configServiceImpl configService2) {
        this.configService = configService2;
        this.activeObjects = activeObjects;
    }

    @Override
    public KappResult uploadFile(MultipartFile multipartFile) throws KappExceptionHandler, Exception {
        return this.saveFile(multipartFile);
    }

    @Override
    public KappResult saveReplaceInfo(Object obj) throws KappExceptionHandler, Exception {
        return this.saveReplaceConf(obj);
    }

    @Override
    public KappResult getReplaceInfo() throws KappExceptionHandler, Exception {
        return this.selectReplaceInfo();
    }

    private KappResult selectReplaceInfo() throws KappExceptionHandler, Exception {
        KappResult ka = new KappResult();
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        replaceUserEntity[] replaceUserEntities = (replaceUserEntity[])this.activeObjects.find(replaceUserEntity.class, Query.select().where("LOGIN_USERKEY = ? ", new Object[]{appUser.getKey()}));
        if (replaceUserEntities.length > 0) {
            for (replaceUserEntity entity : replaceUserEntities) {
                replaceUserMng user = new replaceUserMng();
                user.setEndDate(entity.getEndDate());
                user.setStartDate(entity.getStartDate());
                user.setReplaceUserName(entity.getReplaceUserName());
                user.setReplaceUserkey(entity.getReplaceUserkey());
                ka.setResultData(user);
            }
        }
        return ka;
    }

    private KappResult saveReplaceConf(Object obj) throws KappExceptionHandler, Exception {
        KappResult ka = new KappResult();
        String stDate = (String)((LinkedHashMap)obj).get("stDate");
        String edDate = (String)((LinkedHashMap)obj).get("edDate");
        String replaceUserName = (String)((LinkedHashMap)obj).get("replaceUserName");
        String replaceUserKey = (String)((LinkedHashMap)obj).get("replaceUserKey");
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        String loginUsernm = appUser.getUsername();
        String loginUserKey = appUser.getKey();
        replaceUserEntity[] replaceUserEntities = (replaceUserEntity[])this.activeObjects.find(replaceUserEntity.class, Query.select().where("LOGIN_USERKEY = ? ", new Object[]{loginUserKey}));
        if (replaceUserEntities.length > 0) {
            for (replaceUserEntity info : replaceUserEntities) {
                info.setReplaceUserName(replaceUserName);
                info.setReplaceUserkey(replaceUserKey);
                info.setStartDate(stDate.replace("-", ""));
                info.setEndDate(edDate.replace("-", ""));
                info.setRegDate(new Date(System.currentTimeMillis()));
                info.setLoginUserName(loginUsernm);
                info.save();
            }
        } else {
            replaceUserEntity entity = (replaceUserEntity)this.activeObjects.create(replaceUserEntity.class, new DBParam[0]);
            entity.setLoginUserName(loginUsernm);
            entity.setLoginUserkey(loginUserKey);
            entity.setStartDate(stDate.replace("-", ""));
            entity.setEndDate(edDate.replace("-", ""));
            entity.setReplaceUserkey(replaceUserKey);
            entity.setReplaceUserName(replaceUserName);
            entity.setRegDate(new Date(System.currentTimeMillis()));
            entity.save();
        }
        return ka;
    }

    private KappResult saveFile(MultipartFile multipartFile) {
        KappResult ka = new KappResult();
        return ka;
    }
}

