/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.ConfigDetail;
import kr.osci.apps.kapproval.entity.ConfigDetailEntity;
import kr.osci.apps.kapproval.entity.ConfigFileds;
import kr.osci.apps.kapproval.entity.ConfigFiledsEntity;
import kr.osci.apps.kapproval.entity.LineList;
import kr.osci.apps.kapproval.entity.LineListEntity;
import kr.osci.apps.kapproval.entity.LineSeqEntity;
import kr.osci.apps.kapproval.entity.SettingEntity;
import kr.osci.apps.kapproval.entity.SettingMng;
import kr.osci.apps.kapproval.entity.config;
import kr.osci.apps.kapproval.entity.configEntity;
import kr.osci.apps.kapproval.entity.orgEntity;
import kr.osci.apps.kapproval.entity.orgMng;
import kr.osci.apps.kapproval.entity.orgPosiEntity;
import kr.osci.apps.kapproval.entity.orgUserEntity;
import kr.osci.apps.kapproval.entity.orgUserMng;
import kr.osci.apps.kapproval.entity.signUserMngEntity;
import kr.osci.apps.kapproval.jobs.LdapSyncScheduler;
import kr.osci.apps.kapproval.service.impl.SettingServiceImpl;
import kr.osci.apps.kapproval.service.orgService;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@Named
@Preload
public class orgServiceImpl
implements orgService {
    private static final Logger log = LoggerFactory.getLogger(orgServiceImpl.class);
    private static final String CSV_DEPARTMENT_DATA_NAME = "K-Approval Orgnization Import Department Data";
    private static final String CSV_USER_DATA_NAME = "K-Approval Orgnization Import User Data";
    private static final String CUSTOM_USERPICKER_KEY = "com.atlassian.jira.plugin.system.customfieldtypes:userpicker";
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserSearchService userSearchService;
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final FieldManager fieldManager;
    private LdapSyncScheduler ldapSyncSchedulerJob;
    private ApplicationContext context;
    @ComponentImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final AvatarService avatarService;
    @Autowired
    private SettingServiceImpl settingService;

    @Inject
    public orgServiceImpl(ActiveObjects activeObjects, GroupManager groupManager, AvatarService avatarService, UserSearchService userSearchService, LocaleManager localeManager, SchedulerService schedulerService, FieldManager fieldManager, SettingServiceImpl settingService, ApplicationContext context) {
        this.activeObjects = activeObjects;
        this.groupManager = groupManager;
        this.userSearchService = userSearchService;
        this.localeManager = localeManager;
        this.fieldManager = fieldManager;
        this.settingService = settingService;
        this.context = context;
        this.schedulerService = schedulerService;
        this.avatarService = avatarService;
    }

    @Override
    public KappResult getMemberInfo(String option, String value) throws KappExceptionHandler, Exception {
        return this.searchUserInfo(option, value);
    }

    @Override
    public KappResult getAllUser(int page) throws KappExceptionHandler, Exception {
        return this.searchAlluser(page);
    }

    @Override
    public KappResult saveUserList(Object obj) throws KappExceptionHandler, Exception {
        return this.setUserList(obj);
    }

    @Override
    public KappResult updateUser(Object obj) throws KappExceptionHandler, Exception {
        return this.ChangeUser(obj);
    }

    @Override
    public KappResult saveOrgList(Object obj) throws KappExceptionHandler, Exception {
        return this.setOrgList(obj);
    }

    @Override
    public KappResult getOrgList() throws KappExceptionHandler, Exception {
        return this.searchOrgList();
    }

    @Override
    public KappResult getjiraAllFileds() throws KappExceptionHandler, Exception {
        return this.searchJiraFileList();
    }

    @Override
    public KappResult getjiraFiledValue(String fieldName) throws KappExceptionHandler, Exception {
        return this.searchJiraFiledValue(fieldName);
    }

    @Override
    public KappResult getTypelist(String lineNum) throws KappExceptionHandler, Exception {
        return this.searchTypelist(lineNum);
    }

    @Override
    public KappResult getOrgTeamUsers(String name) throws KappExceptionHandler, Exception {
        return this.getTeamUsers(name);
    }

    @Override
    public KappResult deletePosition(String id) throws KappExceptionHandler, Exception {
        return this.removePosition(id);
    }

    @Override
    public KappResult getLocale() throws KappExceptionHandler, Exception {
        return this.getLanguage();
    }

    @Override
    public KappResult getLdapinfo() throws KappExceptionHandler, Exception {
        return this.getLdapContent();
    }

    @Override
    public KappResult saveCsvData(Object jsonObject) throws KappExceptionHandler, Exception {
        return this.saveCsvJosnData(jsonObject);
    }

    @Override
    public KappResult saveLdapBaseInfo(Object data) throws KappExceptionHandler, Exception {
        return this.setLdapBaseData(data);
    }

    @Override
    public KappResult savePosition(Object obj) throws KappExceptionHandler, Exception {
        return this.setPosition(obj);
    }

    @Override
    public KappResult getPosition() throws KappExceptionHandler, Exception {
        return this.selectAllPosition();
    }

    @Override
    public KappResult getCustomfields() throws KappExceptionHandler, Exception {
        return this.selectAllCustomUserPickerFields();
    }

    private KappResult saveCsvJosnData(Object jsonObject) throws Exception {
        KappResult res = new KappResult();
        ArrayList fileList = (ArrayList)((LinkedHashMap)jsonObject).get("file");
        if (fileList.size() <= 0) {
            throw new IllegalArgumentException("size is 0");
        }
        String csvTy = (String)((ArrayList)fileList.get(0)).get(0);
        fileList.removeIf(idx -> ((ArrayList)idx).get(0).equals("No") || ((ArrayList)idx).get(0).equals(CSV_DEPARTMENT_DATA_NAME) || ((ArrayList)idx).get(0).equals(CSV_USER_DATA_NAME) || ((ArrayList)idx).get(0).equals(""));
        if (csvTy.equals(CSV_DEPARTMENT_DATA_NAME)) {
            this.saveDepartmentCsvData(fileList);
        } else if (csvTy.equals(CSV_USER_DATA_NAME)) {
            this.saveUserCsvData(fileList);
        }
        return res;
    }

    private void saveUserCsvData(ArrayList filelist) throws Exception {
        orgPosiEntity[] entity;
        for (orgPosiEntity ae : entity = (orgPosiEntity[])this.activeObjects.find(orgPosiEntity.class)) {
            this.activeObjects.delete(new RawEntity[]{ae});
            this.activeObjects.flushAll();
        }
        filelist.forEach(item -> {
            String no = (String)((ArrayList)item).get(0);
            String dept = (String)((ArrayList)item).get(1);
            String userName = (String)((ArrayList)item).get(2);
            String role = (String)((ArrayList)item).get(3);
            String leaderYn = (String)((ArrayList)item).get(4);
            String email = (String)((ArrayList)item).get(5);
            ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByName(userName);
            if (appUser != null) {
                orgPosiEntity posiEntity = (orgPosiEntity)this.activeObjects.create(orgPosiEntity.class, new DBParam[0]);
                posiEntity.setPositionid(posiEntity.getID());
                posiEntity.setPosition(role);
                posiEntity.save();
                orgUserEntity[] oe = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("USERNAME = ? ", new Object[]{userName}));
                String userKey = appUser.getKey();
                if (oe.length > 0) {
                    for (orgUserEntity orgUserEntity2 : oe) {
                        orgUserEntity2.setUsername(userName);
                        orgUserEntity2.setPosition(role);
                        orgUserEntity2.setOrgname(dept);
                        orgUserEntity2.setOrgYn(leaderYn);
                        orgUserEntity2.setUserKey(userKey);
                        orgUserEntity2.setEmail(email);
                        orgUserEntity2.setUsertype("csvuser");
                        orgUserEntity2.save();
                    }
                } else {
                    orgUserEntity orgUserEntity3 = (orgUserEntity)this.activeObjects.create(orgUserEntity.class, new DBParam[0]);
                    orgUserEntity3.setPosition(role);
                    orgUserEntity3.setOrgname(dept);
                    orgUserEntity3.setOrgYn(leaderYn);
                    orgUserEntity3.setUsername(userName);
                    orgUserEntity3.setUserKey(userKey);
                    orgUserEntity3.setEmail(email);
                    orgUserEntity3.setUsertype("csvuser");
                    orgUserEntity3.save();
                }
            }
        });
    }

    private void saveDepartmentLDapData(List<orgMng> groupList) throws Exception {
        orgEntity[] orgEntities;
        for (orgEntity ae : orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class)) {
            this.activeObjects.delete(new RawEntity[]{ae});
            this.activeObjects.flushAll();
        }
        AtomicInteger idx = new AtomicInteger();
        groupList.stream().sorted(Comparator.comparing(orgMng::getid)).forEach(item -> {
            idx.addAndGet(1);
            String dept = item.getname();
            AtomicInteger orgid = idx;
            orgEntity orgEntity2 = (orgEntity)this.activeObjects.create(orgEntity.class, new DBParam[0]);
            orgEntity2.setOrgid(Integer.parseInt(String.valueOf(orgid)));
            orgEntity2.setname(dept);
            orgEntity2.setparent(Integer.parseInt(String.valueOf(orgid)) - 1);
            orgEntity2.save();
        });
    }

    private void saveDepartmentCsvData(ArrayList filelist) throws Exception {
        orgEntity[] orgEntities;
        for (orgEntity ae : orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class)) {
            this.activeObjects.delete(new RawEntity[]{ae});
            this.activeObjects.flushAll();
        }
        filelist.forEach(item -> {
            String id = (String)((ArrayList)item).get(0);
            String dept = (String)((ArrayList)item).get(1);
            String parent = (String)((ArrayList)item).get(2);
            orgEntity orgEntity2 = (orgEntity)this.activeObjects.create(orgEntity.class, new DBParam[0]);
            orgEntity2.setOrgid(Integer.parseInt(id));
            orgEntity2.setname(dept);
            orgEntity2.setparent(Integer.parseInt(parent));
            orgEntity2.save();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> readCSV() {
        ArrayList<List<String>> csvList = new ArrayList<List<String>>();
        File csv = new File("\uc5ec\uae30\uc5d0 .csv\ud30c\uc77c\uc758 \uc808\ub300\uacbd\ub85c\ub97c \uc785\ub825\ud55c\ub2e4");
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(csv));
            while ((line = br.readLine()) != null) {
                List<Object> aLine = new ArrayList();
                String[] lineArr = line.split(",");
                aLine = Arrays.asList(lineArr);
                csvList.add(aLine);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return csvList;
    }

    public KappResult getLdapContent() throws Exception, KappExceptionHandler {
        KappResult ka = new KappResult();
        HashMap map = new HashMap();
        ArrayList<SettingMng> settingArrList = new ArrayList<SettingMng>();
        int Setting_key = 2;
        try {
            SettingEntity[] settingEntities;
            for (SettingEntity entity : settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_NAME = ? ", new Object[]{"LDAP"}))) {
                SettingMng ldap = new SettingMng();
                ldap.setSettingName(entity.getSettingName());
                ldap.setSettingKey(entity.getSettingKey());
                ldap.setSevername(entity.getSevername());
                ldap.setBasedn(entity.getBasedn());
                ldap.setHostname(entity.getHostname());
                ldap.setDirectoryTy(entity.getDirectoryTy());
                ldap.setObjectAttrLeader(entity.getObjectAttrLeader());
                ldap.setObjectAttrRole(entity.getObjectAttrRole());
                ldap.setUsername(entity.getUsername());
                ldap.setObjectClass(entity.getObjectClass());
                ldap.setObjectFilter(entity.getObjectFilter());
                ldap.setPassword(entity.getPassword());
                ldap.setPort(entity.getPort());
                ldap.setSearchCount(entity.getSearchCount());
                ldap.setSearchTimeout(entity.getSearchTimeout());
                ldap.setSynctime(entity.getSynctime());
                ldap.setUsernameAttr(entity.getUsernameAttr());
                ldap.setSslChecked(entity.getSslChecked());
                ldap.setObjectAttrDivision(entity.getObjectAttrDivision());
                ldap.setObjectGroupClass(entity.getObjectGroupClass());
                ldap.setObjectGroupFilter(entity.getObjectGroupFilter());
                settingArrList.add(ldap);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            log.error("getLdapContent :::::" + e.getMessage());
        }
        ka.setResultData(settingArrList);
        return ka;
    }

    public KappResult LDapSyncSchedulerStart() throws Exception {
        int Setting_key = 2;
        HashMap<String, Object> ldap = null;
        KappResult result = new KappResult();
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{Setting_key}));
        if (settingEntities.length > 0) {
            for (SettingEntity entity : settingEntities) {
                ldap = new HashMap<String, Object>();
                ldap.put("svrName", entity.getSevername());
                ldap.put("directory", entity.getApprovalLineTy());
                ldap.put("hostname", entity.getHostname());
                ldap.put("port", entity.getPort());
                ldap.put("username", entity.getUsername());
                ldap.put("password", entity.getPassword());
                ldap.put("basedn", entity.getBasedn());
                ldap.put("syncTime", entity.getSynctime());
                ldap.put("searchTimeout", entity.getSearchTimeout());
                ldap.put("searchCount", entity.getSearchCount());
                ldap.put("searchObjClass", entity.getObjectClass());
                ldap.put("searchObjectAttrRole", entity.getObjectAttrRole());
                ldap.put("searchObjectAttrLeader", entity.getObjectAttrLeader());
                ldap.put("searchObjectFilter", entity.getObjectFilter());
                ldap.put("usernameAttr", entity.getUsernameAttr());
                ldap.put("sslChecked", entity.getSslChecked());
                ldap.put("searchObjectAttrDivision", entity.getObjectAttrDivision());
                ldap.put("searchObjectFilterGroup", entity.getObjectGroupFilter());
                ldap.put("searchObjectClassGroup", entity.getObjectGroupClass());
            }
            result = this.SEARCH_LDAP(ldap);
        } else {
            result.setResultMsg("empty");
            result.setResultCode(400);
        }
        return result;
    }

    public KappResult getLanguage() throws Exception, KappExceptionHandler {
        KappResult ka = new KappResult();
        HashMap map = new HashMap();
        ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByName(ComponentAccessor.getJiraAuthenticationContext().getUser().getKey());
        Locale locale = this.localeManager.getLocaleFor(appUser);
        String language = locale.getLanguage();
        ka.setResultData(language);
        return ka;
    }

    private KappResult getTeamUsers(String name) throws Exception {
        KappResult ka = new KappResult();
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        orgUserEntity[] orgUserEntities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("ORGNAME = ? ", new Object[]{name}));
        ArrayList<orgUserMng> orgUserMngs = new ArrayList<orgUserMng>();
        for (orgUserEntity entity : orgUserEntities) {
            orgUserMng orgUserMng2 = new orgUserMng();
            orgUserMng2.setUsername(entity.getUsername());
            orgUserMng2.setPosition(entity.getPosition());
            orgUserMng2.setOrgyn(entity.getOrgYn());
            orgUserMng2.setOrgname(entity.getOrgname());
            orgUserMng2.setUserKey(entity.getUserKey());
            orgUserMng2.setAvatarUrl(this.getAvatarUrl(appUser, entity.getUserKey()));
            orgUserMngs.add(orgUserMng2);
        }
        ka.setResultData(orgUserMngs);
        return ka;
    }

    private KappResult removePosition(String id) throws Exception {
        KappResult ka = new KappResult();
        int cnt = this.activeObjects.deleteWithSQL(orgPosiEntity.class, "POSITIONID = ? ", new Object[]{Integer.parseInt(id)});
        ka.setResultData(cnt);
        return ka;
    }

    private KappResult setOrgList(Object obj) throws Exception {
        KappResult ka = new KappResult();
        ArrayList orglist = (ArrayList)((LinkedHashMap)obj).get("orglist");
        orgEntity[] orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class);
        for (orgEntity ae : orgEntities) {
            this.activeObjects.delete(new RawEntity[]{ae});
            this.activeObjects.flushAll();
        }
        for (HashMap objcts : orglist) {
            int id = (Integer)objcts.get("id");
            String name = (String)objcts.get("name");
            int parent = (Integer)objcts.get("parent");
            orgEntity orgEntity2 = (orgEntity)this.activeObjects.create(orgEntity.class, new DBParam[0]);
            orgEntity2.setOrgid(id);
            orgEntity2.setname(name);
            orgEntity2.setparent(parent);
            orgEntity2.save();
        }
        return ka;
    }

    private KappResult ChangeUser(Object obj) throws Exception {
        KappResult ka = new KappResult();
        String usernm = (String)((LinkedHashMap)obj).get("usernm");
        String userkey = (String)((LinkedHashMap)obj).get("userkey");
        String issuekey = (String)((LinkedHashMap)obj).get("issuekey");
        String lineNum = (String)((LinkedHashMap)obj).get("lineNum");
        int selectline = (Integer)((LinkedHashMap)obj).get("selectline");
        String jsmRandomKey = (String)((LinkedHashMap)obj).get("jsmRandomKey");
        String potalId = (String)((LinkedHashMap)obj).get("potalId");
        if (jsmRandomKey == null) {
            signUserMngEntity[] smEntity;
            for (signUserMngEntity sm : smEntity = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND LINE_NUM = ?", new Object[]{issuekey, Integer.parseInt(lineNum)}))) {
                if (selectline != sm.getRowNum()) continue;
                sm.setApprovalUser(usernm);
                sm.setApprvoalUserkey(userkey);
                sm.save();
                break;
            }
        } else {
            LineSeqEntity[] lineSeqEntity;
            for (LineSeqEntity se : lineSeqEntity = (LineSeqEntity[])this.activeObjects.find(LineSeqEntity.class, Query.select().where("USER_KEY != ?", new Object[]{""}))) {
                this.activeObjects.deleteWithSQL(LineSeqEntity.class, "USER_KEY = ? ", new Object[]{se.getUserKey()});
            }
            LineSeqEntity seqEntity = (LineSeqEntity)this.activeObjects.create(LineSeqEntity.class, new DBParam[0]);
            seqEntity.setRandomKey(jsmRandomKey);
            seqEntity.setUserKey(userkey);
            seqEntity.save();
        }
        return ka;
    }

    public String getAvatarUrl(ApplicationUser a1, String userKey) {
        ApplicationUser a2 = ComponentAccessor.getUserManager().getUserByKey(userKey);
        return this.avatarService.getAvatarURL(a1, a2, Avatar.Size.biggerThan((int)100)).toString();
    }

    private KappResult setUserList(Object obj) throws Exception {
        KappResult ka = new KappResult();
        ArrayList lineList = (ArrayList)((LinkedHashMap)obj).get("lineList");
        for (HashMap objcts : lineList) {
            String tblorgPosition = (String)objcts.get("tblorgPosition");
            String tblorgnm = (String)objcts.get("tblorgnm");
            String tblorgyn = (String)objcts.get("tblorgyn");
            String userid = (String)objcts.get("userid");
            orgUserEntity[] oe = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("USERNAME = ? ", new Object[]{userid}));
            ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByName(userid);
            String userKey = appUser.getKey();
            if (oe.length > 0) {
                for (orgUserEntity entity : oe) {
                    entity.setUsername(userid);
                    entity.setPosition(tblorgPosition);
                    entity.setOrgname(tblorgnm);
                    entity.setOrgYn(tblorgyn);
                    entity.setEmail(appUser.getEmailAddress());
                    entity.setUsername(userid);
                    entity.setUserKey(userKey);
                    entity.save();
                }
                continue;
            }
            orgUserEntity orgUserEntity2 = (orgUserEntity)this.activeObjects.create(orgUserEntity.class, new DBParam[0]);
            orgUserEntity2.setPosition(tblorgPosition);
            orgUserEntity2.setOrgname(tblorgnm);
            orgUserEntity2.setOrgYn(tblorgyn);
            orgUserEntity2.setUsername(userid);
            orgUserEntity2.setUserKey(userKey);
            orgUserEntity2.setEmail(appUser.getEmailAddress());
            orgUserEntity2.save();
        }
        return ka;
    }

    private KappResult searchTypelist(String lineNum) throws Exception {
        KappResult ka = new KappResult();
        if (lineNum.equals("") || lineNum == null) {
            lineNum = "";
        }
        HashMap<String, config> map = new HashMap<String, config>();
        configEntity entity = (configEntity)this.activeObjects.get(configEntity.class, (Object)Integer.parseInt(lineNum));
        LineListEntity[] lineListEntity = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(lineNum)}));
        config conf = new config();
        conf.setLineName(entity.getLineName());
        conf.setLineNum(entity.getLineNum());
        conf.setLineDesc(entity.getLineDesc());
        conf.setRegDateTime(entity.getRegDateTime());
        conf.setLineApprovaUser(entity.getLineApprovaUser());
        conf.setDetailCode(entity.getDetailCode());
        map.put("entity", conf);
        LinkedList<Integer> seq = new LinkedList<Integer>();
        ArrayList resSeq = new ArrayList();
        ArrayList approvalLineList = new ArrayList();
        for (LineListEntity p : lineListEntity) {
            seq.add(p.getLineSeq());
        }
        resSeq = (ArrayList)seq.stream().distinct().collect(Collectors.toList());
        for (Integer lineSeq : resSeq) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("seq", lineSeq);
            obj.put("lineList", this.getLineList(lineSeq));
            obj.put("orgList", this.getOrgInfo(lineSeq));
            obj.put("filedsList", this.getFiledsInfo(lineSeq));
            obj.put("detailCode", this.getDetailConde(this.getOrgInfo(lineSeq), this.getFiledsInfo(lineSeq)));
            approvalLineList.add(obj);
        }
        ka.setResultData(approvalLineList);
        return ka;
    }

    public String getDetailConde(ArrayList<ConfigDetail> configDetails, ArrayList<ConfigFileds> configFileds) {
        String code = "";
        code = configDetails.size() > 0 ? (String)configDetails.stream().map(ConfigDetail::getDetailCode).collect(Collectors.toList()).get(0) : (configFileds.size() > 0 ? (String)configFileds.stream().map(ConfigFileds::getDetailCode).collect(Collectors.toList()).get(0) : "0");
        return code;
    }

    public ArrayList<ConfigFileds> getFiledsInfo(int seq) {
        ConfigFiledsEntity[] configFiledsEntities;
        ArrayList<ConfigFileds> filedsArrayList = new ArrayList<ConfigFileds>();
        for (ConfigFiledsEntity configFiledsEntity : configFiledsEntities = (ConfigFiledsEntity[])this.activeObjects.find(ConfigFiledsEntity.class, Query.select().where("LINE_SEQ = ? ", new Object[]{seq}))) {
            ConfigFileds configFileds = new ConfigFileds();
            configFileds.setDetailCode(configFiledsEntity.getDetailCode());
            configFileds.setLineName(configFiledsEntity.getLineName());
            configFileds.setLineNum(configFiledsEntity.getLineNum());
            configFileds.setFiledName(this.getFieldToName(configFiledsEntity.getFiledName()));
            configFileds.setFiledValue(this.getFieldValueToName(configFiledsEntity.getFiledName(), configFiledsEntity.getFiledValue()));
            configFileds.setLineSeq(configFileds.getLineSeq());
            filedsArrayList.add(configFileds);
        }
        return filedsArrayList;
    }

    private String getFieldToName(String filedName) {
        Collection issueConstants = ComponentAccessor.getConstantsManager().getConstantObjects(filedName);
        if (issueConstants != null) {
            for (IssueConstant issueConstant : issueConstants) {
                if (!issueConstant.getName().equals(filedName)) continue;
                return issueConstant.getName();
            }
        } else {
            CustomField cfiled = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(filedName);
            return cfiled.getFieldName();
        }
        return "";
    }

    private String getFieldValueToName(String filed, String value) {
        block3: {
            block2: {
                Collection issueConstants = ComponentAccessor.getConstantsManager().getConstantObjects(filed);
                if (issueConstants == null) break block2;
                for (IssueConstant issueConstant : issueConstants) {
                    if (!issueConstant.getId().equals(value)) continue;
                    return issueConstant.getName();
                }
                break block3;
            }
            CustomField cfiled = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(filed);
            FieldConfig fieldConfig = cfiled.getRelevantConfig((IssueContext)new IssueContextImpl(null, ""));
            Options options = cfiled.getOptions(cfiled.getFieldName(), fieldConfig, null);
            Long filedValue = Long.valueOf(value);
            if (options == null) break block3;
            for (Option op : options) {
                if (!filedValue.equals(op.getOptionId())) continue;
                return op.getValue();
            }
        }
        return "";
    }

    public ArrayList<ConfigDetail> getOrgInfo(int seq) {
        ConfigDetailEntity[] configDetailEntities;
        ArrayList<ConfigDetail> detailArrayList = new ArrayList<ConfigDetail>();
        for (ConfigDetailEntity configDetailEntity : configDetailEntities = (ConfigDetailEntity[])this.activeObjects.find(ConfigDetailEntity.class, Query.select().where("LINE_SEQ = ? ", new Object[]{seq}))) {
            ConfigDetail configDetail = new ConfigDetail();
            configDetail.setDetailCode(configDetailEntity.getDetailCode());
            configDetail.setLineName(configDetailEntity.getLineName());
            configDetail.setLineNum(configDetailEntity.getLineNum());
            configDetail.setOrgId(configDetailEntity.getOrgId());
            configDetail.setOrgName(configDetailEntity.getOrgName());
            configDetail.setLineSeq(configDetail.getLineSeq());
            detailArrayList.add(configDetail);
        }
        return detailArrayList;
    }

    public ArrayList<LineList> getLineList(int seq) {
        LineListEntity[] lineListEntity;
        ArrayList<LineList> arrayLineList = new ArrayList<LineList>();
        for (LineListEntity lines : lineListEntity = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_SEQ = ? ", new Object[]{seq}))) {
            LineList line = new LineList();
            line.setApprovalOrderNm(lines.getApprovalOrderNm());
            line.setApprovalPosition(lines.getApprovalPosition());
            line.setApprovalType(lines.getApprovalType());
            line.setApprovalFix(lines.getApprovalFix());
            line.setLineNum(lines.getLineNum());
            line.setLineSeq(lines.getLineSeq());
            line.setApprvoalUserkey(lines.getApprvoalUserkey());
            arrayLineList.add(line);
        }
        return arrayLineList;
    }

    public KappResult searchJiraFiledValue(String fieldName) throws Exception {
        Collection issueConstants;
        KappResult ka = new KappResult();
        ArrayList arryFiledValues = new ArrayList();
        ArrayList arrIssueContants = new ArrayList();
        if (fieldName.equals("") || fieldName == null) {
            fieldName = "";
        }
        if ((issueConstants = ComponentAccessor.getConstantsManager().getConstantObjects(fieldName)) != null) {
            for (IssueConstant issueConstant : issueConstants) {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("id", issueConstant.getId());
                hm.put("name", issueConstant.getName());
                arrIssueContants.add(hm);
            }
        } else {
            CustomField cfiled = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(fieldName);
            FieldConfig fieldConfig = cfiled.getRelevantConfig((IssueContext)new IssueContextImpl(null, ""));
            Options options = cfiled.getOptions(cfiled.getFieldName(), fieldConfig, null);
            if (options != null) {
                for (Option op : options) {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    hm.put("id", op.getOptionId());
                    hm.put("name", op.getValue());
                    arrIssueContants.add(hm);
                }
            }
        }
        ka.setResultData(arrIssueContants);
        return ka;
    }

    public KappResult searchJiraFileList() throws Exception {
        KappResult ka = new KappResult();
        Set fields = this.fieldManager.getAllSearchableFields();
        ArrayList arrFiles = new ArrayList();
        for (SearchableField searchableField : fields) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("id", searchableField.getId());
            hm.put("name", searchableField.getName());
            arrFiles.add(hm);
        }
        ka.setResultData(arrFiles);
        return ka;
    }

    private KappResult searchOrgList() throws Exception {
        KappResult ka = new KappResult();
        orgEntity[] orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class);
        ArrayList<orgMng> orgMngArrayList = new ArrayList<orgMng>();
        for (orgEntity entity : orgEntities) {
            orgMng om = new orgMng();
            om.setid(entity.getOrgid());
            om.setOrgid(entity.getOrgid());
            om.setname(entity.getname());
            om.setparent(entity.getparent());
            orgMngArrayList.add(om);
        }
        ka.setResultData(orgMngArrayList);
        return ka;
    }

    private KappResult searchAlluser(int page) throws Exception {
        KappResult ka = new KappResult();
        ArrayList userArryList = new ArrayList();
        List appUser = new ArrayList();
        List appUserPageer = new ArrayList();
        UserSearchParams userSearchParams = UserSearchParams.builder().includeActive(true).includeInactive(true).allowEmptyQuery(true).build();
        appUser = this.userSearchService.findUsers("", userSearchParams);
        PageRequest pageRequest = PageRequests.request((Long)Long.valueOf(page), (Integer)50);
        Page appUserPage = Pages.toPage(appUser, (PageRequest)pageRequest);
        appUserPageer = appUserPage.getValues();
        for (ApplicationUser user : appUserPageer) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Collection groups = this.groupManager.getGroupNamesForUser(user.getUsername());
            orgUserEntity[] userEntities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("USERNAME = ? ", new Object[]{user.getUsername()}));
            if (userEntities.length > 0) {
                for (orgUserEntity oe : userEntities) {
                    map.put("orgname", oe.getOrgname());
                    map.put("orgPosition", oe.getPosition());
                    map.put("orgYn", oe.getOrgYn());
                }
            } else {
                map.put("orgname", "");
                map.put("orgPosition", "");
                map.put("orgYn", "");
            }
            map.put("displayname", user.getDisplayName());
            map.put("username", user.getUsername());
            map.put("userkey", user.getKey());
            map.put("address", user.getEmailAddress());
            map.put("groups", groups);
            userArryList.add(map);
        }
        LinkedHashMap<String, Serializable> hm = new LinkedHashMap<String, Serializable>();
        hm.put("TOTAL_COUNT", appUserPage.getTotal());
        hm.put("TOTAL_PAGE", Integer.valueOf((int)Math.ceil((double)appUserPage.getTotal().longValue() * 1.0 / (double)appUserPage.getSize())));
        hm.put("PAGE_SIZE", Integer.valueOf(appUserPage.getSize()));
        hm.put("PAGE_START", Long.valueOf(appUserPage.getStart()));
        hm.put("NEXT", Boolean.valueOf(appUserPage.isLast()));
        hm.put("userArryList", userArryList);
        ka.setResultData(hm);
        return ka;
    }

    @Override
    public KappResult getMemberInfoModify(String username) throws KappExceptionHandler, Exception {
        return this.searchUserInfoModify(username);
    }

    private KappResult selectAllCustomUserPickerFields() throws KappExceptionHandler, Exception {
        KappResult ka = new KappResult();
        ArrayList arrayList = new ArrayList();
        try {
            List filds = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects();
            for (CustomField field : filds) {
                String filedTykey = (String)field.getGenericValue().get("customfieldtypekey");
                if (!CUSTOM_USERPICKER_KEY.equals(filedTykey)) continue;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("fieldName", field.getFieldName());
                map.put("fieldId", field.getId());
                arrayList.add(map);
            }
        }
        catch (Exception e) {
            log.error("filds exception  {}", (Object)e.getMessage());
        }
        ka.setResultData(arrayList);
        return ka;
    }

    private KappResult selectAllPosition() {
        KappResult ka = new KappResult();
        orgPosiEntity[] entity = (orgPosiEntity[])this.activeObjects.find(orgPosiEntity.class);
        ArrayList arrayList = new ArrayList();
        for (orgPosiEntity ae : entity) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("position", ae.getPosition());
            map.put("positionid", ae.getPositionid());
            arrayList.add(map);
        }
        ka.setResultData(arrayList);
        return ka;
    }

    private KappResult setPosition(Object obj) {
        KappResult ka = new KappResult();
        ArrayList lineList = (ArrayList)((LinkedHashMap)obj).get("lineList");
        orgPosiEntity[] entity = (orgPosiEntity[])this.activeObjects.find(orgPosiEntity.class);
        for (orgPosiEntity ae : entity) {
            this.activeObjects.delete(new RawEntity[]{ae});
            this.activeObjects.flushAll();
        }
        for (HashMap objcts : lineList) {
            String tblorgnm = (String)objcts.get("tblorgnm");
            orgPosiEntity posiEntity = (orgPosiEntity)this.activeObjects.create(orgPosiEntity.class, new DBParam[0]);
            posiEntity.setPositionid(posiEntity.getID());
            posiEntity.setPosition(tblorgnm);
            posiEntity.save();
        }
        ka.setResultData("SUCESS");
        return ka;
    }

    private KappResult searchUserInfoModify(String username) {
        LinkedHashMap<String, String> hm;
        KappResult ka = new KappResult();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByName(username);
        if (appUser == null) {
            throw new IllegalArgumentException("notExist");
        }
        Collection groups = this.groupManager.getGroupNamesForUser(appUser.getUsername());
        orgPosiEntity[] op = (orgPosiEntity[])this.activeObjects.find(orgPosiEntity.class);
        orgEntity[] orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayListOrg = new ArrayList();
        for (orgPosiEntity entity : op) {
            hm = new LinkedHashMap<String, String>();
            hm.put("position", entity.getPosition());
            arrayList.add(hm);
        }
        for (orgEntity orgEntity2 : orgEntities) {
            hm = new LinkedHashMap();
            hm.put("orgNm", orgEntity2.getname());
            arrayListOrg.add(hm);
        }
        map.put("displayname", appUser.getDisplayName());
        map.put("username", appUser.getUsername());
        map.put("address", appUser.getEmailAddress());
        map.put("groups", groups);
        map.put("positionList", arrayList);
        map.put("orgList", arrayListOrg);
        ka.setResultData(map);
        return ka;
    }

    private KappResult searchUserInfo(String option, String value) {
        KappResult ka = new KappResult();
        ArrayList arrayMap = new ArrayList();
        Collection appUsers = new ArrayList();
        Integer MAX_RESULTS = 50;
        boolean startAt = false;
        PageRequest pageRequest = PageRequests.request((Long)0L, (Integer)10);
        if (option.equals("username") || option.equals("displayname")) {
            UserSearchParams userSearchParams = UserSearchParams.builder().includeActive(true).includeInactive(true).allowEmptyQuery(true).maxResults(Integer.valueOf(50)).build();
            appUsers = this.userSearchService.findUsers(value, userSearchParams);
            if (appUsers.size() == 0) {
                throw new IllegalArgumentException("notExist");
            }
        } else if (option.equals("email")) {
            appUsers = (Collection)ComponentAccessor.getUserSearchService().findUsersByEmail(value);
            if (appUsers.size() == 0) {
                throw new IllegalArgumentException("notExist");
            }
        } else {
            orgUserEntity[] entities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("ORGNAME = ? ", new Object[]{value}));
            if (entities.length == 0) {
                throw new IllegalArgumentException("notExist");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (orgUserEntity oe : entities) {
                ApplicationUser ap = ComponentAccessor.getUserUtil().getUserByName(oe.getUsername());
                Collection groups = this.groupManager.getGroupNamesForUser(ap.getUsername());
                map.put("orgname", oe.getOrgname());
                map.put("orgPosition", oe.getPosition());
                map.put("orgYn", oe.getOrgYn());
                map.put("displayname", ap.getDisplayName());
                map.put("username", ap.getUsername());
                map.put("userkey", ap.getKey());
                map.put("address", ap.getEmailAddress());
                map.put("groups", groups);
                arrayMap.add(map);
            }
            ka.setResultData(arrayMap);
            return ka;
        }
        for (ApplicationUser ap : appUsers) {
            Collection groups = this.groupManager.getGroupNamesForUser(ap.getUsername());
            orgUserEntity[] userEntities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("USERNAME = ? ", new Object[]{ap.getUsername()}));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (userEntities.length > 0) {
                for (orgUserEntity oe : userEntities) {
                    map.put("orgname", oe.getOrgname());
                    map.put("orgPosition", oe.getPosition());
                    map.put("orgYn", oe.getOrgYn());
                }
            } else {
                map.put("orgname", "");
                map.put("orgPosition", "");
                map.put("orgYn", "");
            }
            map.put("displayname", ap.getDisplayName());
            map.put("username", ap.getUsername());
            map.put("userkey", ap.getKey());
            map.put("address", ap.getEmailAddress());
            map.put("groups", groups);
            arrayMap.add(map);
        }
        ka.setResultData(arrayMap);
        return ka;
    }

    private KappResult setLdapBaseData(Object data) throws Exception, KappExceptionHandler {
        KappResult result = new KappResult();
        HashMap ldap = (HashMap)((LinkedHashMap)data).get("data");
        result = this.SEARCH_LDAP(ldap);
        this.saveLdapInfo(ldap);
        return result;
    }

    private void saveLdapInfo(HashMap ldap) throws Exception {
        int Setting_key = 2;
        try {
            SettingEntity[] entities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{Setting_key}));
            if (entities.length > 0) {
                List ldapID = Arrays.stream(entities).map(Entity::getID).collect(Collectors.toList());
                int ldID = (Integer)ldapID.get(0);
                SettingEntity update = (SettingEntity)this.activeObjects.get(SettingEntity.class, (Object)ldID);
                update.setBasedn((String)ldap.get("basedn"));
                update.setSettingName("LDAP");
                update.setSettingKey(Setting_key);
                update.setSevername((String)ldap.get("svrName"));
                update.setHostname((String)ldap.get("hostname"));
                update.setUsername((String)ldap.get("username"));
                update.setPassword((String)ldap.get("password"));
                update.setPort((String)ldap.get("port"));
                update.setSynctime((String)ldap.get("syncTime"));
                update.setSearchCount((String)ldap.get("searchCount"));
                update.setSearchTimeout((String)ldap.get("searchTimeout"));
                update.setObjectFilter((String)ldap.get("searchObjectFilter"));
                update.setObjectClass((String)ldap.get("searchObjClass"));
                update.setUsernameAttr((String)ldap.get("usernameAttr"));
                update.setDirectoryTy((String)ldap.get("directory"));
                update.setObjectAttrRole((String)ldap.get("searchObjectAttrRole"));
                update.setObjectAttrLeader((String)ldap.get("searchObjectAttrLeader"));
                update.setObjectAttrDivision((String)ldap.get("searchObjectAttrDivision"));
                update.setObjectGroupClass((String)ldap.get("searchObjectClassGroup"));
                update.setObjectGroupFilter((String)ldap.get("searchObjectFilterGroup"));
                update.setSslChecked((Boolean)ldap.get("sslChecked"));
                update.setRegLineDate(new Date(System.currentTimeMillis()));
                update.save();
            } else {
                SettingEntity settingEntity = (SettingEntity)this.activeObjects.create(SettingEntity.class, new DBParam[0]);
                settingEntity.setSettingName("LDAP");
                settingEntity.setSettingKey(Setting_key);
                settingEntity.setBasedn((String)ldap.get("basedn"));
                settingEntity.setSevername((String)ldap.get("svrName"));
                settingEntity.setHostname((String)ldap.get("hostname"));
                settingEntity.setUsername((String)ldap.get("username"));
                settingEntity.setPassword((String)ldap.get("password"));
                settingEntity.setPort((String)ldap.get("port"));
                settingEntity.setDirectoryTy((String)ldap.get("directory"));
                settingEntity.setSynctime((String)ldap.get("syncTime"));
                settingEntity.setSearchCount((String)ldap.get("searchCount"));
                settingEntity.setSearchTimeout((String)ldap.get("searchTimeout"));
                settingEntity.setObjectFilter((String)ldap.get("searchObjectFilter"));
                settingEntity.setObjectClass((String)ldap.get("searchObjClass"));
                settingEntity.setUsernameAttr((String)ldap.get("usernameAttr"));
                settingEntity.setObjectAttrRole((String)ldap.get("searchObjectAttrRole"));
                settingEntity.setObjectAttrLeader((String)ldap.get("searchObjectAttrLeader"));
                settingEntity.setObjectAttrDivision((String)ldap.get("searchObjectAttrDivision"));
                settingEntity.setObjectGroupClass((String)ldap.get("searchObjectClassGroup"));
                settingEntity.setObjectGroupFilter((String)ldap.get("searchObjectFilterGroup"));
                settingEntity.setSslChecked((Boolean)ldap.get("sslChecked"));
                settingEntity.setRegLineDate(new Date(System.currentTimeMillis()));
                settingEntity.save();
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            log.error(e.getMessage());
        }
        this.saveLdapJob((String)ldap.get("syncTime"));
    }

    private void saveLdapJob(String synctime) throws SchedulerServiceException {
        String jobTime = "0 0 hour 1/day * ? *";
        jobTime = jobTime.replace("hour", String.valueOf(synctime));
        jobTime = jobTime.replace("day", String.valueOf("1"));
        if (this.ldapSyncSchedulerJob == null) {
            this.ldapSyncSchedulerJob = (LdapSyncScheduler)this.context.getBean(LdapSyncScheduler.class);
        }
        this.schedulerService.unscheduleJob(JobId.of((String)LdapSyncScheduler.class.getName()));
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)LdapSyncScheduler.class.getName()));
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)LdapSyncScheduler.class.getName()), (JobRunner)this.ldapSyncSchedulerJob);
        log.warn("ldapSyncSchedulerJob JOB Config " + jobTime);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)LdapSyncScheduler.class.getName())).withSchedule(Schedule.forCronExpression((String)jobTime)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        this.schedulerService.scheduleJob(JobId.of((String)LdapSyncScheduler.class.getName()), jobConfig);
    }

    private KappResult SEARCH_LDAP(HashMap ldap) throws Exception {
        KappResult res = new KappResult();
        String ServerName = (String)ldap.get("svrName");
        String directoryNm = (String)ldap.get("directory");
        String hostname = (String)ldap.get("hostname");
        String port = (String)ldap.get("port");
        String username = (String)ldap.get("username");
        String password = (String)ldap.get("password");
        String basedn = (String)ldap.get("basedn");
        String syncTime = (String)ldap.get("syncTime");
        String searchTimeout = (String)ldap.get("searchTimeout");
        String searchCount = (String)ldap.get("searchCount");
        String searchObjectAttrRole = (String)ldap.get("searchObjectAttrRole");
        String searchObjectAttrLeader = (String)ldap.get("searchObjectAttrLeader");
        String searchObjectFilter = (String)ldap.get("searchObjectFilter");
        String searchObjectAttrDivision = (String)ldap.get("searchObjectAttrDivision");
        String searchObjectFilterGroup = (String)ldap.get("searchObjectFilterGroup");
        String searchObjectClassGroup = (String)ldap.get("searchObjectClassGroup");
        String usernameAttr = (String)ldap.get("usernameAttr");
        Boolean sslChecked = (Boolean)ldap.get("sslChecked");
        String KeyStorePAsswd = (String)ldap.get("KeyStorePAsswd");
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (sslChecked.booleanValue()) {
                String keystorePath = System.getProperty("java.home") + "/lib/security/jssecacerts";
                System.setProperty("javax.net.ssl.keystore", keystorePath);
                System.setProperty("javax.net.ssl.keyStorePassword", KeyStorePAsswd);
                env.put("java.naming.provider.url", "ldaps://" + hostname + ":" + port);
                env.put("java.naming.security.protocol", "ssl");
            }
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + hostname + ":" + port);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", username);
            env.put("java.naming.security.credentials", password);
            InitialDirContext ctx = new InitialDirContext(env);
            ctx = new InitialLdapContext(env, null);
            orgMng mng = new orgMng();
            ArrayList<orgMng> groupList = new ArrayList<orgMng>();
            String[] attrsGroup = new String[]{searchObjectAttrDivision, "gidNumber"};
            SearchControls controlsGroup = new SearchControls();
            controlsGroup.setSearchScope(2);
            controlsGroup.setReturningAttributes(attrsGroup);
            controlsGroup.setCountLimit(1000L);
            NamingEnumeration<SearchResult> results = ctx.search(basedn, searchObjectFilterGroup, controlsGroup);
            int idx = 1;
            while (results.hasMore()) {
                mng = new orgMng();
                SearchResult entry = results.next();
                Attributes attrs = entry.getAttributes();
                Attribute groupName = attrs.get(searchObjectAttrDivision);
                Attribute gidNumber = attrs.get("gidNumber");
                mng.setid(Integer.parseInt(String.valueOf(gidNumber.get())));
                mng.setname((String)groupName.get());
                ++idx;
                groupList.add(mng);
            }
            this.saveDepartmentLDapData(groupList);
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<HashMap> items = new ArrayList<HashMap>();
            String[] attrIDs = new String[]{searchObjectAttrRole, searchObjectAttrLeader, searchObjectAttrDivision};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            ctls.setCountLimit(Long.parseLong(searchCount));
            ctls.setTimeLimit(Integer.parseInt(searchTimeout));
            UserSearchParams userSearchParams = UserSearchParams.builder().includeActive(true).includeInactive(true).allowEmptyQuery(true).build();
            List appUsers = this.userSearchService.findUsers("", userSearchParams);
            for (ApplicationUser user : appUsers) {
                String filter = "(" + usernameAttr + "=" + user.getUsername() + ")";
                try {
                    NamingEnumeration<SearchResult> e = ctx.search(basedn, filter, ctls);
                    while (e.hasMore()) {
                        SearchResult entry = e.next();
                        Attributes attrs = entry.getAttributes();
                        Attribute role = attrs.get(searchObjectAttrRole);
                        Attribute leader = attrs.get(searchObjectAttrLeader);
                        Attribute division = attrs.get(searchObjectAttrDivision);
                        map.put("role", role == null ? "" : (String)role.get());
                        map.put("leader", leader == null ? "" : (String)leader.get());
                        map.put("username", user.getUsername());
                        map.put("division", division == null ? "" : (String)division.get());
                        map.put("userkey", user.getKey());
                        items.add(map);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            if (items.size() > 0) {
                this.UserInfoOrgMapper(items);
            }
            res.setResultMsg("SUCESS");
        }
        catch (AuthenticationException e) {
            String msg = e.getMessage();
            if (msg.indexOf("data 525") > 0) {
                res.setResultMsg("\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c.");
                res.setResultCode(500);
                log.warn("\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c.");
                return res;
            }
            if (msg.indexOf("data 773") > 0) {
                log.warn("\uc0ac\uc6a9\uc790\ub294 \uc554\ud638\ub97c \uc7ac\uc124\uc815\ud574\uc57c\ud569\ub2c8\ub2e4.");
                res.setResultMsg("\uc0ac\uc6a9\uc790\ub294 \uc554\ud638\ub97c \uc7ac\uc124\uc815\ud574\uc57c\ud569\ub2c8\ub2e4.");
                res.setResultCode(500);
                return res;
            }
            if (msg.indexOf("data 52e") > 0) {
                log.warn("ID\uc640 \ube44\ubc00\ubc88\ud638\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\ud655\uc778 \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
                res.setResultMsg("ID\uc640 \ube44\ubc00\ubc88\ud638\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\ud655\uc778 \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
                res.setResultCode(500);
                return res;
            }
            if (msg.indexOf("data 533") > 0) {
                log.warn("\uc785\ub825\ud55c ID\ub294 \ube44\ud65c\uc131\ud654 \uc0c1\ud0dc \uc785\ub2c8\ub2e4.");
                res.setResultMsg("\uc785\ub825\ud55c ID\ub294 \ube44\ud65c\uc131\ud654 \uc0c1\ud0dc \uc785\ub2c8\ub2e4.");
                res.setResultCode(500);
                return res;
            }
            if (msg.indexOf("data 532") > 0) {
                log.warn("\uc554\ud638\uac00 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                res.setResultMsg("\uc554\ud638\uac00 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                res.setResultCode(500);
                return res;
            }
            if (msg.indexOf("data 701") > 0) {
                log.warn("Directory \uacc4\uc815\uc774 \ub9cc\ub8cc\ub428");
                res.setResultMsg("\uacc4\uc815\uc774 \ub9cc\ub8cc\ub428.");
                res.setResultCode(500);
                return res;
            }
            res.setResultMsg(msg);
            res.setResultCode(500);
            return res;
        }
        catch (Exception ex) {
            log.warn("Directory Connection: FAILED");
            log.error("Directory Connection: FAILED" + ex.getMessage());
            ex.getStackTrace();
            res.setResultMsg("Directory Connection: FAILED");
            res.setResultCode(500);
            return res;
        }
        return res;
    }

    private void UserInfoOrgMapper(ArrayList<HashMap> items) throws Exception {
        items.stream().forEach(item -> {
            orgPosiEntity[] entity;
            String role = (String)item.get("role");
            String leaderYn = (String)item.get("leader");
            String username = (String)item.get("username");
            String division = (String)item.get("division");
            String userkey = (String)item.get("userkey");
            orgUserEntity[] oe = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("USERNAME = ? ", new Object[]{username}));
            if (oe.length > 0) {
                for (orgUserEntity orgUserEntity2 : oe) {
                    orgUserEntity2.setUsername(username);
                    orgUserEntity2.setPosition(role);
                    orgUserEntity2.setOrgname(division);
                    orgUserEntity2.setOrgYn(leaderYn);
                    orgUserEntity2.setUserKey(userkey);
                    orgUserEntity2.save();
                }
            } else {
                orgUserEntity orgUserEntity3 = (orgUserEntity)this.activeObjects.create(orgUserEntity.class, new DBParam[0]);
                orgUserEntity3.setPosition(role);
                orgUserEntity3.setOrgname(division);
                orgUserEntity3.setOrgYn(leaderYn);
                orgUserEntity3.setUsername(username);
                orgUserEntity3.setUserKey(userkey);
                orgUserEntity3.save();
            }
            for (orgPosiEntity ae : entity = (orgPosiEntity[])this.activeObjects.find(orgPosiEntity.class)) {
                this.activeObjects.delete(new RawEntity[]{ae});
                this.activeObjects.flushAll();
            }
            orgPosiEntity posiEntity = (orgPosiEntity)this.activeObjects.create(orgPosiEntity.class, new DBParam[0]);
            posiEntity.setPositionid(posiEntity.getID());
            posiEntity.setPosition(role);
            posiEntity.save();
        });
    }
}

