/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.TransitionOptions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.LineListEntity;
import kr.osci.apps.kapproval.entity.LineSeqEntity;
import kr.osci.apps.kapproval.entity.SettingEntity;
import kr.osci.apps.kapproval.entity.applyListEntity;
import kr.osci.apps.kapproval.entity.configEntity;
import kr.osci.apps.kapproval.entity.issueMngEntity;
import kr.osci.apps.kapproval.entity.issuehisEntity;
import kr.osci.apps.kapproval.entity.orgUserEntity;
import kr.osci.apps.kapproval.entity.replaceUserEntity;
import kr.osci.apps.kapproval.entity.signUserMng;
import kr.osci.apps.kapproval.entity.signUserMngEntity;
import kr.osci.apps.kapproval.entity.workFlowStEntity;
import kr.osci.apps.kapproval.service.issueRegService;
import kr.osci.apps.kapproval.utills.emailUtil;
import net.java.ao.DBParam;
import net.java.ao.Preload;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Named
@Preload
public class issueRegServiceImpl
implements issueRegService {
    private static final Logger log = LoggerFactory.getLogger(issueRegServiceImpl.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final LoginService loginInfo;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final UserSearchService userSearchService;
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final ProjectManager projectManager;
    @ComponentImport
    private final WorkflowSchemeManager workflowSchemeManager;

    @Inject
    public issueRegServiceImpl(ActiveObjects activeObjects, LoginService loginInfo, IssueManager issueManager, UserSearchService userSearchService, LocaleManager localeManager, ProjectManager projectManager, WorkflowSchemeManager workflowSchemeManager) {
        this.activeObjects = activeObjects;
        this.loginInfo = loginInfo;
        this.issueManager = issueManager;
        this.userSearchService = userSearchService;
        this.localeManager = localeManager;
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    @Override
    public KappResult saveIssueApprvoal(Issue issue, String linenm) throws KappExceptionHandler, Exception {
        return this.regIssueApproval(issue, linenm);
    }

    @Override
    public KappResult saveSignInfo(Object obj) throws KappExceptionHandler, Exception {
        return this.signApprovalProcess(obj);
    }

    /*
     * WARNING - void declaration
     */
    public KappResult signApprovalProcess(Object obj) {
        KappResult ka = new KappResult();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        emailUtil mail = new emailUtil();
        try {
            signUserMngEntity[] smg;
            signUserMngEntity[] signUserMngEntity2;
            ArrayList<signUserMng> arraySignList = new ArrayList<signUserMng>();
            String dcrmk = (String)((LinkedHashMap)obj).get("dcrmk");
            String pw = (String)((LinkedHashMap)obj).get("pw");
            String lineName = (String)((LinkedHashMap)obj).get("lineName");
            String lineNum = (String)((LinkedHashMap)obj).get("lineNum");
            String procType = (String)((LinkedHashMap)obj).get("procType");
            String prjid = (String)((LinkedHashMap)obj).get("prjid");
            String issueid = (String)((LinkedHashMap)obj).get("issueid");
            String issueTynm = (String)((LinkedHashMap)obj).get("issueTynm");
            String approvalUser = (String)((LinkedHashMap)obj).get("approvalUser");
            String apprvoalUserkey = (String)((LinkedHashMap)obj).get("apprvoalUserkey");
            String replaceUser = (String)((LinkedHashMap)obj).get("replaceUser");
            String replaceUserKey = (String)((LinkedHashMap)obj).get("replaceUserKey");
            String approvalType = (String)((LinkedHashMap)obj).get("approvalType");
            String approvalOrderNm = (String)((LinkedHashMap)obj).get("approvalOrderNm");
            String superuser = (String)((LinkedHashMap)obj).get("superuser") == null ? "" : (String)((LinkedHashMap)obj).get("superuser");
            String superuserkey = (String)((LinkedHashMap)obj).get("superuserkey") == null ? "" : (String)((LinkedHashMap)obj).get("superuserkey");
            String issueKey = (String)((LinkedHashMap)obj).get("issueKey");
            String approvalPath = (String)((LinkedHashMap)obj).get("approvalPath") == null ? "system" : (String)((LinkedHashMap)obj).get("approvalPath");
            String userkey = (String)((LinkedHashMap)obj).get("userkey") == null ? "" : (String)((LinkedHashMap)obj).get("userkey");
            String portalYn = "N";
            String portalId = "";
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
            if (appUser == null) {
                appUser = ComponentAccessor.getUserManager().getUserByKey(userkey);
            }
            String loginUserkey = appUser.getKey();
            int settingKey = 2;
            SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{settingKey}));
            String ynPasswd = "";
            if (settingEntities.length > 0) {
                List passwordUse = Arrays.stream(settingEntities).map(SettingEntity::getApprovalLineTy).collect(Collectors.toList());
                ynPasswd = (String)passwordUse.get(0);
            }
            LoginResult loginResult = null;
            if (!ynPasswd.equals("N") && approvalPath.equals("system")) {
                try {
                    loginResult = this.loginInfo.authenticate(appUser, pw);
                }
                catch (Exception e) {
                    log.warn("loginInfo.authenticate password fail" + e.getMessage());
                }
                if (!loginResult.getReason().toString().equals("OK")) {
                    throw new IllegalArgumentException("passwordFail");
                }
            }
            Locale locale = this.localeManager.getLocaleFor(appUser);
            String language = locale.getLanguage();
            for (signUserMngEntity si : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND APPRVOAL_USERKEY = ? AND LINE_NUM = ?  ", new Object[]{issueKey, apprvoalUserkey, Integer.parseInt(lineNum)}))) {
                if (si.getPrjType() != null) {
                    portalYn = si.getPrjType().equals("jira") ? "N" : "Y";
                    String string = portalId = si.getPortalId() != null ? si.getPortalId() : "";
                }
                if (!si.getApprvoalUserkey().equals(apprvoalUserkey) || si.getApprovalType().equals("\ucc38\uc870")) continue;
                si.setApprovalType(approvalType);
                if (!superuserkey.equals("") && !superuserkey.equals(apprvoalUserkey)) {
                    si.setApprovalUser(this.getApprvoalUserDisplayName(apprvoalUserkey) + " / (\ub300) " + this.getApprvoalUserDisplayName(superuserkey));
                    si.setApprvoalUserkey(apprvoalUserkey);
                    si.setSuperuserkey(superuserkey);
                    si.setSuperuser(superuser);
                    si.setLastApprovalUser(loginUserkey.equals(replaceUserKey) ? appUser.getDisplayName() : this.getApprvoalUserDisplayName(apprvoalUserkey) + " / (\ub300) " + this.getApprvoalUserDisplayName(superuserkey));
                } else {
                    si.setApprovalUser(this.getApprvoalUserDisplayName(apprvoalUserkey));
                    si.setApprvoalUserkey(apprvoalUserkey);
                    si.setLastApprovalUser(loginUserkey.equals(replaceUserKey) ? appUser.getDisplayName() : this.getApprvoalUserDisplayName(apprvoalUserkey));
                }
                si.setReplaceUserKey(loginUserkey.equals(replaceUserKey) ? appUser.getKey() : "");
                si.setReplaceUser(loginUserkey.equals(replaceUserKey) ? appUser.getDisplayName() : "");
                si.setYnReplaceApprvoal(loginUserkey.equals(replaceUserKey) ? "Y" : "N");
                si.setDatatime(new Date(System.currentTimeMillis()));
                si.setYnCompleted("Y");
                si.setDcRmk(dcrmk);
                si.setApprovalTime(format.format(new Date(System.currentTimeMillis())));
                si.setIssueid(Integer.parseInt(issueid));
                si.setLineNum(Integer.parseInt(lineNum));
                si.setButtonStatus("N");
                si.setPrjid(prjid);
                si.setStatus(procType);
                si.setIssueKey(issueKey);
                si.save();
                map.put("regDateTime", format.format(si.getDatatime()));
                map.put("dcRmk", si.getDcRmk());
            }
            for (signUserMngEntity signUserMngEntity3 : smg = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND LINE_NUM = ? ", new Object[]{issueKey, Integer.parseInt(lineNum)}))) {
                signUserMng sm = new signUserMng();
                sm.setPkid(signUserMngEntity3.getID());
                sm.setApprovalType(signUserMngEntity3.getApprovalType());
                sm.setApprovalUser(signUserMngEntity3.getApprovalUser());
                sm.setApprovalOrderNm(signUserMngEntity3.getApprovalOrderNm());
                sm.setApprvoalUserkey(signUserMngEntity3.getApprvoalUserkey());
                sm.setDatatime(signUserMngEntity3.getDatatime());
                sm.setDcRmk(signUserMngEntity3.getDcRmk());
                sm.setStatus(signUserMngEntity3.getStatus());
                sm.setIssueid(signUserMngEntity3.getIssueid());
                sm.setIssueKey(signUserMngEntity3.getIssueKey());
                sm.setLineNum(signUserMngEntity3.getLineNum());
                sm.setPrjid(signUserMngEntity3.getPrjid());
                sm.setApprovalTime(signUserMngEntity3.getApprovalTime() == null ? "" : signUserMngEntity3.getApprovalTime());
                sm.setButtonStatus(signUserMngEntity3.getButtonStatus());
                arraySignList.add(sm);
            }
            Collections.sort(arraySignList, new Comparator<signUserMng>(){

                @Override
                public int compare(signUserMng b1, signUserMng b2) {
                    return b1.getPkid() - b2.getPkid();
                }
            });
            int statusSize = 0;
            int signUserMngEntitySize = smg.length;
            int referSize = 0;
            for (signUserMngEntity en : smg) {
                if (!en.getApprovalType().equals("\ucc38\uc870") && !en.getApprovalType().equals("Reference")) continue;
                ++referSize;
            }
            signUserMngEntitySize -= referSize;
            for (signUserMngEntity sme : smg) {
                if (!sme.getStatus().equals("Y") || sme.getApprovalType().equals("\ucc38\uc870") && sme.getApprovalType().equals("Reference")) continue;
                ++statusSize;
            }
            boolean bl = false;
            MutableIssue issue = this.issueManager.getIssueObject(issueKey);
            IssueType it = issue.getIssueType();
            WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
            JiraWorkflow workflow = workflowManager.getWorkflow((Issue)issue);
            List actionDescriptor = workflow.getLinkedStep(issue.getStatus()).getActions();
            issueMngEntity[] issueMngEntities = (issueMngEntity[])this.activeObjects.find(issueMngEntity.class, Query.select().where("ISSUE_KEY = ?", new Object[]{issueKey}));
            applyListEntity[] applyListEntities = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ? AND WORK_FLOW_STATUS = ?", new Object[]{issue.getProjectObject().getName(), it.getName(), workflow.getName(), issue.getStatus().getNameTranslation()}));
            String completeName = new String();
            String rejectName = new String();
            String writer = new String();
            LocalDateTime createDate = issue.getCreated().toLocalDateTime();
            String key = issue.getKey();
            String status = issue.getStatus().getName();
            String prj = issue.getProjectObject().getName();
            String summary = issue.getSummary().toString();
            String issueKeyUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl") + "/browse/" + issueKey;
            for (applyListEntity applyListEntity2 : applyListEntities) {
                completeName = applyListEntity2.getConvertApproval();
                rejectName = applyListEntity2.getReturnApproval();
            }
            if (statusSize == signUserMngEntitySize) {
                void var61_90;
                int n;
                for (ActionDescriptor action : actionDescriptor) {
                    if (!action.getName().equals(completeName)) continue;
                    n = action.getId();
                }
                for (signUserMngEntity signUserMngEntity4 : smg) {
                    if (!signUserMngEntity4.getApprvoalUserkey().equals(apprvoalUserkey)) continue;
                    signUserMngEntity4.setApprovalPath(approvalPath);
                    signUserMngEntity4.setButtonStatus("N");
                    signUserMngEntity4.save();
                }
                Object[] signCompleted = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? ", new Object[]{issueKey}));
                boolean ynComplted = true;
                for (Object signs : signCompleted) {
                    if (signs.getStatus().equals("Y")) continue;
                    ynComplted = false;
                    break;
                }
                if (ynComplted) {
                    for (issueMngEntity entity : issueMngEntities) {
                        writer = entity.getUserkey();
                        entity.setInProgressState("Y");
                        entity.setLineNum(Integer.parseInt(lineNum));
                        entity.save();
                    }
                }
                this.issueTransition((Issue)issue, n, Integer.parseInt(lineNum));
                map.put("approvalCompleted", "Y");
                String statCode = "3";
                String string = "";
                if (!superuser.equals("")) {
                    String string2 = this.getApprvoalUserDisplayName(apprvoalUserkey) + " /(\ub300) " + superuser;
                } else if (loginUserkey.equals(replaceUserKey)) {
                    String string3 = this.getApprvoalUserDisplayName(apprvoalUserkey) + " /(\ub300) " + this.getApprvoalUserDisplayName(replaceUserKey);
                } else {
                    String string4 = this.getApprvoalUserDisplayName(apprvoalUserkey);
                }
                this.regIssueHistory(statCode, (String)var61_90, issue.getKey());
                String html = mail.getEmailTemp(language, prj, issueKeyUrl, summary, createDate, issue.getStatus().getName(), issueKey, "", "Y");
                if (!writer.equals("") && writer != null) {
                    ApplicationUser draftUser = ComponentAccessor.getUserManager().getUserByKey(writer);
                    this.sendMail(language, draftUser.getEmailAddress(), html, "Y", draftUser.getUsername());
                }
            } else if (procType.equals("X")) {
                int n;
                for (ActionDescriptor action : actionDescriptor) {
                    if (!action.getName().equals(rejectName)) continue;
                    n = action.getId();
                }
                for (signUserMngEntity signUserMngEntity5 : smg) {
                    if (!signUserMngEntity5.getApprvoalUserkey().equals(apprvoalUserkey)) continue;
                    signUserMngEntity5.setApprovalPath(approvalPath);
                    signUserMngEntity5.setButtonStatus("N");
                    signUserMngEntity5.save();
                }
                for (issueMngEntity issueMngEntity2 : issueMngEntities) {
                    writer = issueMngEntity2.getUserkey();
                    issueMngEntity2.setInProgressState("X");
                    issueMngEntity2.setLineNum(Integer.parseInt(lineNum));
                    issueMngEntity2.save();
                }
                this.issueTransition((Issue)issue, n, Integer.parseInt(lineNum));
                map.put("approvalCompleted", "Y");
                String statCode = "2";
                String usernm = appUser.getUsername();
                String username = "";
                username = !superuser.equals("") ? this.getApprvoalUserDisplayName(apprvoalUserkey) + " /(\ub300) " + superuser : (loginUserkey.equals(replaceUserKey) ? this.getApprvoalUserDisplayName(apprvoalUserkey) + " /(\ub300) " + this.getApprvoalUserDisplayName(replaceUserKey) : this.getApprvoalUserDisplayName(apprvoalUserkey));
                this.regIssueHistory(statCode, username, issue.getKey());
                String string = mail.getEmailTemp(language, prj, issueKeyUrl, summary, createDate, issue.getStatus().getName(), issueKey, "", "X");
                if (!writer.equals("") && writer != null) {
                    ApplicationUser draftUser = ComponentAccessor.getUserManager().getUserByKey(writer);
                    this.sendMail(language, draftUser.getEmailAddress(), string, "X", draftUser.getUsername());
                }
            } else {
                int idx = 0;
                int currentIDx = 0;
                String nextUser = new String();
                String string = new String();
                boolean flag = false;
                for (signUserMng sign : arraySignList) {
                    if (sign.getApprvoalUserkey().equals(apprvoalUserkey)) {
                        currentIDx = idx + 1;
                        flag = true;
                        ++idx;
                        continue;
                    }
                    if (flag && currentIDx == idx) {
                        nextUser = sign.getApprvoalUserkey();
                        String string5 = sign.getReplaceUserKey();
                        break;
                    }
                    ++idx;
                }
                for (signUserMngEntity userMngEntity : smg) {
                    if (!userMngEntity.getApprvoalUserkey().equals(nextUser)) continue;
                    userMngEntity.setApprovalPath(approvalPath);
                    userMngEntity.setButtonStatus("Y");
                    userMngEntity.save();
                }
                String statCode = "1";
                String username = "";
                username = !superuser.equals("") ? this.getApprvoalUserDisplayName(apprvoalUserkey) + " /(\ub300) " + superuser : (loginUserkey.equals(replaceUserKey) ? this.getApprvoalUserDisplayName(apprvoalUserkey) + " /(\ub300) " + this.getApprvoalUserDisplayName(replaceUserKey) : this.getApprvoalUserDisplayName(apprvoalUserkey));
                this.regIssueHistory(statCode, username, issue.getKey());
                ApplicationUser users = ComponentAccessor.getUserManager().getUserByKey(nextUser);
                if (users != null) {
                    void var61_98;
                    if (portalYn.equals("Y")) {
                        issueKeyUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl") + "/servicedesk/customer/portal/" + portalId + "/" + key;
                    }
                    String emailApprovalUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl") + "/plugins/servlet/kapproval/email?issuekey=" + issueKey + "&userkey=" + users.getKey();
                    String html = mail.getEmailTemp(language, prj, issueKeyUrl, summary, createDate, issue.getStatus().getName(), key, emailApprovalUrl, "");
                    this.sendMail(language, users.getEmailAddress(), html, "", users.getUsername());
                    if (var61_98 != null) {
                        ApplicationUser delegatedUser = ComponentAccessor.getUserManager().getUserByKey((String)var61_98);
                        this.sendMail(language, delegatedUser.getEmailAddress(), html, "", delegatedUser.getUsername());
                    }
                }
                map.put("approvalCompleted", "N");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.getMessage();
            e.printStackTrace();
            if (e.getMessage().equals("passwordFail")) {
                ka.setErrorCode("passwordFail");
                ka.setResultCode(400);
                return ka;
            }
            log.error(e.getMessage());
            ka.setResultMsg(e.getMessage());
            ka.setResultCode(400);
            return ka;
        }
        ka.setResultData(map);
        return ka;
    }

    public void regIssueHistory(String code, String username, String issuekey) throws Exception {
        try {
            issuehisEntity his = (issuehisEntity)this.activeObjects.create(issuehisEntity.class, new DBParam[0]);
            his.setSateCode(code);
            his.setWorkUser(username);
            his.setIssueKey(issuekey);
            his.setRegDateTime(new Date(System.currentTimeMillis()));
            his.save();
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
    }

    private void sendMail(String language, String addr, String html, String stepStatus, String username) throws Exception {
        Email email = new Email(addr);
        String subject = "";
        subject = stepStatus.equals("Y") ? (language == "ko" ? "[K_APPROVAL] " + username + " \ub2d8 \uc548\ub155\ud558\uc138\uc694, \uacb0\uc7ac\uc2b9\uc778\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4." : "[K_APPROVAL] " + username + " Hello, Approval is complete.") : (stepStatus.equals("X") ? (language == "ko" ? "[K_APPROVAL] " + username + " \ub2d8 \uc548\ub155\ud558\uc138\uc694, \uacb0\uc7ac\uac00 \ubc18\ub824\ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4." : "[K_APPROVAL] " + username + " Hello, Your approval has been rejected.") : (language == "ko" ? "[K_APPROVAL] " + username + " \ub2d8 \uc548\ub155\ud558\uc138\uc694, \uc544\ub798 \uc0ac\ud56d\uc5d0 \ub300\ud55c \uc2b9\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4." : "[K_APPROVAL] " + username + " Hello, Approval is required for the following matters."));
        email.setSubject(subject);
        email.setMimeType("text/html");
        email.setBody(html);
        email.setEncoding("UTF-8");
        SingleMailQueueItem item = new SingleMailQueueItem(email);
        ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
    }

    public void issueTransition(Issue issue, int actionid, int linenum) throws Exception {
        try {
            workFlowStEntity wfEntity = (workFlowStEntity)this.activeObjects.create(workFlowStEntity.class, new DBParam[0]);
            wfEntity.setIssueKey(issue.getKey());
            wfEntity.setIssueStatus(issue.getStatus().getNameTranslation());
            wfEntity.setIssueStatusId(issue.getStatusId());
            wfEntity.setYnStatus("Y");
            wfEntity.setLineNum(linenum);
            wfEntity.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        IssueService issueService = ComponentAccessor.getIssueService();
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        TransitionOptions transitionOptions = new TransitionOptions.Builder().skipConditions().skipPermissions().skipValidators().build();
        IssueService.TransitionValidationResult result = issueService.validateTransition(currentUser, issue.getId(), actionid, issueService.newIssueInputParameters(), transitionOptions);
        if (result.isValid()) {
            issueService.transition(currentUser, result);
        } else {
            log.error(String.valueOf(result.getErrorCollection().getErrors()));
        }
    }

    public void deleteIssue(Issue issue, String linename) throws Exception {
        String issuekey = issue.getKey();
        int cntIssue = this.activeObjects.deleteWithSQL(issueMngEntity.class, "ISSUE_KEY = ? ", new Object[]{issuekey});
        int cntSign = this.activeObjects.deleteWithSQL(signUserMngEntity.class, "ISSUE_KEY = ? ", new Object[]{issuekey});
        this.activeObjects.flushAll();
    }

    public KappResult changeWorkFlow(Issue issue, IssueType issueType) throws Exception {
        KappResult ka;
        block1: {
            signUserMngEntity e;
            ka = new KappResult();
            emailUtil mail = new emailUtil();
            List<Object> arraySignList = new ArrayList();
            signUserMngEntity[] signEntitys = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? ", new Object[]{issue.getKey()}));
            arraySignList = Arrays.stream(signEntitys).collect(Collectors.toList());
            Collections.sort(arraySignList, new SortRowNum());
            Iterator<Object> iterator = arraySignList.iterator();
            if (!iterator.hasNext() || !(e = (signUserMngEntity)iterator.next()).getStatus().equals("N") || e.getYnCompleted().equals("Y")) break block1;
            ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByKey(e.getApprvoalUserkey());
            String issueKeyUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl") + "/browse/" + issue.getKey();
            String emailApprovalUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl") + "/plugins/servlet/kapproval/email?issuekey=" + issue.getKey() + "&userkey=" + appUser.getKey();
            Locale locale = this.localeManager.getLocaleFor(appUser);
            String language = locale.getLanguage();
            LocalDateTime createDate = issue.getCreated().toLocalDateTime();
            String key = issue.getKey();
            String status = issue.getStatus().getName();
            String prj = issue.getProjectObject().getName();
            String summary = issue.getSummary().toString();
            String html = mail.getEmailTemp(language, prj, issueKeyUrl, summary, createDate, status, key, emailApprovalUrl, "");
            this.sendMail(language, appUser.getEmailAddress(), html, "", appUser.getUsername());
            if (!e.getReplaceUserKey().equals("") && e.getReplaceUserKey() != null) {
                ApplicationUser delegatedUser = ComponentAccessor.getUserManager().getUserByKey(e.getReplaceUserKey());
                this.sendMail(language, delegatedUser.getEmailAddress(), html, "", delegatedUser.getUsername());
            }
        }
        return ka;
    }

    public KappResult regIssueApproval(Issue issue, String linename) {
        KappResult ka = new KappResult();
        try {
            int lineNum = 0;
            int workflowStatusid = 0;
            Project prj = this.projectManager.getProjectObj(issue.getProjectId());
            String workflnm = this.workflowSchemeManager.getWorkflowName(prj, issue.getIssueTypeId());
            applyListEntity[] applyListEntities = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ?", new Object[]{issue.getProjectObject().getName(), linename, workflnm}));
            Collections.sort(Arrays.asList(applyListEntities), new Comparator<applyListEntity>(){

                @Override
                public int compare(applyListEntity a, applyListEntity b) {
                    return a.getWorkFlowStatusid() - b.getWorkFlowStatusid();
                }
            });
            String prjType = "jira";
            try {
                LineSeqEntity[] lineSeqEntities = (LineSeqEntity[])this.activeObjects.find(LineSeqEntity.class, Query.select().where("RANDOM_KEY != ?", new Object[]{""}));
                String jsmUserKey = "empty";
                if (lineSeqEntities.length > 0) {
                    jsmUserKey = (String)Arrays.stream(lineSeqEntities).map(LineSeqEntity::getUserKey).collect(Collectors.toList()).get(0);
                    for (LineSeqEntity se : lineSeqEntities) {
                        this.activeObjects.deleteWithSQL(LineSeqEntity.class, "USER_KEY = ? ", new Object[]{se.getUserKey()});
                    }
                }
                MutableIssue mutableIssue = ComponentAccessor.getIssueManager().getIssueByCurrentKey(issue.getKey());
                List customFieldsfilds = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects();
                for (CustomField field : customFieldsfilds) {
                    if (!field.getCustomFieldType().getKey().equals("kr.osci.apps.kapproval_jira:approval-custom-field") || issue.getCustomFieldValue(field) != null) continue;
                    prjType = "jiraSerivceDesk";
                    field.createValue(issue, (Object)jsmUserKey);
                    mutableIssue.setCustomFieldValue(field, (Object)jsmUserKey);
                }
            }
            catch (Exception e) {
                e.getMessage();
                e.getStackTrace();
            }
            String customValue = new String();
            try {
                List filds = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects(issue);
                for (CustomField field : filds) {
                    if (!field.getCustomFieldType().getKey().equals("kr.osci.apps.kapproval_jira:approval-custom-field")) continue;
                    customValue = field.getValue(issue).toString();
                }
            }
            catch (Exception e) {
                log.error("filds exception  {}", (Object)e.getMessage());
            }
            issuehisEntity[] issuehisEntities = (issuehisEntity[])this.activeObjects.find(issuehisEntity.class, Query.select().where("PORTAL_TYPE = ?", new Object[]{"JSM"}));
            String PortalID = "";
            if (issuehisEntities.length > 0) {
                PortalID = (String)Arrays.stream(issuehisEntities).map(issuehisEntity::getPotalID).collect(Collectors.toList()).get(0);
            }
            int rowNum = 0;
            for (applyListEntity ale : Arrays.asList(applyListEntities)) {
                lineNum = ale.getLineNum();
                workflowStatusid = ale.getWorkFlowStatusid();
                LineListEntity[] line = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{lineNum}));
                int index = 0;
                for (LineListEntity cn : line) {
                    ++rowNum;
                    if (cn.getApprovalPosition() != null && cn.getApprovalPosition().equals("3")) {
                        String filedValue = "";
                        CustomField field = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(cn.getApprvoalUserkey());
                        Object ogv = issue.getCustomFieldValue(field);
                        String string = filedValue = ogv != null ? String.valueOf(((ApplicationUser)ogv).getUsername()) : "";
                        if (filedValue.equals("")) continue;
                        cn.setApprovalFix(((ApplicationUser)ogv).getUsername());
                        cn.setApprvoalUserkey(((ApplicationUser)ogv).getKey());
                    }
                    signUserMngEntity entity = (signUserMngEntity)this.activeObjects.create(signUserMngEntity.class, new DBParam[0]);
                    String prjid = issue.getProjectId().toString();
                    entity.setLineNum(lineNum);
                    entity.setLineName(this.getLineName(lineNum));
                    entity.setPrjName(issue.getProjectObject().getName());
                    entity.setIssueName(linename);
                    entity.setWorkflowStatusId(workflowStatusid);
                    entity.setApprovalType(cn.getApprovalType());
                    entity.setApprovalUser(cn.getApprvoalUserkey().equals("\uc9c1\uc811\uc120\ud0dd") ? this.getKeyToUserName(customValue) : cn.getApprovalFix());
                    entity.setApprovalOrderNm(cn.getApprovalOrderNm());
                    entity.setApprvoalUserkey(cn.getApprvoalUserkey().equals("\uc9c1\uc811\uc120\ud0dd") ? customValue : cn.getApprvoalUserkey());
                    entity.setDatatime(new Date(System.currentTimeMillis()));
                    entity.setApprovalPosition(cn.getApprovalPosition());
                    entity.setWorkflowStatusName(ale.getWorkFlowStatus());
                    entity.setDcRmk("");
                    entity.setIssueid(Math.toIntExact(issue.getId()));
                    entity.setPrjid(prjid);
                    entity.setStatus("N");
                    entity.setPrjType(prjType);
                    entity.setLineSeq(cn.getLineSeq());
                    entity.setYnCompleted("N");
                    entity.setYnReplaceApprvoal("N");
                    entity.setReplaceUser(this.getReplaceUserInfo(cn.getApprvoalUserkey(), "display"));
                    entity.setReplaceUserKey(this.getReplaceUserInfo(cn.getApprvoalUserkey(), "key"));
                    entity.setIssueKey(issue.getKey());
                    entity.setRowNum(rowNum);
                    entity.setPortalId(PortalID);
                    entity.setButtonStatus(index == 0 ? "Y" : "N");
                    entity.save();
                    ++index;
                }
            }
            issueMngEntity issueMngEntity2 = (issueMngEntity)this.activeObjects.create(issueMngEntity.class, new DBParam[0]);
            ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
            issueMngEntity2.setIssueid(Math.toIntExact(issue.getId()));
            issueMngEntity2.setIssueKey(issue.getKey());
            issueMngEntity2.setInProgressState("N");
            issueMngEntity2.setDisName(appUser.getDisplayName());
            issueMngEntity2.setUserkey(appUser.getKey());
            issueMngEntity2.save();
            workFlowStEntity wfEntity = (workFlowStEntity)this.activeObjects.create(workFlowStEntity.class, new DBParam[0]);
            wfEntity.setIssueKey(issue.getKey());
            wfEntity.setIssueStatus(issue.getStatus().getNameTranslation());
            wfEntity.setIssueStatusId(issue.getStatusId());
            wfEntity.setYnStatus("Y");
            wfEntity.setLineNum(lineNum);
            wfEntity.save();
            String statCode = "0";
            String usernm = appUser.getUsername();
            this.regIssueHistory(statCode, usernm, issue.getKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return ka;
    }

    private String positionToUsername(String position) throws Exception {
        orgUserEntity[] userEntities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("POSITION = ? ", new Object[]{position}));
        List arrayOrg = Arrays.stream(userEntities).map(orgUserEntity::getUsername).collect(Collectors.toList());
        return arrayOrg.size() > 0 ? (String)arrayOrg.get(0) : "";
    }

    private String getLineName(int linenum) throws Exception {
        configEntity[] entity = (configEntity[])this.activeObjects.find(configEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{linenum}));
        String linename = "";
        for (configEntity cn : entity) {
            linename = cn.getLineName();
        }
        return linename;
    }

    private String getReplaceUserInfo(String userkey, String type) throws Exception {
        replaceUserEntity[] replaceUserEntities = (replaceUserEntity[])this.activeObjects.find(replaceUserEntity.class, Query.select().where("LOGIN_USERKEY = ? ", new Object[]{userkey}));
        String retValue = new String();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (replaceUserEntity entity : replaceUserEntities) {
            ApplicationUser appuser = ComponentAccessor.getUserManager().getUserByKey(entity.getReplaceUserkey());
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            String currentDate = sdf.format(cal.getTime());
            String stDate = entity.getStartDate();
            String edDate = entity.getEndDate();
            Long stTime = Long.valueOf(stDate);
            Long edTime = Long.valueOf(edDate);
            Long cuurentTime = Long.valueOf(currentDate);
            boolean bl = issueRegServiceImpl.isWithinRange(cuurentTime, stTime, edTime);
            if (!bl) continue;
            retValue = type.equals("key") ? appuser.getKey() : appuser.getDisplayName();
        }
        return retValue;
    }

    private String getApprvoalUserDisplayName(String userkey) throws Exception {
        return ComponentAccessor.getUserManager().getUserByKey(userkey).getDisplayName();
    }

    public static boolean isWithinRange(Long date, Long startDate, Long endDate) throws ParseException {
        return startDate <= date && date <= endDate;
    }

    private String getKeyToUserName(String userkey) throws Exception {
        ApplicationUser users = ComponentAccessor.getUserManager().getUserByKey(userkey);
        return users == null ? "" : users.getDisplayName();
    }

    public ArrayList getRequestIssue(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            signUserMngEntity[] signUserMngEntity2;
            for (signUserMngEntity se : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where(" APPRVOAL_USERKEY = ? ", new Object[]{userkey}))) {
                if (!se.getStatus().equals("Y") || this.isIssueNull(se.getIssueKey())) continue;
                arrayList.add(se.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList PendingApproval(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            signUserMngEntity[] signUserMngEntity2;
            for (signUserMngEntity se : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where(" APPRVOAL_USERKEY = ? ", new Object[]{userkey}))) {
                if (!se.getStatus().equals("N") || this.isIssueNull(se.getIssueKey())) continue;
                arrayList.add(se.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList getRejectedApproval(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            signUserMngEntity[] signUserMngEntity2;
            for (signUserMngEntity se : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("APPRVOAL_USERKEY = ? OR REPLACE_USER_KEY = ?", new Object[]{userkey, userkey}))) {
                if (!se.getStatus().equals("X") || this.isIssueNull(se.getIssueKey())) continue;
                arrayList.add(se.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList getApprovalRequested(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            issueMngEntity[] issueMngEntities;
            for (issueMngEntity issueMngEntity2 : issueMngEntities = (issueMngEntity[])this.activeObjects.find(issueMngEntity.class, Query.select().where("USERKEY = ?", new Object[]{userkey}))) {
                if (this.isIssueNull(issueMngEntity2.getIssueKey())) continue;
                arrayList.add(issueMngEntity2.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList getApprovalApproved(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            issueMngEntity[] issueMngEntities;
            for (issueMngEntity ie : issueMngEntities = (issueMngEntity[])this.activeObjects.find(issueMngEntity.class, Query.select().where("USERKEY = ?", new Object[]{userkey}))) {
                if (!ie.getInProgressState().equals("Y") || this.isIssueNull(ie.getIssueKey())) continue;
                arrayList.add(ie.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList getApprovalRejected(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            issueMngEntity[] issueMngEntities;
            for (issueMngEntity ie : issueMngEntities = (issueMngEntity[])this.activeObjects.find(issueMngEntity.class, Query.select().where("USERKEY = ?", new Object[]{userkey}))) {
                if (!ie.getInProgressState().equals("X") || this.isIssueNull(ie.getIssueKey())) continue;
                arrayList.add(ie.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList getApprovalRefer(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            signUserMngEntity[] signUserMngEntity2;
            for (signUserMngEntity su : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("APPRVOAL_USERKEY = ? ", new Object[]{userkey}))) {
                if (!su.getApprovalType().equals("\ucc38\uc870") || this.isIssueNull(su.getIssueKey())) continue;
                arrayList.add(su.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public ArrayList getPendingForDelegatedApproval(String userkey) {
        KappResult ka = new KappResult();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            signUserMngEntity[] signUserMngEntity2;
            for (signUserMngEntity se : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("(APPRVOAL_USERKEY = ? OR REPLACE_USER_KEY = ?) AND YN_REPLACE_APPRVOAL = ? ", new Object[]{userkey, userkey, "Y"}))) {
                if (this.isIssueNull(se.getIssueKey())) continue;
                arrayList.add(se.getIssueKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return arrayList;
    }

    public boolean isIssueNull(String issuekey) {
        try {
            MutableIssue issue = this.issueManager.getIssueObject(issuekey);
            return issue == null;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            return true;
        }
    }

    private class SortWorkFlowStatusID
    implements Comparator<signUserMngEntity> {
        private SortWorkFlowStatusID() {
        }

        @Override
        public int compare(signUserMngEntity a, signUserMngEntity b) {
            return a.getWorkflowStatusId() - b.getWorkflowStatusId();
        }
    }

    private class SortRowNum
    implements Comparator<signUserMngEntity> {
        private SortRowNum() {
        }

        @Override
        public int compare(signUserMngEntity a, signUserMngEntity b) {
            return a.getRowNum() - b.getRowNum();
        }
    }
}

