/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.bc.workflow.WorkflowTransitionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.ConfigDetail;
import kr.osci.apps.kapproval.entity.ConfigDetailEntity;
import kr.osci.apps.kapproval.entity.ConfigFileds;
import kr.osci.apps.kapproval.entity.ConfigFiledsEntity;
import kr.osci.apps.kapproval.entity.LineList;
import kr.osci.apps.kapproval.entity.LineListEntity;
import kr.osci.apps.kapproval.entity.LineSeqEntity;
import kr.osci.apps.kapproval.entity.SettingEntity;
import kr.osci.apps.kapproval.entity.applyList;
import kr.osci.apps.kapproval.entity.applyListEntity;
import kr.osci.apps.kapproval.entity.config;
import kr.osci.apps.kapproval.entity.configEntity;
import kr.osci.apps.kapproval.entity.issueMngEntity;
import kr.osci.apps.kapproval.entity.orgEntity;
import kr.osci.apps.kapproval.entity.orgUserEntity;
import kr.osci.apps.kapproval.entity.replaceUserEntity;
import kr.osci.apps.kapproval.entity.signUserMng;
import kr.osci.apps.kapproval.entity.signUserMngEntity;
import kr.osci.apps.kapproval.entity.workFlowStEntity;
import kr.osci.apps.kapproval.service.configService;
import kr.osci.apps.kapproval.service.impl.SettingServiceImpl;
import kr.osci.apps.kapproval.service.impl.issueRegServiceImpl;
import kr.osci.apps.kapproval.service.impl.orgServiceImpl;
import kr.osci.apps.kapproval.utills.StringUtil;
import net.java.ao.DBParam;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Named
@Preload
public class configServiceImpl
implements configService {
    private static final Logger log = LoggerFactory.getLogger(configServiceImpl.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final ProjectManager projectManager;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final WorkflowManager workflowManager;
    @ComponentImport
    private final WorkflowService workflowService;
    @ComponentImport
    private final LoginService loginInfo;
    @ComponentImport
    private final WorkflowTransitionService workflowTransitionService;
    @ComponentImport
    private final AvatarService avatarService;
    @ComponentImport
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    @ComponentImport
    private final WorkflowSchemeManager workflowSchemeManager;
    @ComponentImport
    private final ProjectRoleManager projectRoleManager;
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final FieldManager fieldManager;
    @Autowired
    private final orgServiceImpl orgService;
    @Autowired
    private final SettingServiceImpl settingService;
    @Autowired
    private final issueRegServiceImpl issueRegService;
    private final String kApprovalConditionName = "kr.osci.apps.kapproval.workflow.condition.ApprovalLineCondition";

    @Inject
    public configServiceImpl(ActiveObjects activeObjects, ProjectManager projectManager, IssueManager issueManager, WorkflowManager workflowManager, WorkflowService workflowService, SettingServiceImpl settingService, WorkflowTransitionService workflowTransitionService, AvatarService avatarService, IssueTypeSchemeManager issueTypeSchemeManager, WorkflowSchemeManager workflowSchemeManager, ProjectRoleManager projectRoleManager, PluginLicenseManager licenseManager, LoginService loginInfo, FieldManager fieldManager, orgServiceImpl orgService2, issueRegServiceImpl issueRegService2) {
        this.activeObjects = activeObjects;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.workflowManager = workflowManager;
        this.workflowService = workflowService;
        this.workflowTransitionService = workflowTransitionService;
        this.avatarService = avatarService;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectRoleManager = projectRoleManager;
        this.licenseManager = licenseManager;
        this.fieldManager = fieldManager;
        this.orgService = orgService2;
        this.issueRegService = issueRegService2;
        this.loginInfo = loginInfo;
        this.settingService = settingService;
    }

    @Override
    public KappResult saveApprovalLine(Object config2) throws KappExceptionHandler, Exception {
        return this.saveApproval(config2);
    }

    @Override
    public KappResult bulkApprovalList(Object config2) throws KappExceptionHandler, Exception {
        return this.bulkApprovalProcess(config2);
    }

    @Override
    public KappResult saveApprovalApplyLine(Object config2) throws KappExceptionHandler, Exception {
        return this.saveApprovalApply(config2);
    }

    @Override
    public KappResult getApprovalList() throws KappExceptionHandler, Exception {
        return this.selectApprovaList();
    }

    @Override
    public KappResult removeLine(String num) throws KappExceptionHandler, Exception {
        return this.removeKappLine(num);
    }

    @Override
    public KappResult editApprovalLine(String num) throws KappExceptionHandler, Exception {
        return this.editSlectList(num);
    }

    @Override
    public KappResult saveApprovalLineName(String key, String name) throws KappExceptionHandler, Exception {
        return this.saveLineNm(key, name);
    }

    @Override
    public KappResult saveApprovalLineDesc(String key, String desc) throws KappExceptionHandler, Exception {
        return this.saveLineDesc(key, desc);
    }

    @Override
    public KappResult editApprovalAllLine(String num) throws KappExceptionHandler, Exception {
        return this.editSlectAllList(num);
    }

    @Override
    public KappResult getProjects() throws KappExceptionHandler, Exception {
        return this.allProjectList();
    }

    @Override
    public KappResult getIssueType(int id) throws KappExceptionHandler, Exception {
        return this.getIssueTypes(id);
    }

    @Override
    public KappResult getWorkFlows(String prjid, String id) throws KappExceptionHandler, Exception {
        return this.getjiraWorkFlows(prjid, id);
    }

    @Override
    public KappResult getTransApproval(String id, String value, String wfnm) throws KappExceptionHandler, Exception {
        return this.getTransState(id, value, wfnm);
    }

    @Override
    public KappResult getEditLindList(int seq) throws KappExceptionHandler, Exception {
        return this.searchEditLineInfo(seq);
    }

    @Override
    public KappResult deleteTypeLine(int seq) throws KappExceptionHandler, Exception {
        return this.removeTypeLine(seq);
    }

    @Override
    public KappResult externalApproval(String ty, String issukey, String userkey, String path, String dcrmk) throws KappExceptionHandler, Exception {
        return this.approvalToExternal(ty, issukey, userkey, path, dcrmk);
    }

    @Override
    public KappResult getAllPendingList() throws KappExceptionHandler, Exception {
        return this.selectAllPendingList();
    }

    @Override
    public KappResult getApprovalLineInfo(String issuekey, String userkey) throws KappExceptionHandler, Exception {
        return this.selectApprovalinfo(issuekey, userkey);
    }

    @Override
    public KappResult getCustomFiledApprovalLine(String filedname, String fieldvalue) throws KappExceptionHandler, Exception {
        return this.selectCustomFiledApprovalLine(filedname, fieldvalue);
    }

    private KappResult approvalToExternal(String procType, String issukey, String userkey, String path, String dcrmk) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        if (StringUtil.isEmpty(procType)) {
            throw new IllegalArgumentException("The approvalty is null");
        }
        if (StringUtil.isEmpty(issukey)) {
            throw new IllegalArgumentException("The issuekey is null");
        }
        if (StringUtil.isEmpty(userkey)) {
            throw new IllegalArgumentException("The userkey is null");
        }
        if (StringUtil.isEmpty(path)) {
            throw new IllegalArgumentException("The path is null");
        }
        signUserMngEntity[] signs = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND APPRVOAL_USERKEY = ?", new Object[]{issukey, userkey}));
        if (signs.length == 0) {
            result.setResultCode(200);
            result.setResultMsg("No Data");
            return result;
        }
        List currentStatus = Arrays.stream(signs).map(signUserMngEntity::getStatus).collect(Collectors.toList());
        String status = (String)currentStatus.get(0);
        if ("Y".equals(status)) {
            result.setResultCode(200);
            result.setResultMsg("completed");
            return result;
        }
        for (signUserMngEntity e : signs) {
            LinkedHashMap<String, String> config2 = new LinkedHashMap<String, String>();
            config2.put("lineName", e.getLineName());
            config2.put("lineNum", String.valueOf(e.getLineNum()));
            config2.put("procType", procType);
            config2.put("prjid", e.getPrjid());
            config2.put("issueid", String.valueOf(e.getIssueid()));
            config2.put("issueTynm", "issueTynm");
            config2.put("approvalUser", e.getApprovalUser());
            config2.put("apprvoalUserkey", e.getApprvoalUserkey());
            config2.put("replaceUser", e.getReplaceUser());
            config2.put("replaceUserKey", e.getReplaceUserKey());
            config2.put("approvalType", e.getApprovalType());
            config2.put("approvalOrderNm", e.getApprovalOrderNm());
            config2.put("issueKey", e.getIssueKey());
            config2.put("superuser", "");
            config2.put("superuserkey", "");
            config2.put("approvalPath", path);
            config2.put("dcrmk", dcrmk);
            config2.put("userkey", userkey);
            try {
                this.issueRegService.saveSignInfo(config2);
            }
            catch (KappExceptionHandler kappExceptionHandler) {
                kappExceptionHandler.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        result.setResultCode(200);
        result.setResultMsg("Success");
        return result;
    }

    private KappResult selectCustomFiledApprovalLine(String fieldname, String fieldvalue) throws KappExceptionHandler, Exception {
        ConfigFiledsEntity[] configFiledsEntities;
        KappResult result = new KappResult();
        int LineNum = 0;
        int LineSeq2 = 0;
        ArrayList<signUserMng> arraySignList = new ArrayList<signUserMng>();
        List settings = (List)this.settingService.getSettingLineInfo().getResultData();
        for (ConfigFiledsEntity configFiledsEntity : configFiledsEntities = (ConfigFiledsEntity[])this.activeObjects.find(ConfigFiledsEntity.class, Query.select().where("FILED_NAME = ? AND FILED_VALUE = ?", new Object[]{fieldname, fieldvalue}))) {
            LineNum = configFiledsEntity.getLineNum();
            LineSeq2 = configFiledsEntity.getLineSeq();
        }
        LineListEntity[] lineListEntity = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? AND  LINE_SEQ = ? ", new Object[]{LineNum, LineSeq2}));
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        for (LineListEntity entity : lineListEntity) {
            signUserMng signUserMng2 = new signUserMng();
            signUserMng2.setApprovalPosition(entity.getApprovalPosition());
            signUserMng2.setApprovalOrderNm(entity.getApprovalOrderNm());
            signUserMng2.setApprovalType(entity.getApprovalType());
            signUserMng2.setApprovalUser(entity.getApprovalFix());
            signUserMng2.setApprvoalUserkey(entity.getApprvoalUserkey());
            signUserMng2.setReplaceUser(this.getReplaceUser(entity.getApprvoalUserkey(), "display"));
            signUserMng2.setReplaceUserKey(this.getReplaceUser(entity.getApprvoalUserkey(), "key"));
            signUserMng2.setLineNum(entity.getLineNum());
            signUserMng2.setStatus("N");
            signUserMng2.setDcRmk("");
            signUserMng2.setYnCompleted("N");
            signUserMng2.setLastApprovalUser("");
            signUserMng2.setYnReplaceApprvoal("N");
            signUserMng2.setButtonStatus("N");
            signUserMng2.setAvatarUrl(this.getAvatarUrl(appUser, entity.getApprvoalUserkey()));
            signUserMng2.setWorkflowStatusId(0);
            arraySignList.add(signUserMng2);
        }
        HashMap<String, List> hm = new HashMap<String, List>();
        hm.put("arraySignList", arraySignList);
        hm.put("settings", settings);
        result.setResultData(hm);
        return result;
    }

    private KappResult selectApprovalinfo(String issuekey, String userkey) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        Issue issue = this.isIssueNull(issuekey);
        if (issue == null) {
            throw new IllegalArgumentException("The issue does not exist");
        }
        if (StringUtil.isEmpty(issuekey)) {
            throw new IllegalArgumentException("The issuekey is null");
        }
        if (StringUtil.isEmpty(userkey)) {
            throw new IllegalArgumentException("The userkey is null");
        }
        ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByKey(userkey);
        ArrayList arraySignList = new ArrayList();
        signUserMngEntity[] sign = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ?  ", new Object[]{issuekey}));
        Arrays.stream(sign).forEach(item -> {
            signUserMng e = new signUserMng();
            e.setApprovalPath(item.getApprovalPath());
            e.setApprovalPosition(item.getApprovalPosition());
            e.setPortalId(item.getPortalId());
            e.setAvatarUrl(this.getAvatarUrl(appUser, item.getApprvoalUserkey()));
            e.setLineName(item.getLineName());
            e.setIssueName(item.getIssueName());
            e.setPrjName(item.getPrjName());
            e.setWorkflowStatusId(item.getWorkflowStatusId());
            e.setApprovalPath(item.getApprovalPath());
            e.setYnCompleted(item.getYnCompleted());
            e.setYnReplaceApprvoal(item.getYnReplaceApprvoal());
            e.setLastApprovalUser(item.getLastApprovalUser());
            e.setApprvoalUserkey(item.getApprvoalUserkey());
            e.setReplaceUser(item.getReplaceUser());
            e.setReplaceUserKey(item.getReplaceUserKey());
            e.setButtonStatus(item.getButtonStatus());
            e.setPkid(item.getPkid());
            e.setApprovalTime(item.getApprovalTime());
            e.setApprovalUser(item.getApprovalUser());
            e.setLineNum(item.getLineNum());
            e.setDatatime(item.getDatatime());
            e.setYnReplaceApprvoal(item.getYnReplaceApprvoal());
            e.setStatus(item.getStatus());
            e.setApprovalOrderNm(item.getApprovalOrderNm());
            e.setIssueKey(item.getIssueKey());
            e.setPrjid(item.getPrjid());
            e.setPrjType(item.getPrjType());
            e.setDcRmk(item.getDcRmk());
            e.setRowNum(item.getRowNum());
            e.setIssueid(item.getIssueid());
            e.setSuperuser(item.getSuperuser());
            e.setSuperuserkey(item.getSuperuserkey());
            arraySignList.add(e);
        });
        result.setResultMsg("SUCCESS");
        result.setResultData(arraySignList);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private KappResult selectAllPendingList() throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        ArrayList pendingList = new ArrayList();
        HashMap<String, String> appUserMap = new HashMap<String, String>();
        try {
            void var9_16;
            String YnSuperUser;
            SettingEntity[] settingEntities;
            SettingEntity[] settingPassword;
            int SETTING_APPROVAL_PASSWORD_KEY = 2;
            for (SettingEntity settingEntity : settingPassword = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{SETTING_APPROVAL_PASSWORD_KEY}))) {
                appUserMap.put("passwordOption", settingEntity.getApprovalLineTy());
            }
            ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
            appUserMap.put("username", appUser.getUsername());
            appUserMap.put("displayname", appUser.getDisplayName());
            appUserMap.put("userkey", appUser.getKey());
            pendingList.add(appUserMap);
            int SETTING_APPROVAL_SUPERUSERS_KEY = 3;
            for (SettingEntity entity : settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{SETTING_APPROVAL_SUPERUSERS_KEY}))) {
                if (appUser.getKey().equals(entity.getApprovalLineTy())) {
                    appUserMap.put("YnSuperUser", "Y");
                    continue;
                }
                appUserMap.put("YnSuperUser", "N");
            }
            Object var9_13 = null;
            String string = YnSuperUser = (String)appUserMap.get("YnSuperUser") == null ? "" : (String)appUserMap.get("YnSuperUser");
            if (YnSuperUser.equals("Y")) {
                signUserMngEntity[] signUserMngEntityArray = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where(" STATUS = ?", new Object[]{"N"}));
            } else {
                signUserMngEntity[] signUserMngEntityArray = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where(" APPRVOAL_USERKEY = ? AND STATUS = ?", new Object[]{appUser.getKey(), "N"}));
            }
            for (void se : var9_16) {
                Issue issue = this.isIssueNull(se.getIssueKey());
                if (issue == null || !this.pendingApprovalCheck(appUser, issue, (signUserMngEntity)se, YnSuperUser)) continue;
                HashMap<String, Object> pend = new HashMap<String, Object>();
                pend.put("summary", issue.getSummary());
                pend.put("issueKey", issue.getKey());
                pend.put("issueType", issue.getIssueTypeId());
                pend.put("workflowsStatus", se.getWorkflowStatusName());
                pend.put("timestamp", issue.getCreated());
                pend.put("prjName", se.getPrjName());
                pend.put("approvalUser", se.getApprovalUser());
                pend.put("approvalUserKey", se.getApprvoalUserkey());
                pend.put("issueName", se.getIssueName());
                pend.put("approvalstate", "N");
                pendingList.add(pend);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        result.setResultData(pendingList);
        return result;
    }

    public Issue isIssueNull(String issuekey) {
        try {
            MutableIssue issue = this.issueManager.getIssueObject(issuekey);
            return issue == null ? null : issue;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            return null;
        }
    }

    private boolean pendingApprovalCheck(ApplicationUser appUser, Issue issue, signUserMngEntity entity, String ynSuperUser) throws Exception {
        String translationNm = issue.getStatus() != null ? issue.getStatus().getNameTranslation() : "";
        String statusName = issue.getStatus() != null ? issue.getStatus().getName() : "";
        Project prj = this.projectManager.getProjectObj(issue.getProjectId());
        String workflnm = this.workflowSchemeManager.getWorkflowName(prj, issue.getIssueTypeId());
        String workStatus = this.warkstatusName(entity.getPrjName(), entity.getIssueName(), workflnm, issue.getStatus().getId());
        return "Y".equals(ynSuperUser) ? (translationNm.equals(workStatus) || statusName.equals(workStatus)) && entity.getButtonStatus().equals("Y") && !entity.getApprvoalUserkey().equals("null") : !(!translationNm.equals(workStatus) && !statusName.equals(workStatus) || !appUser.getKey().equals(entity.getApprvoalUserkey()) && !appUser.getKey().equals(entity.getReplaceUserKey()) || !entity.getButtonStatus().equals("Y") || entity.getApprvoalUserkey().equals("null"));
    }

    public String warkstatusName(String prjNm, String issueNm, String workflnm, String statusid) throws Exception {
        String workStatus = "";
        applyListEntity[] applyListEntities = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ?", new Object[]{prjNm, issueNm, workflnm}));
        if (Arrays.asList(applyListEntities).size() > 0) {
            for (applyListEntity applyListEntity2 : Arrays.asList(applyListEntities)) {
                if (!statusid.equals("")) {
                    int approvalStatusid = applyListEntity2.getWorkFlowStatusid();
                    if (Integer.parseInt(statusid) > approvalStatusid) continue;
                    workStatus = applyListEntity2.getWorkFlowStatus();
                    break;
                }
                workStatus = applyListEntity2.getWorkFlowStatus();
            }
        }
        return workStatus;
    }

    private KappResult removeTypeLine(int seq) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        try {
            this.activeObjects.deleteWithSQL(LineListEntity.class, "LINE_SEQ = ? ", new Object[]{seq});
            this.activeObjects.deleteWithSQL(ConfigDetailEntity.class, "LINE_SEQ = ? ", new Object[]{seq});
            this.activeObjects.deleteWithSQL(ConfigFiledsEntity.class, "LINE_SEQ = ? ", new Object[]{seq});
        }
        catch (Exception e) {
            e.getStackTrace();
            e.getMessage();
        }
        result.setResultData(seq);
        return result;
    }

    private KappResult searchEditLineInfo(int seq) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        LineListEntity[] lineListEntity = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_SEQ = ? ", new Object[]{seq}));
        ConfigDetailEntity[] configDetailEntities = (ConfigDetailEntity[])this.activeObjects.find(ConfigDetailEntity.class, Query.select().where("LINE_SEQ = ? ", new Object[]{seq}));
        ConfigFiledsEntity[] configFiledsEntities = (ConfigFiledsEntity[])this.activeObjects.find(ConfigFiledsEntity.class, Query.select().where("LINE_SEQ = ? ", new Object[]{seq}));
        ArrayList<LineList> arrayLineList = new ArrayList<LineList>();
        ArrayList<ConfigDetail> detailArrayList = new ArrayList<ConfigDetail>();
        ArrayList<ConfigFileds> filedsArrayList = new ArrayList<ConfigFileds>();
        String detailCode = "0";
        for (ConfigDetailEntity configDetailEntity : configDetailEntities) {
            ConfigDetail configDetail = new ConfigDetail();
            configDetail.setDetailCode(configDetailEntity.getDetailCode());
            configDetail.setLineName(configDetailEntity.getLineName());
            configDetail.setLineNum(configDetailEntity.getLineNum());
            configDetail.setOrgId(configDetailEntity.getOrgId());
            configDetail.setOrgName(configDetailEntity.getOrgName());
            detailCode = configDetailEntity.getDetailCode();
            detailArrayList.add(configDetail);
        }
        for (ConfigFiledsEntity configFiledsEntity : configFiledsEntities) {
            ConfigFileds configFileds = new ConfigFileds();
            configFileds.setDetailCode(configFiledsEntity.getDetailCode());
            configFileds.setLineName(configFiledsEntity.getLineName());
            configFileds.setLineNum(configFiledsEntity.getLineNum());
            configFileds.setFiledName(configFiledsEntity.getFiledName());
            configFileds.setFiledValue(configFiledsEntity.getFiledValue());
            detailCode = configFiledsEntity.getDetailCode();
            filedsArrayList.add(configFileds);
        }
        for (LineListEntity lineList : lineListEntity) {
            LineList line = new LineList();
            line.setApprovalOrderNm(lineList.getApprovalOrderNm());
            line.setApprovalPosition(lineList.getApprovalPosition());
            line.setApprovalType(lineList.getApprovalType());
            line.setApprovalFix(lineList.getApprovalFix());
            line.setLineNum(lineList.getLineNum());
            line.setApprvoalUserkey(lineList.getApprvoalUserkey());
            arrayLineList.add(line);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lineListEntity", arrayLineList);
        map.put("detailArrayList", detailArrayList);
        map.put("filedsArrayList", filedsArrayList);
        map.put("detailCode", detailCode);
        result.setResultData(map);
        return result;
    }

    private KappResult getTransState(String id, String value, String wfnm) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        Collection workflows = this.workflowManager.getWorkflows();
        ArrayList actions = new ArrayList();
        LinkedHashMap map = new LinkedHashMap();
        for (JiraWorkflow jiraWorkflow : workflows) {
            List stepDescriptors = jiraWorkflow.getDescriptor().getSteps();
            if (!jiraWorkflow.getName().equals(wfnm)) continue;
            for (StepDescriptor sd : stepDescriptors) {
                if (!sd.getName().equals(value)) continue;
                ArrayList ac = (ArrayList)sd.getActions();
                for (ActionDescriptor action : ac) {
                    LinkedHashMap<String, Object> hm = new LinkedHashMap<String, Object>();
                    hm.put("id", action.getId());
                    hm.put("name", action.getName());
                    actions.add(hm);
                }
            }
        }
        map.put("actions", actions);
        result.setResultData(map);
        return result;
    }

    private KappResult getjiraWorkFlows(String prjid, String issueid) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        Project prj = this.projectManager.getProjectObj(Long.valueOf(prjid));
        String workFlowName = this.workflowSchemeManager.getWorkflowName(prj, issueid);
        Collection workflows = this.workflowManager.getWorkflows();
        ArrayList arraySteps = new ArrayList();
        for (JiraWorkflow jiraWorkflow : workflows) {
            List stepDescriptors = jiraWorkflow.getDescriptor().getSteps();
            if (!jiraWorkflow.getName().equals(workFlowName)) continue;
            for (StepDescriptor sd : stepDescriptors) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("name", sd.getName());
                map.put("id", (String)sd.getMetaAttributes().get("jira.status.id"));
                arraySteps.add(map);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arrayWorknm", workFlowName);
        map.put("arraySteps", arraySteps);
        result.setResultData(map);
        return result;
    }

    private KappResult getIssueTypes(int id) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        List prj = this.projectManager.getProjects();
        ArrayList arryIssueTypes = new ArrayList();
        for (Project project : prj) {
            if (project.getId() != (long)id) continue;
            Collection issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
            for (IssueType issueType : issueTypes) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("icon", issueType.getCompleteIconUrl());
                map.put("name", issueType.getName());
                map.put("id", issueType.getId());
                arryIssueTypes.add(map);
            }
        }
        result.setResultData(arryIssueTypes);
        return result;
    }

    private KappResult allProjectList() throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        List prj = this.projectManager.getProjects();
        ArrayList arrayProject = new ArrayList();
        for (Project project : prj) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            String icon = this.avatarService.getProjectAvatarURL(project, Avatar.Size.biggerThan((int)100)).toString();
            String name = project.getName();
            Long id = project.getId();
            map.put("icon", icon);
            map.put("name", name);
            map.put("id", id);
            arrayProject.add(map);
        }
        result.setResultData(arrayProject);
        return result;
    }

    public KappResult getApprovalInfo(Issue issue, String issueNm, String issueKey, String prjNm, String issueTypeid, Long prjid, String workflowstatus, String statusid) {
        KappResult result = new KappResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int fieldSeq = 0;
        ArrayList arrayApplyList = new ArrayList();
        ArrayList arrayLineList = new ArrayList();
        ArrayList<signUserMng> arraySignList = new ArrayList<signUserMng>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        config conf = new config();
        int vLineNum = 0;
        String detailCode = "0";
        String workStatus = new String();
        String ynPasswd = "";
        String ynSuperuser = "";
        String fieldid = "";
        try {
            configEntity[] entity;
            ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
            String userKey = appUser.getKey();
            issueMngEntity[] issueMngEntitys = (issueMngEntity[])this.activeObjects.find(issueMngEntity.class, Query.select().where("ISSUE_KEY = ?", new Object[]{issueKey}));
            Project prj = this.projectManager.getProjectObj(prjid);
            String workflnm = this.workflowSchemeManager.getWorkflowName(prj, issueTypeid);
            applyListEntity[] applyListEntities = null;
            if (issueKey == null) {
                applyListEntities = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ?", new Object[]{prjNm, issueNm, workflnm}));
                Collections.sort(Arrays.asList(applyListEntities), new Comparator<applyListEntity>(){

                    @Override
                    public int compare(applyListEntity b1, applyListEntity b2) {
                        return b2.getWorkFlowStatusid() - b1.getWorkFlowStatusid();
                    }
                });
            } else {
                applyListEntities = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ?", new Object[]{prjNm, issueNm, workflnm}));
                Collections.sort(Arrays.asList(applyListEntities), new Comparator<applyListEntity>(){

                    @Override
                    public int compare(applyListEntity b1, applyListEntity b2) {
                        return b1.getWorkFlowStatusid() - b2.getWorkFlowStatusid();
                    }
                });
            }
            if (Arrays.asList(applyListEntities).size() > 0) {
                for (applyListEntity applyListEntity2 : Arrays.asList(applyListEntities)) {
                    if (!statusid.equals("")) {
                        int approvalStatusid = applyListEntity2.getWorkFlowStatusid();
                        if (Integer.parseInt(statusid) > approvalStatusid) continue;
                        vLineNum = applyListEntity2.getLineNum();
                        workStatus = applyListEntity2.getWorkFlowStatus();
                        break;
                    }
                    vLineNum = applyListEntity2.getLineNum();
                    workStatus = applyListEntity2.getWorkFlowStatus();
                }
            }
            for (issueMngEntity im : issueMngEntitys) {
                map.put("writer", im.getDisName());
                if (!im.getInProgressState().equals("Y") && !im.getInProgressState().equals("X")) continue;
                vLineNum = im.getLineNum();
            }
            for (configEntity cn : entity = (configEntity[])this.activeObjects.find(configEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{vLineNum}))) {
                conf.setLineName(cn.getLineName());
                conf.setLineNum(cn.getLineNum());
                conf.setLineDesc(cn.getLineDesc());
                conf.setRegDateTime(cn.getRegDateTime());
                conf.setDetailCode(cn.getDetailCode() == null ? "0" : cn.getDetailCode());
                conf.setLineApprovaUser(cn.getLineApprovaUser());
                detailCode = conf.getDetailCode();
            }
            int settingKey = 2;
            SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{settingKey}));
            if (settingEntities.length > 0) {
                List passwordUse = Arrays.stream(settingEntities).map(SettingEntity::getApprovalLineTy).collect(Collectors.toList());
                ynPasswd = (String)passwordUse.get(0);
            }
            int settingSuperUserKey = 3;
            SettingEntity[] settingSuperuser = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{settingSuperUserKey}));
            if (settingSuperuser.length > 0) {
                for (SettingEntity superuser : settingSuperuser) {
                    ynSuperuser = appUser.getKey().equals(superuser.getApprovalLineTy()) ? "Y" : "N";
                }
            }
            Boolean isDetailCodeExist = false;
            if (detailCode.equals("1")) {
                ConfigDetailEntity[] configDetailEntities = (ConfigDetailEntity[])this.activeObjects.find(ConfigDetailEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{vLineNum}));
                List orgList = Arrays.stream(configDetailEntities).map(ConfigDetailEntity::getOrgName).collect(Collectors.toList());
                ArrayList UserList = new ArrayList();
                for (String orgName : orgList) {
                    orgUserEntity[] userEntities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("ORGNAME = ? ", new Object[]{orgName}));
                    UserList.addAll(Arrays.stream(userEntities).map(orgUserEntity::getUserKey).collect(Collectors.toList()));
                }
                for (String key : UserList) {
                    if (!key.equals(userKey)) continue;
                    isDetailCodeExist = true;
                    break;
                }
            } else if (detailCode.equals("2")) {
                ConfigFiledsEntity[] configFiledsEntities = (ConfigFiledsEntity[])this.activeObjects.find(ConfigFiledsEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{vLineNum}));
                List filedNames = Arrays.stream(configFiledsEntities).map(ConfigFiledsEntity::getFiledName).collect(Collectors.toList());
                fieldid = (String)filedNames.get(0);
                if (issue == null) {
                    isDetailCodeExist = false;
                } else {
                    workFlowStEntity[] filedValue;
                    block38: {
                        GenericValue gv = issue.getGenericValue();
                        filedValue = "";
                        if (gv != null) {
                            try {
                                filedValue = (String)gv.get(fieldid);
                            }
                            catch (Exception e) {
                                CustomField customField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(fieldid);
                                Object object = issue.getCustomFieldValue(customField);
                                if (object == null) break block38;
                                filedValue = String.valueOf(((Option)object).getOptionId());
                            }
                        }
                    }
                    List filedsEntities = Arrays.stream(configFiledsEntities).sorted((item1, item2) -> Integer.compare(item2.getLineSeq(), item1.getLineSeq())).collect(Collectors.toList());
                    for (ConfigFiledsEntity configFiledsEntity : filedsEntities) {
                        if (!configFiledsEntity.getFiledValue().equals(filedValue)) continue;
                        fieldSeq = configFiledsEntity.getLineSeq();
                        isDetailCodeExist = true;
                        break;
                    }
                }
            } else {
                isDetailCodeExist = true;
            }
            if (!isDetailCodeExist.booleanValue()) {
                map.put("detailCode", detailCode);
                map.put("entity", conf);
                map.put("workStatus", workStatus);
                map.put("lineListEntity", arrayLineList);
                map.put("arraySignList", arraySignList);
                map.put("settingPassword", ynPasswd.equals("Y") || ynPasswd.equals("") ? "block" : "none");
                map.put("ynSuperuser", ynSuperuser.equals("Y") ? "Y" : "N");
                map.put("fieldId", fieldid);
                result.setResultData(map);
                return result;
            }
            LineListEntity[] lineListEntity = null;
            lineListEntity = detailCode.equals("2") ? (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? AND  LINE_SEQ = ? ", new Object[]{vLineNum, fieldSeq})) : (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{vLineNum}));
            if (issueKey != null) {
                workFlowStEntity[] we = (workFlowStEntity[])this.activeObjects.find(workFlowStEntity.class, Query.select().where("ISSUE_KEY = ? AND ISSUE_STATUS_ID = ? AND YN_STATUS = ?", new Object[]{issueKey, statusid, "Y"}));
                if (we.length > 0) {
                    int linenum = 0;
                    for (workFlowStEntity workFlowStEntity2 : we) {
                        linenum = workFlowStEntity2.getLineNum();
                    }
                    signUserMngEntity[] isupdateEntity = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND LINE_NUM = ? ", new Object[]{issueKey, linenum}));
                    if (isupdateEntity.length > 0) {
                        int idx = 0;
                        for (signUserMngEntity update : isupdateEntity) {
                            update.setYnCompleted("N");
                            update.setStatus("N");
                            if (idx == 0) {
                                update.setButtonStatus("Y");
                            } else {
                                update.setButtonStatus("N");
                            }
                            update.setLastApprovalUser("");
                            update.setApprovalTime("");
                            update.save();
                            ++idx;
                        }
                        for (issueMngEntity issueEntity : issueMngEntitys) {
                            issueEntity.setInProgressState("N");
                            issueEntity.save();
                        }
                        for (workFlowStEntity wse : we) {
                            wse.setLineNum(linenum);
                            wse.setYnStatus("N");
                            wse.save();
                        }
                    }
                }
                signUserMngEntity[] signUserMngEntity2 = null;
                signUserMngEntity2 = detailCode.equals("2") ? (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND LINE_NUM = ? AND LINE_SEQ = ? ", new Object[]{issueKey, vLineNum, fieldSeq})) : (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND LINE_NUM = ? ", new Object[]{issueKey, vLineNum}));
                for (Iterator<Object> iterator : signUserMngEntity2) {
                    signUserMng sm = new signUserMng();
                    sm.setPkid(iterator.getID());
                    sm.setApprovalType(iterator.getApprovalType());
                    sm.setApprovalUser(iterator.getApprovalUser());
                    sm.setApprovalOrderNm(iterator.getApprovalOrderNm());
                    sm.setApprvoalUserkey(iterator.getApprvoalUserkey());
                    sm.setReplaceUser(this.getReplaceUser(iterator.getApprvoalUserkey(), "display"));
                    sm.setReplaceUserKey(this.getReplaceUser(iterator.getApprvoalUserkey(), "key"));
                    sm.setYnReplaceApprvoal(iterator.getYnReplaceApprvoal());
                    sm.setLastApprovalUser(iterator.getLastApprovalUser());
                    sm.setYnCompleted(iterator.getYnCompleted());
                    sm.setDatatime(iterator.getDatatime());
                    sm.setDcRmk(iterator.getDcRmk());
                    sm.setStatus(iterator.getStatus());
                    sm.setWorkflowStatusId(iterator.getWorkflowStatusId());
                    sm.setIssueid(iterator.getIssueid());
                    sm.setAvatarUrl(this.getAvatarUrl(appUser, iterator.getApprvoalUserkey()));
                    sm.setIssueKey(iterator.getIssueKey());
                    sm.setLineNum(iterator.getLineNum());
                    sm.setPrjid(iterator.getPrjid());
                    sm.setApprovalTime(iterator.getApprovalTime() == null ? "" : iterator.getApprovalTime());
                    sm.setButtonStatus(iterator.getButtonStatus());
                    arraySignList.add(sm);
                }
            } else {
                for (LineListEntity lineList : lineListEntity) {
                    signUserMng signUserMng2 = new signUserMng();
                    signUserMng2.setApprovalPosition(lineList.getApprovalPosition());
                    signUserMng2.setApprovalOrderNm(lineList.getApprovalOrderNm());
                    signUserMng2.setApprovalType(lineList.getApprovalType());
                    signUserMng2.setApprovalUser(lineList.getApprovalFix());
                    signUserMng2.setApprvoalUserkey(lineList.getApprvoalUserkey());
                    signUserMng2.setReplaceUser(this.getReplaceUser(lineList.getApprvoalUserkey(), "display"));
                    signUserMng2.setReplaceUserKey(this.getReplaceUser(lineList.getApprvoalUserkey(), "key"));
                    signUserMng2.setLineNum(lineList.getLineNum());
                    signUserMng2.setStatus("N");
                    signUserMng2.setDcRmk("");
                    signUserMng2.setYnCompleted("N");
                    signUserMng2.setLastApprovalUser("");
                    signUserMng2.setYnReplaceApprvoal("N");
                    signUserMng2.setButtonStatus("N");
                    signUserMng2.setAvatarUrl(this.getAvatarUrl(appUser, lineList.getApprvoalUserkey()));
                    signUserMng2.setWorkflowStatusId(0);
                    arraySignList.add(signUserMng2);
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
        Collections.sort(arraySignList, new Comparator<signUserMng>(){

            @Override
            public int compare(signUserMng b1, signUserMng b2) {
                return b1.getPkid() - b2.getPkid();
            }
        });
        map.put("detailCode", detailCode);
        map.put("entity", conf);
        map.put("workStatus", workStatus);
        map.put("lineListEntity", arrayLineList);
        map.put("arraySignList", arraySignList);
        map.put("settingPassword", ynPasswd.equals("Y") || ynPasswd.equals("") ? "block" : "none");
        map.put("ynSuperuser", ynSuperuser.equals("Y") ? "Y" : "N");
        map.put("fieldId", fieldid);
        result.setResultData(map);
        return result;
    }

    public String getAvatarUrl(ApplicationUser a1, String userKey) {
        ApplicationUser a2 = ComponentAccessor.getUserManager().getUserByKey(userKey);
        return this.avatarService.getAvatarURL(a1, a2, Avatar.Size.biggerThan((int)100)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String isLicenseValid() {
        String errorMessage = null;
        if (!this.licenseManager.getLicense().isDefined()) return "License is  Unlicensed.";
        PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
        if (!license.getError().isDefined()) return "valid license";
        switch ((LicenseError)license.getError().get()) {
            case EXPIRED: {
                return "license has expired.";
            }
            case TYPE_MISMATCH: {
                return "License type mismatch.";
            }
            case USER_MISMATCH: {
                return "License user mismatch.";
            }
            case VERSION_MISMATCH: {
                return "License version mismatch.";
            }
            case EDITION_MISMATCH: {
                return "License edition mismatch.";
            }
            case ROLE_EXCEEDED: {
                return "License role exceeded.";
            }
            case ROLE_UNDEFINED: {
                return "License role undefined.";
            }
            default: {
                return errorMessage;
            }
        }
    }

    private String getReplaceUser(String userkey, String ty) throws Exception {
        replaceUserEntity[] replaceUserEntities = (replaceUserEntity[])this.activeObjects.find(replaceUserEntity.class, Query.select().where("LOGIN_USERKEY = ? ", new Object[]{userkey}));
        String retValue = new String();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (replaceUserEntity entity : replaceUserEntities) {
            ApplicationUser appuser = ComponentAccessor.getUserManager().getUserByKey(entity.getReplaceUserkey());
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            String currentDate = sdf.format(cal.getTime());
            String stDate = entity.getStartDate();
            String edDate = entity.getEndDate();
            Long stTime = Long.valueOf(stDate);
            Long edTime = Long.valueOf(edDate);
            Long cuurentTime = Long.valueOf(currentDate);
            boolean bl = configServiceImpl.isWithinRange(cuurentTime, stTime, edTime);
            if (!bl) continue;
            retValue = ty.equals("key") ? appuser.getKey() : appuser.getDisplayName();
        }
        return retValue;
    }

    public static boolean isWithinRange(Long date, Long startDate, Long endDate) throws ParseException {
        return startDate <= date && date <= endDate;
    }

    public KappResult editSlectAllList(String num) throws KappExceptionHandler, Exception {
        applyListEntity[] applyListEntity2;
        KappResult result = new KappResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        configEntity entity = (configEntity)this.activeObjects.get(configEntity.class, (Object)Integer.parseInt(num));
        LineListEntity[] lineListEntity = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(num)}));
        config conf = new config();
        conf.setLineName(entity.getLineName());
        conf.setLineNum(entity.getLineNum());
        conf.setLineDesc(entity.getLineDesc());
        conf.setRegDateTime(entity.getRegDateTime());
        conf.setLineApprovaUser(entity.getLineApprovaUser());
        conf.setDetailCode(entity.getDetailCode());
        map.put("entity", conf);
        LinkedList<Integer> seq = new LinkedList<Integer>();
        ArrayList resSeq = new ArrayList();
        ArrayList approvalLineList = new ArrayList();
        for (LineListEntity p : lineListEntity) {
            seq.add(p.getLineSeq());
        }
        resSeq = (ArrayList)seq.stream().distinct().collect(Collectors.toList());
        for (Integer lineSeq : resSeq) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("seq", lineSeq);
            obj.put("lineList", this.orgService.getLineList(lineSeq));
            obj.put("orgList", this.orgService.getOrgInfo(lineSeq));
            obj.put("filedsList", this.orgService.getFiledsInfo(lineSeq));
            obj.put("detailCode", this.orgService.getDetailConde(this.orgService.getOrgInfo(lineSeq), this.orgService.getFiledsInfo(lineSeq)));
            approvalLineList.add(obj);
        }
        ArrayList<applyList> arrayApplyList = new ArrayList<applyList>();
        for (applyListEntity applyEntity : applyListEntity2 = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(num)}))) {
            applyList applyList2 = new applyList();
            applyList2.setConvertApproval(applyEntity.getConvertApproval());
            applyList2.setIsApply(applyEntity.getIsApply());
            applyList2.setYnApply(applyEntity.getIsApply() != false ? "Y" : "N");
            applyList2.setIssueType(applyEntity.getIssueType());
            applyList2.setLineNum(applyEntity.getLineNum());
            applyList2.setPrjName(applyEntity.getPrjName());
            applyList2.setReturnApproval(applyEntity.getReturnApproval());
            applyList2.setWorkFlowName(applyEntity.getWorkFlowName());
            applyList2.setWorkFlowStatus(applyEntity.getWorkFlowStatus());
            applyList2.setNum(applyEntity.getNum());
            applyList2.setRegDateTime(applyEntity.getRegDateTime());
            applyList2.setIssueTypeId(applyEntity.getIssueTypeId());
            applyList2.setPrjId(applyEntity.getPrjId());
            applyList2.setWorkFlowStatusid(applyEntity.getWorkFlowStatusid());
            ArrayList arryIssueTypes = new ArrayList();
            List prj = this.projectManager.getProjects();
            for (Project project : prj) {
                if (!project.getName().equals(applyEntity.getPrjName())) continue;
                Collection issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
                for (IssueType issueType : issueTypes) {
                    LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>();
                    maps.put("icon", issueType.getCompleteIconUrl());
                    maps.put("name", issueType.getName());
                    maps.put("id", issueType.getId());
                    arryIssueTypes.add(maps);
                }
            }
            applyList2.setissueTypes(arryIssueTypes);
            HashMap statusTypes = (HashMap)this.getjiraWorkFlows(applyEntity.getPrjId(), applyEntity.getIssueTypeId()).getResultData();
            applyList2.setstatusTypes((ArrayList)statusTypes.get("arraySteps"));
            arrayApplyList.add(applyList2);
        }
        KappResult ka = this.allProjectList();
        map.put("entity", conf);
        map.put("applyListEntity", arrayApplyList);
        map.put("approvalLineList", approvalLineList);
        map.put("prjList", ka.getResultData());
        result.setResultData(map);
        return result;
    }

    public KappResult saveLineNm(String num, String name) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        configEntity[] cf = (configEntity[])this.activeObjects.find(configEntity.class, Query.select().where("LINE_NAME = ? ", new Object[]{name}));
        if (cf.length > 0) {
            throw new IllegalArgumentException("exist");
        }
        configEntity update = (configEntity)this.activeObjects.get(configEntity.class, (Object)Integer.parseInt(num));
        update.setLineName(name);
        update.setRegDateTime(new Date(System.currentTimeMillis()));
        update.save();
        return result;
    }

    public KappResult saveLineDesc(String num, String desc) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        configEntity update = (configEntity)this.activeObjects.get(configEntity.class, (Object)Integer.parseInt(num));
        update.setLineDesc(desc);
        update.setRegDateTime(new Date(System.currentTimeMillis()));
        update.save();
        return result;
    }

    public KappResult editSlectList(String num) throws KappExceptionHandler, Exception {
        KappResult result = new KappResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<applyList> arrayApplyList = new ArrayList<applyList>();
        ArrayList<LineList> arrayLineList = new ArrayList<LineList>();
        ArrayList<ConfigDetail> detailArrayList = new ArrayList<ConfigDetail>();
        ArrayList<ConfigFileds> filedsArrayList = new ArrayList<ConfigFileds>();
        configEntity entity = (configEntity)this.activeObjects.get(configEntity.class, (Object)Integer.parseInt(num));
        LineListEntity[] lineListEntity = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(num)}));
        applyListEntity[] applyListEntity2 = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(num)}));
        ConfigDetailEntity[] configDetailEntities = (ConfigDetailEntity[])this.activeObjects.find(ConfigDetailEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(num)}));
        ConfigFiledsEntity[] configFiledsEntities = (ConfigFiledsEntity[])this.activeObjects.find(ConfigFiledsEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{Integer.parseInt(num)}));
        config conf = new config();
        conf.setLineName(entity.getLineName());
        conf.setLineNum(entity.getLineNum());
        conf.setLineDesc(entity.getLineDesc());
        conf.setRegDateTime(entity.getRegDateTime());
        conf.setLineApprovaUser(entity.getLineApprovaUser());
        conf.setDetailCode(entity.getDetailCode());
        for (LineListEntity lineList : lineListEntity) {
            LineList line = new LineList();
            line.setApprovalOrderNm(lineList.getApprovalOrderNm());
            line.setApprovalPosition(lineList.getApprovalPosition());
            line.setApprovalType(lineList.getApprovalType());
            line.setApprovalFix(lineList.getApprovalFix());
            line.setLineNum(lineList.getLineNum());
            line.setApprvoalUserkey(lineList.getApprvoalUserkey());
            arrayLineList.add(line);
        }
        for (applyListEntity applyEntity : applyListEntity2) {
            applyList applyList2 = new applyList();
            applyList2.setConvertApproval(applyEntity.getConvertApproval());
            applyList2.setIsApply(applyEntity.getIsApply());
            applyList2.setYnApply(applyEntity.getIsApply() != false ? "Y" : "N");
            applyList2.setIssueType(applyEntity.getIssueType());
            applyList2.setLineNum(applyEntity.getLineNum());
            applyList2.setPrjName(applyEntity.getPrjName());
            applyList2.setReturnApproval(applyEntity.getReturnApproval());
            applyList2.setWorkFlowName(applyEntity.getWorkFlowName());
            applyList2.setWorkFlowStatus(applyEntity.getWorkFlowStatus());
            applyList2.setNum(applyEntity.getNum());
            applyList2.setRegDateTime(applyEntity.getRegDateTime());
            applyList2.setIssueTypeId(applyEntity.getIssueTypeId());
            applyList2.setPrjId(applyEntity.getPrjId());
            applyList2.setWorkFlowStatusid(applyEntity.getWorkFlowStatusid());
            ArrayList arryIssueTypes = new ArrayList();
            List prj = this.projectManager.getProjects();
            for (Project project : prj) {
                if (!project.getName().equals(applyEntity.getPrjName())) continue;
                Collection issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
                for (IssueType issueType : issueTypes) {
                    LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>();
                    maps.put("icon", issueType.getCompleteIconUrl());
                    maps.put("name", issueType.getName());
                    maps.put("id", issueType.getId());
                    arryIssueTypes.add(maps);
                }
            }
            applyList2.setissueTypes(arryIssueTypes);
            HashMap statusTypes = (HashMap)this.getjiraWorkFlows(applyEntity.getPrjId(), applyEntity.getIssueTypeId()).getResultData();
            applyList2.setstatusTypes((ArrayList)statusTypes.get("arraySteps"));
            arrayApplyList.add(applyList2);
        }
        for (ConfigDetailEntity configDetailEntity : configDetailEntities) {
            ConfigDetail configDetail = new ConfigDetail();
            configDetail.setDetailCode(configDetailEntity.getDetailCode());
            configDetail.setLineName(configDetailEntity.getLineName());
            configDetail.setLineNum(configDetailEntity.getLineNum());
            configDetail.setOrgId(configDetailEntity.getOrgId());
            configDetail.setOrgName(configDetailEntity.getOrgName());
            detailArrayList.add(configDetail);
        }
        for (ConfigFiledsEntity configFiledsEntity : configFiledsEntities) {
            ConfigFileds configFileds = new ConfigFileds();
            configFileds.setDetailCode(configFiledsEntity.getDetailCode());
            configFileds.setLineName(configFiledsEntity.getLineName());
            configFileds.setLineNum(configFiledsEntity.getLineNum());
            configFileds.setFiledName(configFiledsEntity.getFiledName());
            configFileds.setFiledValue(configFiledsEntity.getFiledValue());
            filedsArrayList.add(configFileds);
        }
        KappResult ka = this.allProjectList();
        map.put("entity", conf);
        map.put("lineListEntity", arrayLineList);
        map.put("applyListEntity", arrayApplyList);
        map.put("detailArrayList", detailArrayList);
        map.put("filedsArrayList", filedsArrayList);
        map.put("prjList", ka.getResultData());
        result.setResultData(map);
        return result;
    }

    private KappResult removeKappLine(String num) throws Exception {
        KappResult res = new KappResult();
        configEntity entity = (configEntity)this.activeObjects.get(configEntity.class, (Object)Integer.parseInt(num));
        this.activeObjects.delete(new RawEntity[]{entity});
        this.activeObjects.flushAll();
        int cnt = this.activeObjects.deleteWithSQL(applyListEntity.class, "LINE_NUM = ? ", new Object[]{Integer.parseInt(num)});
        int configDetailEntityCnt = this.activeObjects.deleteWithSQL(ConfigDetailEntity.class, "LINE_NUM = ? ", new Object[]{Integer.parseInt(num)});
        int configFiledEntityCnt = this.activeObjects.deleteWithSQL(ConfigFiledsEntity.class, "LINE_NUM = ? ", new Object[]{Integer.parseInt(num)});
        log.info(String.valueOf(cnt));
        return res;
    }

    public KappResult selectApprovaList() {
        KappResult res = new KappResult();
        ArrayList<config> arrayList = new ArrayList<config>();
        for (configEntity configEntity2 : (configEntity[])this.activeObjects.find(configEntity.class)) {
            config config2 = new config();
            config2.setRegDateTime(configEntity2.getRegDateTime());
            config2.setLineDesc(configEntity2.getLineDesc());
            config2.setLineNum(configEntity2.getID());
            config2.setLineName(configEntity2.getLineName());
            config2.setLineOrder(configEntity2.getLineOrder());
            config2.setLineApplyInfo(this.concatDiv(configEntity2.getLineNum()));
            arrayList.add(config2);
        }
        res.setResultData(arrayList);
        return res;
    }

    private String concatDiv(int num) {
        applyListEntity[] ap = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{num}));
        StringBuilder bs = new StringBuilder();
        for (applyListEntity ae : ap) {
            if (!ae.getIsApply().booleanValue()) continue;
            bs.append(ae.getPrjName() + "(");
            bs.append(ae.getIssueType() + ",");
            bs.append(ae.getWorkFlowStatus() + "->");
            bs.append(ae.getConvertApproval() + ")");
            bs.append("<br>");
        }
        return bs.toString();
    }

    private KappResult saveApprovalApply(Object apply) throws Exception {
        KappResult ka = new KappResult();
        int lineNum = (Integer)((LinkedHashMap)apply).get("lineNum");
        configEntity conf = (configEntity)this.activeObjects.get(configEntity.class, (Object)lineNum);
        if (conf != null) {
            try {
                int cnt = this.activeObjects.deleteWithSQL(applyListEntity.class, "LINE_NUM = ? ", new Object[]{lineNum});
                log.info(String.valueOf(cnt));
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        ArrayList lineList = (ArrayList)((LinkedHashMap)apply).get("lineList");
        StringBuilder sb = new StringBuilder();
        for (HashMap applys : lineList) {
            String prjname = (String)applys.get("prjname");
            String issueType = (String)applys.get("issueType");
            String workflowstatus = (String)applys.get("workflowstatus");
            String convertapproval = (String)applys.get("convertapproval");
            Boolean isapply = (Boolean)applys.get("isapply");
            sb.append(prjname + "(");
            sb.append(issueType + ",");
            sb.append(workflowstatus + "->");
            sb.append(convertapproval + ")");
            sb.append("<br>");
        }
        configEntity configEntity2 = (configEntity)this.activeObjects.get(configEntity.class, (Object)lineNum);
        configEntity2.setLineApplyInfo(sb.toString());
        configEntity2.save();
        for (HashMap applyEntity : lineList) {
            String prjnm = (String)applyEntity.get("prjname");
            String issueType = (String)applyEntity.get("issueType");
            String workflownm = (String)applyEntity.get("workflownm");
            String workflowstatus = (String)applyEntity.get("workflowstatus");
            String workflowstatusid = (String)applyEntity.get("workflowstatusid");
            applyListEntity[] aEntity = null;
            applyListEntity[] islineNum = null;
            aEntity = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ? AND LINE_NUM = ?", new Object[]{prjnm, issueType, workflownm, lineNum}));
            islineNum = (applyListEntity[])this.activeObjects.find(applyListEntity.class, Query.select().where("PRJ_NAME = ? AND ISSUE_TYPE = ? AND WORK_FLOW_NAME = ? AND WORK_FLOW_STATUSID = ?", new Object[]{prjnm, issueType, workflownm, Integer.parseInt(workflowstatusid)}));
            if (aEntity.length != 0 || islineNum.length != 0) continue;
            String workflid = (String)applyEntity.get("workflowstatusid");
            applyListEntity ae = (applyListEntity)this.activeObjects.create(applyListEntity.class, new DBParam[0]);
            Boolean isApply = (Boolean)applyEntity.get("isapply");
            ae.setLineNum(lineNum);
            ae.setNum(ae.getID());
            ae.setIssueTypeId((String)applyEntity.get("issueTypeId"));
            ae.setPrjId((String)applyEntity.get("prjId"));
            ae.setConvertApproval((String)applyEntity.get("convertapproval"));
            ae.setIsApply(isApply);
            ae.setIssueType(issueType);
            ae.setPrjName(prjnm);
            ae.setRegDateTime(new Date(System.currentTimeMillis()));
            ae.setReturnApproval((String)applyEntity.get("returnapproval"));
            ae.setWorkFlowName((String)applyEntity.get("workflownm"));
            ae.setWorkFlowStatus((String)applyEntity.get("workflowstatus"));
            ae.setWorkFlowStatusid(Integer.parseInt(workflid));
            ae.save();
            if (!isApply.booleanValue()) continue;
            this.addConditionToWorkflw((String)applyEntity.get("workflownm"), (String)applyEntity.get("workflowstatus"), (String)applyEntity.get("convertapproval"), (String)applyEntity.get("returnapproval"));
        }
        return ka;
    }

    private RestrictionDescriptor getOrCreateRestriction(ActionDescriptor transition) {
        RestrictionDescriptor restriction = transition.getRestriction();
        if (restriction == null) {
            restriction = new RestrictionDescriptor();
            transition.setRestriction(restriction);
        }
        return restriction;
    }

    private KappResult bulkApprovalProcess(Object config2) throws Exception, KappExceptionHandler {
        KappResult ka = new KappResult();
        ArrayList bulkList = (ArrayList)((LinkedHashMap)config2).get("bulkList");
        String approvalType = (String)((LinkedHashMap)config2).get("approvalType");
        String dcrmk = (String)((LinkedHashMap)config2).get("dcrmk");
        String pw = (String)((LinkedHashMap)config2).get("pw");
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        int settingKey = 2;
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{settingKey}));
        String ynPasswd = "";
        if (settingEntities.length > 0) {
            List passwordUse = Arrays.stream(settingEntities).map(SettingEntity::getApprovalLineTy).collect(Collectors.toList());
            ynPasswd = (String)passwordUse.get(0);
        }
        LoginResult loginResult = null;
        if (!ynPasswd.equals("N")) {
            try {
                loginResult = this.loginInfo.authenticate(appUser, pw);
            }
            catch (Exception e) {
                log.warn("loginInfo.authenticate password fail" + e.getMessage());
            }
            if (!loginResult.getReason().toString().equals("OK")) {
                throw new IllegalArgumentException("passwordFail");
            }
        }
        try {
            bulkList.stream().forEach(item -> {
                signUserMngEntity[] signUserMngEntity2;
                String issuekey = (String)item.get("issuekey");
                String approvalUser = (String)item.get("approvalUser");
                String approvalUserkey = (String)item.get("approvalUserKey");
                String superuser = (String)item.get("superuser");
                String superuserkey = (String)item.get("superuserkey");
                for (signUserMngEntity e : signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("ISSUE_KEY = ? AND APPRVOAL_USERKEY = ?", new Object[]{issuekey, approvalUserkey}))) {
                    ((LinkedHashMap)config2).put("lineName", e.getLineName());
                    ((LinkedHashMap)config2).put("lineNum", String.valueOf(e.getLineNum()));
                    ((LinkedHashMap)config2).put("procType", approvalType);
                    ((LinkedHashMap)config2).put("prjid", e.getPrjid());
                    ((LinkedHashMap)config2).put("issueid", String.valueOf(e.getIssueid()));
                    ((LinkedHashMap)config2).put("issueTynm", "issueTynm");
                    ((LinkedHashMap)config2).put("approvalUser", e.getApprovalUser());
                    ((LinkedHashMap)config2).put("apprvoalUserkey", e.getApprvoalUserkey());
                    ((LinkedHashMap)config2).put("replaceUser", e.getReplaceUser());
                    ((LinkedHashMap)config2).put("replaceUserKey", e.getReplaceUserKey());
                    ((LinkedHashMap)config2).put("approvalType", e.getApprovalType());
                    ((LinkedHashMap)config2).put("approvalOrderNm", e.getApprovalOrderNm());
                    ((LinkedHashMap)config2).put("issueKey", e.getIssueKey());
                    ((LinkedHashMap)config2).put("superuser", superuser);
                    ((LinkedHashMap)config2).put("superuserkey", superuserkey);
                    try {
                        this.issueRegService.saveSignInfo(config2);
                    }
                    catch (KappExceptionHandler kappExceptionHandler) {
                        kappExceptionHandler.printStackTrace();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return ka;
    }

    private KappResult saveApproval(Object config2) throws Exception {
        KappResult ka = new KappResult();
        String lineName = (String)((LinkedHashMap)config2).get("lineName");
        String lineDesc = (String)((LinkedHashMap)config2).get("lineDesc");
        int lineNum = (Integer)((LinkedHashMap)config2).get("lineNum");
        String locale = (String)((LinkedHashMap)config2).get("locale");
        ArrayList lineList = (ArrayList)((LinkedHashMap)config2).get("lineList");
        String detailConf = (String)((LinkedHashMap)config2).get("detailConf");
        ArrayList orgList = (ArrayList)((LinkedHashMap)config2).get("orgList");
        String filed = (String)((LinkedHashMap)config2).get("filed");
        ArrayList filedValues = (ArrayList)((LinkedHashMap)config2).get("filedValues");
        int editLineSeq = (Integer)((LinkedHashMap)config2).get("editLineSeq");
        String tpyeEditState = (String)((LinkedHashMap)config2).get("tpyeEditState");
        configEntity confs = (configEntity)this.activeObjects.get(configEntity.class, (Object)lineNum);
        if (confs != null) {
            if (!tpyeEditState.equals("Y") && !this.saveValidate(detailConf, lineNum, orgList, filedValues, filed)) {
                throw new IllegalArgumentException("detail_exist");
            }
            if ("2".equals(detailConf)) {
                ConfigDetailEntity[] configDetailEntities;
                int defaultNum = 0;
                int orgNum = 1;
                for (ConfigDetailEntity listEntity : configDetailEntities = (ConfigDetailEntity[])this.activeObjects.find(ConfigDetailEntity.class, Query.select().where("LINE_NUM = ?  AND (DETAIL_CODE = ? OR  DETAIL_CODE = ?) ", new Object[]{lineNum, defaultNum, orgNum}))) {
                    this.activeObjects.deleteWithSQL(LineListEntity.class, "LINE_SEQ = ? ", new Object[]{listEntity.getLineSeq()});
                }
                this.activeObjects.deleteWithSQL(ConfigDetailEntity.class, "DETAIL_CODE = ? OR  DETAIL_CODE = ? ", new Object[]{defaultNum, orgNum});
                this.activeObjects.deleteWithSQL(ConfigFiledsEntity.class, "DETAIL_CODE = ? OR  DETAIL_CODE = ? ", new Object[]{defaultNum, orgNum});
                if ("Y".equals(tpyeEditState)) {
                    this.activeObjects.deleteWithSQL(ConfigFiledsEntity.class, "LINE_SEQ = ? ", new Object[]{editLineSeq});
                }
            } else {
                this.activeObjects.deleteWithSQL(LineListEntity.class, "LINE_NUM = ? ", new Object[]{lineNum});
                this.activeObjects.deleteWithSQL(ConfigDetailEntity.class, "LINE_NUM = ? ", new Object[]{lineNum});
                this.activeObjects.deleteWithSQL(ConfigFiledsEntity.class, "LINE_NUM = ? ", new Object[]{lineNum});
            }
        } else {
            configEntity[] cf = (configEntity[])this.activeObjects.find(configEntity.class, Query.select().where("LINE_NAME = ? ", new Object[]{lineName}));
            if (cf.length > 0) {
                throw new IllegalArgumentException("exist");
            }
        }
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        String userNm = appUser.getDisplayName();
        String lineOrder = new String();
        String lineApply = new String();
        StringBuilder sb = new StringBuilder();
        for (HashMap lineEntity : lineList) {
            String ordernm = (String)lineEntity.get("approvalOrderNm") + "-";
            sb.append(ordernm);
        }
        lineOrder = sb.toString();
        if (confs != null) {
            configEntity update = (configEntity)this.activeObjects.get(configEntity.class, (Object)lineNum);
            update.setRegDateTime(new Date(System.currentTimeMillis()));
            update.setLineOrder(lineOrder.substring(0, lineOrder.length() - 1));
            update.setDetailCode(detailConf);
            update.setLineApprovaUser(userNm);
            update.save();
        } else {
            configEntity insert = (configEntity)this.activeObjects.create(configEntity.class, new DBParam[0]);
            insert.setLineName(lineName);
            insert.setLineNum(insert.getID());
            insert.setLineDesc(lineDesc);
            insert.setRegDateTime(new Date(System.currentTimeMillis()));
            insert.setLineOrder(lineOrder.substring(0, lineOrder.length() - 1));
            insert.setLineApprovaUser(userNm);
            insert.setDetailCode(detailConf);
            lineNum = insert.getLineNum();
            insert.save();
        }
        int lineSeq = 0;
        if (detailConf.equals("1")) {
            int finalLineNum = lineNum;
            int finalLineSeq = lineSeq = this.getConfigLineSeq();
            try {
                orgList.stream().forEach(orgid -> {
                    ConfigDetailEntity confDetail = (ConfigDetailEntity)this.activeObjects.create(ConfigDetailEntity.class, new DBParam[0]);
                    confDetail.setDetailCode(detailConf);
                    confDetail.setLineName(lineName);
                    confDetail.setLineNum(finalLineNum);
                    confDetail.setOrgId((String)orgid);
                    confDetail.setLineSeq(finalLineSeq);
                    confDetail.setOrgName(this.findOrgName((String)orgid));
                    confDetail.save();
                });
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        } else if (detailConf.equals("2")) {
            int finalLineFiledNum = lineNum;
            int finalLineSeq1 = lineSeq = this.getConfigLineSeq();
            filedValues.stream().forEach(filedValue -> {
                ConfigFiledsEntity filedsEntity = (ConfigFiledsEntity)this.activeObjects.create(ConfigFiledsEntity.class, new DBParam[0]);
                filedsEntity.setDetailCode(detailConf);
                filedsEntity.setLineName(lineName);
                filedsEntity.setLineNum(finalLineFiledNum);
                filedsEntity.setFiledName(filed);
                filedsEntity.setLineSeq(finalLineSeq1);
                filedsEntity.setFiledValue((String)filedValue);
                filedsEntity.save();
            });
        } else {
            lineSeq = this.getConfigLineSeq();
            ConfigDetailEntity confDetail = (ConfigDetailEntity)this.activeObjects.create(ConfigDetailEntity.class, new DBParam[0]);
            confDetail.setDetailCode(detailConf);
            confDetail.setLineName(lineName);
            confDetail.setLineNum(lineNum);
            confDetail.setLineSeq(lineSeq);
            confDetail.save();
        }
        if (tpyeEditState.equals("Y")) {
            int confDetail = this.activeObjects.deleteWithSQL(LineListEntity.class, "LINE_SEQ = ? ", new Object[]{editLineSeq});
        }
        try {
            int rowNum = 1;
            for (HashMap lineListEntity : lineList) {
                LineListEntity entity = (LineListEntity)this.activeObjects.create(LineListEntity.class, new DBParam[0]);
                String appTy = (String)lineListEntity.get("approvalType");
                String approvalPosition = (String)lineListEntity.get("approvalPosition");
                String userName = (String)lineListEntity.get("approvalFix");
                String approvalConvertLang = "";
                approvalConvertLang = appTy.equals("0") ? (locale.equals("ko") ? "\ud569\uc758" : "Consent") : (appTy.equals("1") ? (locale.equals("ko") ? "\uacb0\uc7ac" : "Approval") : (locale.equals("ko") ? "\ucc38\uc870" : "Reference"));
                entity.setApprovalType(approvalConvertLang);
                entity.setApprovalOrderNm((String)lineListEntity.get("approvalOrderNm"));
                entity.setApprovalPosition(approvalPosition);
                entity.setApprvoalUserkey(approvalPosition.equals("2") ? this.findToUserkey(appUser.getKey(), userName) : (String)lineListEntity.get("apprvoalUserkey"));
                entity.setApprovalFix(entity.getApprvoalUserkey().equals("") ? "no user" : userName);
                entity.setNum(entity.getID());
                entity.setLineNum(lineNum);
                entity.setLineSeq(lineSeq);
                entity.setRowNum(rowNum);
                entity.setRegDateTime(new Date(System.currentTimeMillis()));
                entity.save();
                ++rowNum;
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        ArrayList<config> arrayConfigList = new ArrayList<config>();
        for (configEntity configEntity2 : (configEntity[])this.activeObjects.find(configEntity.class)) {
            config config1 = new config();
            config1.setRegDateTime(configEntity2.getRegDateTime());
            config1.setLineDesc(configEntity2.getLineDesc());
            config1.setLineNum(configEntity2.getID());
            config1.setLineName(configEntity2.getLineName());
            config1.setLineOrder(configEntity2.getLineOrder());
            config1.setLineApplyInfo(configEntity2.getLineApplyInfo());
            config1.setLineApprovaUser(configEntity2.getLineApprovaUser());
            config1.setDetailCode(detailConf);
            arrayConfigList.add(config1);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        configEntity entity = (configEntity)this.activeObjects.get(configEntity.class, (Object)lineNum);
        config conf = new config();
        conf.setLineName(entity.getLineName());
        conf.setLineNum(entity.getLineNum());
        conf.setLineDesc(entity.getLineDesc());
        conf.setRegDateTime(entity.getRegDateTime());
        conf.setLineApprovaUser(entity.getLineApprovaUser());
        conf.setDetailCode(entity.getDetailCode());
        map.put("entity", conf);
        map.put("arrayConfigList", arrayConfigList);
        ka.setResultData(map);
        return ka;
    }

    private boolean saveValidate(String detailCode, int lineNum, ArrayList<String> orgList, ArrayList<String> filedValues, String filed) {
        boolean isSave;
        block5: {
            ConfigFiledsEntity[] configFiledsEntities;
            block7: {
                ConfigDetailEntity[] configDetailEntity;
                block6: {
                    isSave = true;
                    configDetailEntity = (ConfigDetailEntity[])this.activeObjects.find(ConfigDetailEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{lineNum}));
                    if (!detailCode.equals("0")) break block6;
                    for (ConfigDetailEntity cd : configDetailEntity) {
                        if (!cd.getDetailCode().equals(detailCode)) continue;
                        isSave = false;
                        break block5;
                    }
                    break block5;
                }
                if (!detailCode.equals("1")) break block7;
                for (ConfigDetailEntity cde : configDetailEntity) {
                    if (!cde.getDetailCode().equals(detailCode)) continue;
                    isSave = false;
                    break block5;
                }
                break block5;
            }
            if (!detailCode.equals("2")) break block5;
            ArrayList<Integer> seqList = new ArrayList<Integer>();
            for (ConfigFiledsEntity cfe : configFiledsEntities = (ConfigFiledsEntity[])this.activeObjects.find(ConfigFiledsEntity.class, Query.select().where("LINE_NUM = ? ", new Object[]{lineNum}))) {
                seqList.add(cfe.getLineSeq());
            }
            ArrayList removeDistinctSeq = (ArrayList)seqList.stream().distinct().collect(Collectors.toList());
            for (Integer seq : removeDistinctSeq) {
                ArrayList<String> fieldsA = new ArrayList<String>();
                for (ConfigFiledsEntity filedsEntity : configFiledsEntities) {
                    if (filedsEntity.getLineSeq() != seq.intValue() || !filedsEntity.getFiledName().equals(filed)) continue;
                    fieldsA.add(filedsEntity.getFiledValue());
                }
                Collections.sort(fieldsA);
                Collections.sort(filedValues);
                if (!this.isContainsfiledVaues(fieldsA, filedValues)) continue;
                isSave = false;
                break;
            }
        }
        return isSave;
    }

    private boolean isContainsfiledVaues(ArrayList<String> a, ArrayList<String> b) {
        return a.containsAll(b);
    }

    public int getConfigLineSeq() throws Exception {
        int seq = 0;
        try {
            LineSeqEntity[] conf = (LineSeqEntity[])this.activeObjects.find(LineSeqEntity.class);
            if (conf.length > 0) {
                List seqList = Arrays.stream(conf).map(LineSeqEntity::getLineSeq).collect(Collectors.toList());
                seq = (Integer)seqList.get(0) + 1;
                for (LineSeqEntity lineSeqEntity : conf) {
                    lineSeqEntity.setLineSeq(seq);
                    lineSeqEntity.save();
                }
            } else {
                LineSeqEntity seqEntity = (LineSeqEntity)this.activeObjects.create(LineSeqEntity.class, new DBParam[0]);
                seqEntity.setLineSeq(seq + 1);
                seqEntity.save();
                ++seq;
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            log.error(e.getMessage());
            seq = 0;
        }
        return seq;
    }

    private String findOrgName(String orgid) {
        orgEntity[] orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class, Query.select().where("ORGID = ?", new Object[]{Integer.parseInt(orgid)}));
        List orgList = Arrays.stream(orgEntities).map(orgEntity::getname).collect(Collectors.toList());
        return orgList.size() > 0 ? (String)orgList.get(0) : "";
    }

    private String findToUserkey(String currentUserKey, String position) {
        ArrayList<String> matchValues = new ArrayList<String>();
        Boolean stop = false;
        List result = null;
        String userKey = "";
        try {
            String orgNm;
            orgUserEntity[] oe = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("USER_KEY = ? ", new Object[]{currentUserKey}));
            if (oe.length == 0) {
                return userKey;
            }
            List arrayOrg = Arrays.stream(oe).map(orgUserEntity::getOrgname).collect(Collectors.toList());
            String string = orgNm = arrayOrg.size() > 0 ? (String)arrayOrg.get(0) : "";
            while (!stop.booleanValue()) {
                List<orgEntity> orgResult = this.getOrgParentId(orgNm);
                if (orgResult.size() > 0) {
                    int parentId = orgResult.get(0).getparent();
                    if (parentId == 0) {
                        matchValues.add(orgResult.get(0).getname());
                        stop = true;
                        continue;
                    }
                    matchValues.add(orgResult.get(0).getname());
                    orgEntity[] orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class, Query.select().where("ORGID = ?", new Object[]{orgResult.get(0).getparent()}));
                    List orgList = Arrays.stream(orgEntities).map(orgEntity::getname).collect(Collectors.toList());
                    orgNm = orgList.size() > 0 ? (String)orgList.get(0) : "";
                    stop = false;
                    continue;
                }
                stop = true;
            }
            String placeholderCommaList = Joiner.on((String)", ").join(Iterables.transform(matchValues, (Function)Functions.constant((Object)"?")));
            Object[] matchValuesArray = Iterables.toArray(matchValues, Object.class);
            orgUserEntity[] orgUserEntities = (orgUserEntity[])this.activeObjects.find(orgUserEntity.class, Query.select().where("ORGNAME IN (" + placeholderCommaList + ")", matchValuesArray));
            result = Arrays.stream(orgUserEntities).filter(str -> str.getPosition().equals(position) && str.getOrgYn().equals("Y")).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return userKey;
        }
        return result.size() > 0 ? ((orgUserEntity)result.get(0)).getUserKey() : userKey;
    }

    private List<orgEntity> getOrgParentId(String orgName) {
        List<orgEntity> result = new ArrayList<orgEntity>();
        try {
            orgEntity[] orgEntities = (orgEntity[])this.activeObjects.find(orgEntity.class);
            result = Arrays.stream(orgEntities).filter(str -> str.getname().equals(orgName)).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    private String getKeyToUserName(String userkey) throws Exception {
        ApplicationUser users = ComponentAccessor.getUserManager().getUserByKey(userkey);
        return users == null ? "" : users.getDisplayName();
    }

    public configEntity[] getConfig() throws Exception {
        configEntity[] reports = (configEntity[])this.activeObjects.find(configEntity.class, Query.select());
        configEntity[] entity = (configEntity[])this.activeObjects.get(configEntity.class, (Object[])new Integer[0]);
        LineListEntity[] lineListEntity = (LineListEntity[])this.activeObjects.get(LineListEntity.class, (Object[])new Integer[0]);
        LineListEntity[] LineListEntity2 = (LineListEntity[])this.activeObjects.find(LineListEntity.class, Query.select());
        if (entity == null) {
            // empty if block
        }
        configEntity entity2 = (configEntity)this.activeObjects.create(configEntity.class, new DBParam[]{new DBParam("ID", (Object)1)});
        entity2.setLineName("\ud734\uac00\uc6d02");
        entity2.setLineNum(2);
        entity2.setRegDateTime(new Date(System.currentTimeMillis()));
        entity2.save();
        LineListEntity entityLine = (LineListEntity)this.activeObjects.create(LineListEntity.class, new DBParam[]{new DBParam("ID", (Object)1)});
        entityLine.setNum(1);
        entityLine.setLineNum(1);
        entityLine.setApprovalPosition("CEO");
        entityLine.setApprovalType("0");
        entityLine.setRegDateTime(new Date(System.currentTimeMillis()));
        entityLine.save();
        return entity;
    }

    private configEntity initConfig() {
        configEntity entity;
        LocalDateTime currentDateTime = LocalDateTime.now();
        try {
            entity = (configEntity)this.activeObjects.get(configEntity.class, (Object)1);
            this.activeObjects.delete(new RawEntity[]{entity});
            this.activeObjects.flushAll();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        entity = (configEntity)this.activeObjects.create(configEntity.class, new DBParam[]{new DBParam("ID", (Object)1)});
        entity.setLineName("\uc791\uc5c5");
        entity.setLineNum(1);
        entity.setRegDateTime(new Date(System.currentTimeMillis()));
        entity.save();
        return entity;
    }

    public config setConfigEntityDispacher(configEntity[] configEntity2) throws Exception {
        config conf = new config();
        return conf;
    }

    private void addConditionToWorkflw(String workflowName, String StepName, String okActionName, String returnActionName) throws Exception {
        Collection workflows = this.workflowManager.getWorkflows();
        for (JiraWorkflow jiraWorkflow : workflows) {
            if (!jiraWorkflow.getName().equals(workflowName)) continue;
            List stepDescriptors = jiraWorkflow.getDescriptor().getSteps();
            for (StepDescriptor sd : stepDescriptors) {
                if (!sd.getName().equals(StepName)) continue;
                ArrayList ac = (ArrayList)sd.getActions();
                for (ActionDescriptor action : ac) {
                    if (!action.getName().equals(okActionName) && !action.getName().equals(returnActionName)) continue;
                    RestrictionDescriptor restriction = this.getOrCreateRestriction(action);
                    ConditionsDescriptor conditionsDescriptor = restriction.getConditionsDescriptor();
                    boolean AlreadyCondition = false;
                    if (conditionsDescriptor != null) {
                        List conditions = conditionsDescriptor.getConditions();
                        boolean i = false;
                        for (Object descriptor : conditions) {
                            ConditionDescriptor cd;
                            Map args;
                            String conditionName;
                            if (!(descriptor instanceof ConditionDescriptor) || !(conditionName = (String)(args = (cd = (ConditionDescriptor)descriptor).getArgs()).get("class.name")).contains("kr.osci.apps.kapproval.workflow.condition.ApprovalLineCondition")) continue;
                            AlreadyCondition = true;
                            break;
                        }
                    }
                    if (AlreadyCondition) continue;
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("class.name", "kr.osci.apps.kapproval.workflow.condition.ApprovalLineCondition");
                    ConditionDescriptor condition = DescriptorFactory.getFactory().createConditionDescriptor();
                    condition.setType("class");
                    Map conditionArgs = condition.getArgs();
                    conditionArgs.putAll(params);
                    conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
                    restriction.setConditionsDescriptor(conditionsDescriptor);
                    conditionsDescriptor.getConditions().add(condition);
                    this.workflowTransitionService.addConditionToWorkflow(action.getName(), condition, jiraWorkflow);
                }
            }
        }
    }

    private void deleteConditionToWorkflw(String workflowName, String StepName, String okActionName, String returnActionName) throws Exception {
        Collection workflows = this.workflowManager.getWorkflows();
        for (JiraWorkflow jiraWorkflow : workflows) {
            if (!jiraWorkflow.getName().equals(workflowName)) continue;
            List stepDescriptors = jiraWorkflow.getDescriptor().getSteps();
            for (StepDescriptor sd : stepDescriptors) {
                if (!sd.getName().equals(StepName)) continue;
                ArrayList ac = (ArrayList)sd.getActions();
                for (ActionDescriptor action : ac) {
                    RestrictionDescriptor restriction;
                    ConditionsDescriptor conditionsDescriptor;
                    if (!action.getName().equals(okActionName) && !action.getName().equals(returnActionName) || (conditionsDescriptor = (restriction = this.getOrCreateRestriction(action)).getConditionsDescriptor()) == null) continue;
                    List conditions = conditionsDescriptor.getConditions();
                    int removeidx = 0;
                    for (Object descriptor : conditions) {
                        ConditionDescriptor cd;
                        Map args;
                        String conditionName;
                        if (descriptor instanceof ConditionDescriptor && (conditionName = (String)(args = (cd = (ConditionDescriptor)descriptor).getArgs()).get("class.name")).contains("kr.osci.apps.kapproval.workflow.condition.ApprovalLineCondition")) {
                            conditionsDescriptor.getConditions().remove(removeidx);
                        }
                        ++removeidx;
                    }
                }
            }
        }
    }
}

