/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.SettingEntity;
import kr.osci.apps.kapproval.entity.SettingMng;
import kr.osci.apps.kapproval.service.SettingService;
import net.java.ao.DBParam;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Named
@Preload
public class SettingServiceImpl
implements SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    private static final String SETTING_NAME = "APPROVAL_LINE";
    private static final int SETTING_APPROVAL_KEY = 1;
    private static final String SETTING_PASSWORD_NAME = "APPROVAL_PASSWORD";
    private static final int SETTING_APPROVAL_PASSWORD_KEY = 2;
    private static final String SETTING_SUPERUSERS_NAME = "APPROVAL_SUPERUSERS";
    private static final int SETTING_APPROVAL_SUPERUSERS_KEY = 3;
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public SettingServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public KappResult saveLineSetting(String lineTy) throws KappExceptionHandler, Exception {
        return this.saveLineTy(lineTy);
    }

    @Override
    public KappResult savePasswordSetting(String passwordTy) throws KappExceptionHandler, Exception {
        return this.savePasswordTy(passwordTy);
    }

    @Override
    public KappResult selectSettingValue() throws KappExceptionHandler, Exception {
        return this.getSettingLineInfo();
    }

    @Override
    public KappResult saveSuperUsers(Object obj) throws KappExceptionHandler, Exception {
        return this.setSuperusers(obj);
    }

    @Override
    public KappResult deleteSuperuser(String id) throws KappExceptionHandler, Exception {
        return this.removeSuperuser(id);
    }

    @Override
    public KappResult selectAllSuperUser() throws KappExceptionHandler, Exception {
        SettingEntity[] settingEntities;
        KappResult ka = new KappResult();
        ArrayList<SettingMng> arryListSetting = new ArrayList<SettingMng>();
        for (SettingEntity entity : settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{3}))) {
            SettingMng settingSuperuserdMng = new SettingMng();
            settingSuperuserdMng.setApprovalLineTy(entity.getApprovalLineTy());
            settingSuperuserdMng.setUsername(entity.getUsername());
            settingSuperuserdMng.setSettingKey(entity.getSettingKey());
            settingSuperuserdMng.setPassword(entity.getPassword());
            settingSuperuserdMng.setSettingName(entity.getSettingName());
            settingSuperuserdMng.setSuperuserLineNum(entity.getID());
            arryListSetting.add(settingSuperuserdMng);
        }
        ka.setResultData(arryListSetting);
        return ka;
    }

    private KappResult removeSuperuser(String id) throws Exception {
        KappResult ka = new KappResult();
        int cnt = this.activeObjects.deleteWithSQL(SettingEntity.class, "ID = ? ", new Object[]{Integer.parseInt(id)});
        ka.setResultData(cnt);
        return ka;
    }

    private KappResult setSuperusers(Object obj) {
        KappResult ka = new KappResult();
        ArrayList lineList = (ArrayList)((LinkedHashMap)obj).get("lineList");
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{3}));
        if (settingEntities.length > 0) {
            for (SettingEntity ae : settingEntities) {
                this.activeObjects.delete(new RawEntity[]{ae});
                this.activeObjects.flushAll();
            }
        }
        for (HashMap objcts : lineList) {
            String usernm = (String)objcts.get("usernm");
            String userkey = (String)objcts.get("userkey");
            String email = (String)objcts.get("email");
            SettingEntity settingEntity = (SettingEntity)this.activeObjects.create(SettingEntity.class, new DBParam[0]);
            settingEntity.setSuperuserLineNum(settingEntity.getID());
            settingEntity.setSettingKey(3);
            settingEntity.setUsername(usernm);
            settingEntity.setSettingName(SETTING_SUPERUSERS_NAME);
            settingEntity.setApprovalLineTy(userkey);
            settingEntity.setPassword(email);
            settingEntity.save();
        }
        ka.setResultData("SUCESS");
        return ka;
    }

    private KappResult saveLineTy(String option) throws Exception {
        KappResult res = new KappResult();
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{1}));
        if (settingEntities.length > 0) {
            this.activeObjects.deleteWithSQL(SettingEntity.class, "SETTING_KEY = ? ", new Object[]{1});
        }
        SettingEntity insert = (SettingEntity)this.activeObjects.create(SettingEntity.class, new DBParam[0]);
        insert.setRegLineDate(new Date(System.currentTimeMillis()));
        insert.setApprovalLineTy(option);
        insert.setSettingKey(1);
        insert.setSettingName(SETTING_NAME);
        insert.save();
        return res;
    }

    private KappResult savePasswordTy(String option) throws Exception {
        KappResult res = new KappResult();
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{2}));
        if (settingEntities.length > 0) {
            this.activeObjects.deleteWithSQL(SettingEntity.class, "SETTING_KEY = ? ", new Object[]{2});
        }
        SettingEntity insert = (SettingEntity)this.activeObjects.create(SettingEntity.class, new DBParam[0]);
        insert.setRegLineDate(new Date(System.currentTimeMillis()));
        insert.setApprovalLineTy(option);
        insert.setSettingKey(2);
        insert.setSettingName(SETTING_PASSWORD_NAME);
        insert.save();
        return res;
    }

    public KappResult getSettingLineInfo() throws Exception {
        KappResult res = new KappResult();
        ArrayList<SettingMng> arryListSetting = new ArrayList<SettingMng>();
        SettingEntity[] settingApprovalEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{1}));
        SettingEntity[] settingPasswordEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{2}));
        SettingEntity[] settingSupseruserEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{3}));
        for (SettingEntity entity : settingApprovalEntities) {
            SettingMng settingLineMng = new SettingMng();
            settingLineMng.setApprovalLineTy(entity.getApprovalLineTy());
            settingLineMng.setRegLineDate(entity.getRegLineDate());
            settingLineMng.setSettingKey(entity.getSettingKey());
            settingLineMng.setSettingName(entity.getSettingName());
            arryListSetting.add(settingLineMng);
        }
        for (SettingEntity entity : settingPasswordEntities) {
            SettingMng settingPasswordMng = new SettingMng();
            settingPasswordMng.setApprovalLineTy(entity.getApprovalLineTy());
            settingPasswordMng.setRegLineDate(entity.getRegLineDate());
            settingPasswordMng.setSettingKey(entity.getSettingKey());
            settingPasswordMng.setSettingName(entity.getSettingName());
            arryListSetting.add(settingPasswordMng);
        }
        for (SettingEntity entity : settingSupseruserEntities) {
            SettingMng settingSuperuserdMng = new SettingMng();
            settingSuperuserdMng.setApprovalLineTy(entity.getApprovalLineTy());
            settingSuperuserdMng.setUsername(entity.getUsername());
            settingSuperuserdMng.setSettingKey(entity.getSettingKey());
            settingSuperuserdMng.setPassword(entity.getPassword());
            settingSuperuserdMng.setSettingName(entity.getSettingName());
            settingSuperuserdMng.setSuperuserLineNum(entity.getID());
            arryListSetting.add(settingSuperuserdMng);
        }
        res.setResultData(arryListSetting);
        return res;
    }
}

