/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.panel;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import kr.osci.apps.kapproval.entity.issuehisEntity;
import kr.osci.apps.kapproval.service.impl.issueRegServiceImpl;
import kr.osci.apps.kapproval.utills.IssueDescript;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueTabKapproval
extends AbstractIssueTabPanel3 {
    private static final Logger log = LoggerFactory.getLogger(issueRegServiceImpl.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final LocaleManager localeManager;

    @Inject
    public IssueTabKapproval(ActiveObjects activeObjects, LocaleManager localeManager) {
        this.activeObjects = activeObjects;
        this.localeManager = localeManager;
    }

    public boolean showPanel(ShowPanelRequest showPanelRequest) {
        return true;
    }

    public List<IssueAction> getActions(GetActionsRequest getActionsRequest) {
        List<Object> arraySignList = new ArrayList();
        ArrayList MessageList = Lists.newArrayList();
        issuehisEntity[] his = (issuehisEntity[])this.activeObjects.find(issuehisEntity.class, Query.select().where("ISSUE_KEY = ?", new Object[]{getActionsRequest.issue().getKey()}));
        arraySignList = Arrays.stream(his).collect(Collectors.toList());
        Collections.sort(arraySignList, new SortByDate());
        for (issuehisEntity issuehisEntity2 : arraySignList) {
            MessageList.add(new GenericMessageAction(this.StateMessage(issuehisEntity2)));
        }
        return Lists.newArrayList((Iterable)MessageList);
    }

    private String StateMessage(issuehisEntity entity) {
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Locale locale = this.localeManager.getLocaleFor(appUser);
        String language = locale.getLanguage();
        IssueDescript desc = new IssueDescript();
        try {
            if (entity.getSateCode().equals("0")) {
                return desc.CreateIssue(language, appUser, sdf.format(entity.getRegDateTime()));
            }
            if (entity.getSateCode().equals("1")) {
                return desc.sign(language, entity.getWorkUser(), sdf.format(entity.getRegDateTime()));
            }
            if (entity.getSateCode().equals("2")) {
                return desc.reject(language, entity.getWorkUser(), sdf.format(entity.getRegDateTime()));
            }
            return desc.signCompleted(language, entity.getWorkUser(), sdf.format(entity.getRegDateTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("StateMessage =====>" + e.getMessage());
            return "";
        }
    }

    private class SortByDate
    implements Comparator<issuehisEntity> {
        private SortByDate() {
        }

        @Override
        public int compare(issuehisEntity a, issuehisEntity b) {
            return a.getRegDateTime().compareTo(b.getRegDateTime());
        }
    }
}

