/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.jsm;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kr.osci.apps.kapproval.entity.signUserMngEntity;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@PublicSpi
public class ReqKapprovalProvider
implements ContextProvider {
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    protected final LocaleManager localeManager;
    @ComponentImport
    protected final IssueTypeManager issueTypeManager;
    @ComponentImport
    private final ProjectManager projectManager;
    @ComponentImport
    private final AvatarService avatarService;
    @ComponentImport
    private final PortalPageManager portalPageManager;
    private static final Logger log = LoggerFactory.getLogger(ReqKapprovalProvider.class);

    public ReqKapprovalProvider(ApplicationProperties applicationProperties, ActiveObjects activeObjects, ProjectManager projectManager, PortalPageManager portalPageManager, IssueManager issueManager, LocaleManager localeManager, IssueTypeManager issueTypeManager, AvatarService avatarService) {
        this.applicationProperties = applicationProperties;
        this.activeObjects = activeObjects;
        this.issueManager = issueManager;
        this.localeManager = localeManager;
        this.issueTypeManager = issueTypeManager;
        this.projectManager = projectManager;
        this.avatarService = avatarService;
        this.portalPageManager = portalPageManager;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map getContextMap(Map<String, Object> context) {
        ArrayList issueList = new ArrayList();
        Object obj = context.get("user");
        String userkey = ((ApplicationUser)obj).getKey();
        ApplicationUser applicationUser = ComponentAccessor.getUserManager().getUserByKey(userkey);
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        try {
            signUserMngEntity[] signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where("APPRVOAL_USERKEY = ? ", new Object[]{userkey}));
            List<signUserMngEntity> entityList = Arrays.stream(signUserMngEntity2).collect(Collectors.toList());
            entityList = ReqKapprovalProvider.distinctArray(entityList, "ISSUE_KEY");
            entityList.stream().forEach(item -> {
                signUserMngEntity approvals = (signUserMngEntity)item;
                if (approvals.getPortalId() != null && approvals.getPrjType() != null && this.getIssue(approvals.getIssueKey()) != null && !approvals.getPortalId().equals("") && approvals.getPrjType().equals("jiraSerivceDesk")) {
                    HashMap<String, String> issueMap = new HashMap<String, String>();
                    Issue issue = this.getIssue(approvals.getIssueKey());
                    IssueType issueType = issue.getIssueType();
                    issueMap.put("IssueKey", issue.getKey());
                    issueMap.put("description", issue.getDescription());
                    issueMap.put("summary", issue.getSummary());
                    issueMap.put("creator", issue.getCreator().getDisplayName());
                    issueMap.put("statusName", issue.getStatus().getName());
                    issueMap.put("reporter", issue.getReporter().getDisplayName());
                    issueMap.put("serviceName", issue.getProjectObject().getName());
                    issueMap.put("contextPath", baseUrl);
                    issueMap.put("iconUrl", issueType.getIconUrl());
                    issueMap.put("potalID", approvals.getPortalId());
                    issueList.add(issueMap);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return EasyMap.build((Object[])new Object[]{"issueList", issueList, "userKey", userkey, "all", this.getLanguage().equals("ko") ? "\uc804\uccb4" : "ALL", "wait", this.getLanguage().equals("ko") ? "\uacb0\uc7ac\ub300\uae30" : "PendingApproval", "approved", this.getLanguage().equals("ko") ? "\uc2b9\uc778\uc644\ub8cc" : "ApprovedApproval", "reject", this.getLanguage().equals("ko") ? "\ubc18\ub824\uc644\ub8cc" : "RejectedApproval", "type", this.getLanguage().equals("ko") ? "\uc720\ud615" : "type", "reference", this.getLanguage().equals("ko") ? "\ucc38\uc870" : "reference", "summary", this.getLanguage().equals("ko") ? "\uc694\uc57d" : "summary", "portal", this.getLanguage().equals("ko") ? "Service Desk" : "Service Desk", "status", this.getLanguage().equals("ko") ? "\uc0c1\ud0dc" : "status", "requester", this.getLanguage().equals("ko") ? "\uc694\uccad\uc790" : "requester"});
    }

    private Issue getIssue(String issuekey) {
        try {
            MutableIssue issue = this.issueManager.getIssueObject(issuekey);
            return issue;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            return null;
        }
    }

    public String getLanguage() {
        ApplicationUser appUser = ComponentAccessor.getUserManager().getUserByName(ComponentAccessor.getJiraAuthenticationContext().getUser().getKey());
        Locale locale = this.localeManager.getLocaleFor(appUser);
        return locale.getLanguage();
    }

    private static List<signUserMngEntity> distinctArray(List<signUserMngEntity> target, Object key) {
        if (target != null) {
            target = target.stream().filter(ReqKapprovalProvider.distinctByKey(o -> o.getIssueKey())).collect(Collectors.toList());
        }
        return target;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

