/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.jsm;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.SettingEntity;
import kr.osci.apps.kapproval.entity.issuehisEntity;
import kr.osci.apps.kapproval.entity.signUserMng;
import kr.osci.apps.kapproval.service.impl.configServiceImpl;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@PublicSpi
public class JsmKapprovalProvider
implements ContextProvider {
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    protected final LocaleManager localeManager;
    @ComponentImport
    protected final IssueTypeManager issueTypeManager;
    @ComponentImport
    private final ProjectManager projectManager;
    @Autowired
    private configServiceImpl configService;
    private static final Logger log = LoggerFactory.getLogger(JsmKapprovalProvider.class);

    public JsmKapprovalProvider(ApplicationProperties applicationProperties, ActiveObjects activeObjects, ProjectManager projectManager, IssueManager issueManager, LocaleManager localeManager, IssueTypeManager issueTypeManager) {
        this.applicationProperties = applicationProperties;
        this.activeObjects = activeObjects;
        this.issueManager = issueManager;
        this.localeManager = localeManager;
        this.issueTypeManager = issueTypeManager;
        this.projectManager = projectManager;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = (ApplicationUser)context.get("user");
        int serviceDeskID = (Integer)context.get("serviceDeskId");
        Gson gson = new Gson();
        JsonObject requestTypeJson = gson.toJsonTree(context.get("requestType")).getAsJsonObject();
        JsonElement issueTypeId = requestTypeJson.get("issueTypeId");
        JsonObject serviceDesk = gson.toJsonTree(context.get("serviceDesk")).getAsJsonObject();
        JsonElement projectId = serviceDesk.get("projectId");
        JsonObject portal = gson.toJsonTree(context.get("portal")).getAsJsonObject();
        JsonElement potalId = portal.get("id");
        String potalIdAsString = potalId.getAsString();
        this.portalCheckAndSet(potalIdAsString);
        long prjID = projectId.getAsLong();
        long issueTypid = issueTypeId.getAsLong();
        ApplicationUser currentUser = ComponentAccessor.getUserManager().getUserByName(ComponentAccessor.getJiraAuthenticationContext().getUser().getKey());
        Locale locale = this.localeManager.getLocaleFor(currentUser);
        String language = locale.getLanguage();
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        String loginUsernm = appUser.getDisplayName();
        String loginUserkey = appUser.getKey();
        int settingKey = 2;
        String ynPasswd = "";
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{settingKey}));
        if (settingEntities.length > 0) {
            List passwordUse = Arrays.stream(settingEntities).map(SettingEntity::getApprovalLineTy).collect(Collectors.toList());
            ynPasswd = (String)passwordUse.get(0);
        }
        int settingSuperUserKey = 3;
        String ynSuperuser = "";
        SettingEntity[] settingSuperuser = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().where("SETTING_KEY = ? ", new Object[]{settingSuperUserKey}));
        if (settingSuperuser.length > 0) {
            for (SettingEntity superuser : settingSuperuser) {
                ynSuperuser = appUser.getKey().equals(superuser.getApprovalLineTy()) ? "Y" : "N";
            }
        }
        HashMap map = (HashMap)this.getApprovalConfig(issue, prjID, issueTypid).getResultData();
        ArrayList lineListEntity = new ArrayList();
        ArrayList lineListSupport = new ArrayList();
        ArrayList list = (ArrayList)map.get("lineListEntity");
        String workStatus = (String)map.get("workStatus");
        ArrayList<signUserMng> signUserMngEntity2 = new ArrayList<signUserMng>();
        ArrayList<signUserMng> signUserSupport = new ArrayList<signUserMng>();
        ArrayList listsign = (ArrayList)map.get("arraySignList");
        for (signUserMng line : listsign) {
            if (line.getApprovalType().equals("\ucc38\uc870") || line.getApprovalType().equals("Reference")) {
                signUserSupport.add(line);
                continue;
            }
            signUserMngEntity2.add(line);
        }
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        String translationNm = issue != null ? issue.getStatus().getNameTranslation() : "";
        String statusName = issue != null ? issue.getStatus().getName() : "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        IssueType it = this.issueTypeManager.getIssueType(String.valueOf(issueTypid));
        int approvalTdWith = 200;
        return EasyMap.build((Object[])new Object[]{"checkLicensed", "valid license", "createdateime", issue != null ? format.format(issue.getCreated()) : "", "creator", issue != null ? issue.getCreator() : "", "issueTypeId", issue != null ? issue.getIssueTypeId() : "", "ProjectId", issue != null ? issue.getProjectId() : "", "issueKey", issue != null ? issue.getKey() : "", "statusid", issue != null ? issue.getStatusId() : "", "issueTypeName", it.getName(), "lineListEntity", lineListEntity, "lineListSupport", signUserSupport, "arraySignList", signUserMngEntity2, "writer", (String)map.get("writer"), "loginUsernm", loginUsernm, "loginUserkey", loginUserkey, "entity", map.get("entity"), "baseUrl", baseUrl, "language", language, "potalId", potalIdAsString, "translationNm", translationNm, "workStatus", workStatus, "statusName", statusName, "passwordDisplay", ynPasswd.equals("Y") || ynPasswd.equals("") ? "block" : "none", "ynSuperuser", ynSuperuser.equals("Y") ? "Y" : "N", "editDatetime", format.format(new Date(System.currentTimeMillis())), "imageKeyPath", "kr.osci.apps.kapproval_jira", "isVisbile", listsign.size() > 0 ? "visible" : "none", "detailCode", (String)map.get("detailCode"), "approvalWith", signUserMngEntity2.size() * approvalTdWith, "randomKey", issue == null ? this.givenUsingPlainJava_whenGeneratingRandomStringBounded_thenCorrect() : ""});
    }

    public KappResult getApprovalConfig(Issue issue, long prjID, long issueTypid) {
        KappResult ka = new KappResult();
        if (issue == null) {
            IssueType issueTypeName = this.issueTypeManager.getIssueType(String.valueOf(issueTypid));
            String prjNm = this.projectManager.getProjectObj(Long.valueOf(prjID)).getName();
            ka = this.configService.getApprovalInfo(issue, issueTypeName.getName(), null, prjNm, String.valueOf(issueTypid), prjID, "", "");
        } else {
            IssueType it = issue.getIssueType();
            ka = this.configService.getApprovalInfo(issue, it.getName(), issue.getKey(), issue.getProjectObject().getName(), issue.getIssueTypeId(), issue.getProjectId(), issue.getStatus() == null ? "" : issue.getStatus().getNameTranslation(), issue.getStatus() == null ? "" : issue.getStatus().getId());
        }
        return ka;
    }

    public String givenUsingPlainJava_whenGeneratingRandomStringBounded_thenCorrect() {
        int leftLimit = 97;
        int rightLimit = 122;
        int targetStringLength = 10;
        Random random = new Random();
        StringBuilder buffer = new StringBuilder(targetStringLength);
        for (int i = 0; i < targetStringLength; ++i) {
            int randomLimitedInt = leftLimit + (int)(random.nextFloat() * (float)(rightLimit - leftLimit + 1));
            buffer.append((char)randomLimitedInt);
        }
        return buffer.toString();
    }

    private void portalCheckAndSet(String potalid) {
        try {
            issuehisEntity[] issuehisEntities = (issuehisEntity[])this.activeObjects.find(issuehisEntity.class, Query.select().where("PORTAL_TYPE = ?", new Object[]{"JSM"}));
            if (issuehisEntities.length > 0) {
                this.activeObjects.deleteWithSQL(issuehisEntity.class, "PORTAL_TYPE = ? ", new Object[]{"JSM"});
                issuehisEntity entity = (issuehisEntity)this.activeObjects.create(issuehisEntity.class, new DBParam[0]);
                entity.setPortalType("JSM");
                entity.setPotalID(potalid);
                entity.save();
            } else {
                issuehisEntity entity = (issuehisEntity)this.activeObjects.create(issuehisEntity.class, new DBParam[0]);
                entity.setPortalType("JSM");
                entity.setPotalID(potalid);
                entity.save();
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            e.printStackTrace();
        }
    }
}

