/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.jobs;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.orgServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class LdapSyncScheduler
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(LdapSyncScheduler.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    @Autowired
    private orgServiceImpl orgService;
    @ComponentImport
    private final TransactionTemplate template;

    @Inject
    public LdapSyncScheduler(SchedulerService schedulerService, TransactionTemplate template) {
        this.schedulerService = schedulerService;
        this.template = template;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        String result = (String)this.template.execute(() -> {
            String tmp = "SUCCESS";
            try {
                KappResult res = this.orgService.LDapSyncSchedulerStart();
                if (res.getResultCode() != 200) {
                    log.error(res.getResultMsg());
                    tmp = res.getResultMsg();
                } else {
                    tmp = res.getResultMsg();
                }
            }
            catch (Exception e) {
                tmp = e.getMessage();
            }
            return tmp;
        });
        return JobRunnerResponse.success((String)result);
    }

    @PreDestroy
    public void destroy() {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)LdapSyncScheduler.class.getName()));
        this.schedulerService.unscheduleJob(JobId.of((String)LdapSyncScheduler.class.getName()));
    }
}

