/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.customfields;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import kr.osci.apps.kapproval.service.impl.issueRegServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueCreatedResolvedListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(IssueCreatedResolvedListener.class);
    @JiraImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final IssueManager issueManager;
    @Autowired
    private issueRegServiceImpl issueRegService;

    @Autowired
    public IssueCreatedResolvedListener(EventPublisher eventPublisher, IssueManager issueManager, ActiveObjects activeObjects) {
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
        this.activeObjects = activeObjects;
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Enabling plugin");
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        log.info("Disabling plugin");
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        Long eventTypeId = issueEvent.getEventTypeId();
        Issue issue = issueEvent.getIssue();
        IssueType issueType = issue.getIssueType();
        if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            try {
                this.issueRegService.regIssueApproval(issue, issueType.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                e.getMessage();
            }
        } else if (!eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            if (eventTypeId.equals(EventType.ISSUE_GENERICEVENT_ID)) {
                try {
                    try {
                        this.issueRegService.changeWorkFlow(issue, issueType);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        e.getMessage();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    e.getMessage();
                    log.error("workFlowStEntity {}", (Object)e.getMessage());
                }
            } else if (!eventTypeId.equals(EventType.ISSUE_CLOSED_ID) && eventTypeId.equals(EventType.ISSUE_DELETED_ID)) {
                try {
                    this.issueRegService.deleteIssue(issue, issueType.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    e.getMessage();
                    log.error("Issue {}", (Object)e.getMessage());
                }
            }
        }
    }
}

