/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.customfields;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.atlassian.query.clause.ClauseVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;

@PublicSpi
public class CustomFieldRenderer
implements SearchRenderer {
    private final ClauseNames clauseNames;
    private final CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor;
    private final CustomField field;
    private final CustomFieldValueProvider customFieldValueProvider;
    private final FieldVisibilityManager fieldVisibilityManager;

    public CustomFieldRenderer(ClauseNames clauseNames, CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor, CustomField field, CustomFieldValueProvider customFieldValueProvider, FieldVisibilityManager fieldVisibilityManager) {
        this.clauseNames = clauseNames;
        this.customFieldSearcherModuleDescriptor = customFieldSearcherModuleDescriptor;
        this.field = field;
        this.customFieldValueProvider = customFieldValueProvider;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isExistsInQuery(query);
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        HashMap<String, String> velocityParams = new HashMap<String, String>();
        velocityParams.put("fieldkey", this.field.getCustomFieldType().getKey());
        return this.getEditHtml(searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        HashMap<String, String> velocityParams = new HashMap<String, String>();
        velocityParams.put("fieldkey", this.field.getCustomFieldType().getKey());
        return this.getViewHtml(searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    public CustomField getField() {
        return this.field;
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return CustomFieldUtils.isShownAndVisible((CustomField)this.getField(), (ApplicationUser)user, (SearchContext)searchContext, (FieldVisibilityManager)this.fieldVisibilityManager);
    }

    public String getEditHtml(SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action, Map velocityParams) {
        return this.getDescriptor().getSearchHtml(this.getField(), this.customFieldValueProvider, searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    public String getViewHtml(SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action, Map velocityParams) {
        return this.getDescriptor().getViewHtml(this.getField(), this.customFieldValueProvider, searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    CustomFieldSearcherModuleDescriptor getDescriptor() {
        return this.customFieldSearcherModuleDescriptor;
    }

    boolean isExistsInQuery(Query query) {
        NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor((Collection)this.clauseNames.getJqlFieldNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)clauseVisitor);
        }
        return clauseVisitor.containsNamedClause();
    }
}

