/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.customfields;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.signUserMng;
import kr.osci.apps.kapproval.service.impl.configServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class ApprovalCustomField
extends AbstractSingleFieldType<String> {
    private static final Logger log = LoggerFactory.getLogger(ApprovalCustomField.class);
    @JiraImport
    private final CustomFieldValuePersister customFieldValuePersister;
    @JiraImport
    private final GenericConfigManager genericConfigManager;
    @Autowired
    private configServiceImpl configService;
    @ComponentImport
    protected final FieldManager fieldManager;
    @ComponentImport
    protected final OfBizDelegator ofBizDelegator;
    @ComponentImport
    protected final IssueService issueService;
    @ComponentImport
    protected final LocaleManager localeManager;

    public ApprovalCustomField(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, OfBizDelegator ofBizDelegator, FieldManager fieldManager, IssueService issueService, LocaleManager localeManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.customFieldValuePersister = customFieldValuePersister;
        this.genericConfigManager = genericConfigManager;
        this.fieldManager = fieldManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueService = issueService;
        this.localeManager = localeManager;
    }

    public String getStringFromSingularObject(String singularObject) {
        if (singularObject == null) {
            return null;
        }
        return singularObject.toString();
    }

    public Map<String, Object> getVelocityParameters(Issue issue, CustomField customField, FieldLayoutItem fieldLayoutItem) {
        String parent = "null";
        if (issue != null && issue.getParentObject() != null) {
            parent = issue.getParentObject().getKey();
        }
        Map result = super.getVelocityParameters(issue, customField, fieldLayoutItem);
        if (issue != null && issue.getCustomFieldValue(customField) != null) {
            result.put("restValue", 1);
        }
        result.put("checkLicensed", "valid license");
        ApplicationUser currentUser = ComponentAccessor.getUserManager().getUserByName(ComponentAccessor.getJiraAuthenticationContext().getUser().getKey());
        Locale locale = this.localeManager.getLocaleFor(currentUser);
        String language = locale.getLanguage();
        ApplicationUser appUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        String loginUsernm = appUser.getDisplayName();
        String loginUserkey = appUser.getKey();
        HashMap map = (HashMap)this.getApprovalConfig(issue).getResultData();
        ArrayList lineListEntity = new ArrayList();
        ArrayList lineListSupport = new ArrayList();
        ArrayList list = (ArrayList)map.get("lineListEntity");
        String workStatus = (String)map.get("workStatus");
        ArrayList<signUserMng> signUserMngEntity2 = new ArrayList<signUserMng>();
        ArrayList<signUserMng> signUserSupport = new ArrayList<signUserMng>();
        ArrayList listsign = (ArrayList)map.get("arraySignList");
        for (signUserMng line : listsign) {
            if (line.getApprovalType().equals("\ucc38\uc870") || line.getApprovalType().equals("Reference")) {
                signUserSupport.add(line);
                continue;
            }
            signUserMngEntity2.add(line);
        }
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        String translationNm = issue.getStatus() != null ? issue.getStatus().getNameTranslation() : "";
        String statusName = issue.getStatus() != null ? issue.getStatus().getName() : "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        IssueType it = issue.getIssueType();
        int approvalTdWith = 200;
        result.put("createdateime", issue.getKey() != null ? format.format(issue.getCreated()) : "");
        result.put("creator", issue.getKey() != null ? issue.getCreator() : "");
        result.put("issueTypeId", issue.getKey() != null ? issue.getIssueTypeId() : "");
        result.put("ProjectId", issue.getKey() != null ? issue.getProjectId() : "");
        result.put("issueKey", issue.getKey() != null ? issue.getKey() : "");
        result.put("statusid", issue.getKey() != null ? issue.getStatusId() : "");
        result.put("issueTypeName", it.getName());
        result.put("lineListEntity", lineListEntity);
        result.put("lineListSupport", signUserSupport);
        result.put("arraySignList", signUserMngEntity2);
        result.put("writer", (String)map.get("writer"));
        result.put("loginUsernm", loginUsernm);
        result.put("loginUserkey", loginUserkey);
        result.put("entity", map.get("entity"));
        result.put("baseUrl", baseUrl);
        result.put("language", language);
        result.put("translationNm", translationNm);
        result.put("workStatus", workStatus);
        result.put("statusName", statusName);
        result.put("editDatetime", format.format(new Date(System.currentTimeMillis())));
        result.put("imageKeyPath", "kr.osci.apps.kapproval_jira");
        result.put("isVisbile", listsign.size() > 0 ? "visible" : "none");
        result.put("detailCode", (String)map.get("detailCode"));
        result.put("approvalWith", signUserMngEntity2.size() * approvalTdWith);
        result.put("passwordDisplay", (String)map.get("settingPassword"));
        result.put("ynSuperuser", (String)map.get("ynSuperuser"));
        result.put("customfieldId", (String)map.get("fieldId") == null ? "customfieldId" : (String)map.get("fieldId"));
        return result;
    }

    public String getSingularObjectFromString(String string) throws FieldValidationException {
        if (string == null) {
            return null;
        }
        try {
            return string;
        }
        catch (NumberFormatException ex) {
            throw new FieldValidationException("");
        }
    }

    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    protected String getObjectFromDbValue(Object databaseValue) throws FieldValidationException {
        return this.getSingularObjectFromString((String)databaseValue);
    }

    protected Object getDbValueFromObject(String customFieldObject) {
        return this.getStringFromSingularObject(customFieldObject);
    }

    public KappResult getApprovalConfig(Issue issue) {
        KappResult ka = new KappResult();
        IssueType it = issue.getIssueType();
        String portalid = "";
        ka = this.configService.getApprovalInfo(issue, it.getName(), issue.getKey(), issue.getProjectObject().getName(), issue.getIssueTypeId(), issue.getProjectId(), issue.getStatus() == null ? "" : issue.getStatus().getNameTranslation(), issue.getStatus() == null ? "" : issue.getStatus().getId());
        return ka;
    }
}

