/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.google.gson.Gson;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.reportServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Path(value="/report")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class reportController {
    private static final Logger log = LoggerFactory.getLogger(reportController.class);
    @Autowired
    private reportServiceImpl reportService;
    private Gson gson = new Gson();

    @GET
    @Path(value="/get/all/Report")
    public Response getAllReport(@QueryParam(value="pagecnt") int pagecnt, @QueryParam(value="start_date") String stdate, @QueryParam(value="end_date") String eddate) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.reportService.getAllReportData(pagecnt, stdate, eddate);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/search/info")
    public Response getReoportSearch(@QueryParam(value="option") String option, @QueryParam(value="value") String value, @QueryParam(value="start_date") String stdate, @QueryParam(value="end_date") String eddate) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.reportService.getReoportSearch(option, value, stdate, eddate);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

