/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.profileServiceImpl;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Produces(value={"application/json"})
@Path(value="/profile")
public class profileController
extends AbstractJiraContextProvider {
    private Gson gson = new Gson();
    @ComponentImport
    private final UserProjectHistoryManager userProjectHistoryManager;
    @ComponentImport
    private final profileServiceImpl profileService;

    public profileController(UserProjectHistoryManager userProjectHistoryManager, profileServiceImpl profileService2) {
        this.userProjectHistoryManager = userProjectHistoryManager;
        this.profileService = profileService2;
    }

    public Map<String, Object> getContextMap(ApplicationUser user, JiraHelper jiraHelper) {
        HashMap params = Maps.newHashMap();
        params.put("contextPath", "jiraHelper.getRequest().getContextPath()");
        return params;
    }

    @POST
    public Response uploadFile(@RequestParam(value="file") MultipartFile multipartFile) {
        KappResult result = new KappResult();
        try {
            result = this.profileService.uploadFile(multipartFile);
            result.setResultMsg("SUCCESS");
            result.setResultCode(201);
        }
        catch (Exception | KappExceptionHandler e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
            result.setResultMsg("fail Reason ::::: " + e.getMessage());
        }
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/save/replaceInfo")
    public Response saveReplaceInfo(Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.profileService.saveReplaceInfo(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/getInfo")
    public Response getReplaceInfo() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.profileService.getReplaceInfo();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

