/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.google.gson.Gson;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.orgServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;

@Named
@CrossOrigin(origins={"*"}, allowedHeaders={"*"})
@Path(value="/org")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class orgController {
    private static final Logger log = LoggerFactory.getLogger(orgController.class);
    @Autowired
    private orgServiceImpl orgService;
    private Gson gson = new Gson();

    @GET
    @Path(value="/user/search/info")
    public Response getMemberInfo(@QueryParam(value="option") String option, @QueryParam(value="value") String value) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getMemberInfo(option, value);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/user/getAllUser")
    public Response getAllUser(@QueryParam(value="page") int page) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getAllUser(page);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/user/search/info/modify")
    public Response getMemberInfoModify(@QueryParam(value="username") String username) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getMemberInfoModify(username);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/save/position")
    public Response savePosition(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.savePosition(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/position")
    public Response getPosition() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getPosition();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/save/userList")
    public Response saveUserList(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.saveUserList(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/save/ldapinfo")
    public Response saveLdapBase(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.saveLdapBaseInfo(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/remove/position")
    public Response deletePosition(@QueryParam(value="id") String id) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.deletePosition(id);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/save/orgList")
    public Response saveOrgList(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.saveOrgList(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/orgList")
    public Response getOrgList() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getOrgList();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/jiraFileds")
    public Response getjiraFileds() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getjiraAllFileds();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/jiraFiledsValue")
    public Response getJiraFiledValueList(@QueryParam(value="filed") String filed) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getjiraFiledValue(filed);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/apprvoalTypelist")
    public Response getApprvoalTypelist(@QueryParam(value="lineNum") String lineNum) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getTypelist(lineNum);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/OrgTeamUser")
    public Response getOrgTeamUsers(@QueryParam(value="name") String name) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getOrgTeamUsers(name);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/getLanguage")
    public Response getLanguage() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getLocale();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/user/updateUser")
    public Response updateUser(Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.updateUser(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/get/Ldapinfo")
    public Response getLdapinfo() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getLdapinfo();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/get/getLDapySyncStart")
    public Response getLDapySyncStart() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.LDapSyncSchedulerStart();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/all/customfield")
    public Response getCustomfield() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.orgService.getCustomfields();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

