/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.google.gson.Gson;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.configServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@Named
@Path(value="/config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class configController {
    private static final Logger log = LoggerFactory.getLogger(configController.class);
    @Autowired
    private configServiceImpl configService;
    private Gson gson = new Gson();

    @PUT
    @Path(value="/save/approvalLine")
    public Response saveApprovalLine(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.saveApprovalLine(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/save/approvalApplyLine")
    public Response approvalApplyLine(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.saveApprovalApplyLine(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/approvalList")
    public Response getApprovalList() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getApprovalList();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @DELETE
    @Path(value="/delete/line")
    public Response removeLine(@QueryParam(value="lineNum") String lineNum) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.removeLine(lineNum);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/edit/line")
    public Response editApprovalLine(@QueryParam(value="lineNum") String lineNum) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.editApprovalLine(lineNum);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/save/line/name")
    public Response saveLineName(@QueryParam(value="lineNum") String lineNum, @QueryParam(value="lineNm") String lineNm) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.saveApprovalLineName(lineNum, lineNm);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/save/line/desc")
    public Response saveLineDesc(@QueryParam(value="lineNum") String lineNum, @QueryParam(value="lineDesc") String lineDesc) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.saveApprovalLineDesc(lineNum, lineDesc);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/editAll/line")
    public Response editApprovalAllLine(@QueryParam(value="lineNum") String lineNum) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.editApprovalAllLine(lineNum);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/all/projects")
    public Response getProjects() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getProjects();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/issueType")
    public Response getIssueType(@QueryParam(value="id") int id) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getIssueType(id);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/delete/removeTypeLine")
    public Response removeTypeLine(@QueryParam(value="seq") int seq) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.deleteTypeLine(seq);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/getEditTypelLine")
    public Response getEditTypelLine(@QueryParam(value="seq") int seq) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getEditLindList(seq);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/getWorkFlows")
    public Response getWorkFlows(@QueryParam(value="prjid") String prjid, @QueryParam(value="issueid") String issueid) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getWorkFlows(prjid, issueid);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/select/getTransApproval")
    public Response getTransApproval(@QueryParam(value="id") String id, @QueryParam(value="value") String value, @QueryParam(value="workflowNm") String workflowNm) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getTransApproval(id, value, workflowNm);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/all/pendingList")
    public Response getPendingList() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getAllPendingList();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/bulk/approval")
    public Response bulkApproval(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.bulkApprovalList(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/email/approval")
    public Response eamilApproval(@QueryParam(value="ty") String ty, @QueryParam(value="issuekey") String issuekey, @QueryParam(value="userkey") String userkey) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.externalApproval(ty, issuekey, userkey, "Email", "");
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/approvalLine")
    public Response getApprovalLine(@QueryParam(value="fieldname") String fieldname, @QueryParam(value="fieldvalue") String fieldvalue) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getCustomFiledApprovalLine(fieldname, fieldvalue);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

