/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.google.gson.Gson;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.SettingServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@Named
@Path(value="/setting")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SettingController {
    private static final Logger log = LoggerFactory.getLogger(SettingController.class);
    @Autowired
    private SettingServiceImpl settingService;
    private Gson gson = new Gson();

    @GET
    @Path(value="/save/LineType")
    public Response saveSettingLineType(@QueryParam(value="typeValue") String typeValue) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.settingService.saveLineSetting(typeValue);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/save/passwordtype")
    public Response saveSettingPasswordType(@QueryParam(value="typeValue") String typeValue) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.settingService.savePasswordSetting(typeValue);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/get/settingInfo")
    public Response getSettingInfo() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.settingService.selectSettingValue();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @PUT
    @Path(value="/save/superusers")
    public Response saveSupserUsers(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.settingService.saveSuperUsers(obj);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/remove/superuser")
    public Response deleteSuperuser(@QueryParam(value="id") String id) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.settingService.deleteSuperuser(id);
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @GET
    @Path(value="/all/superuser")
    public Response getAllSuperUser() throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.settingService.selectAllSuperUser();
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

