/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.configServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@Named
@Path(value="/mirae")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MiraeController {
    private static final Logger log = LoggerFactory.getLogger(MiraeController.class);
    @Autowired
    private configServiceImpl configService;
    private Gson gson = new Gson();

    @GET
    @Path(value="/issue/approval-line")
    public Response getApprovalLine(@QueryParam(value="issuekey") String issuekey, @QueryParam(value="userkey") String userkey) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            result = this.configService.getApprovalLineInfo(issuekey, userkey);
        }
        catch (Exception e) {
            result.setErrorCode("400");
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    @POST
    @Path(value="/sign/approval")
    public Response approval(@RequestBody Object obj) throws KappExceptionHandler {
        KappResult result = new KappResult();
        try {
            String approvalty = (String)((LinkedHashMap)obj).get("approvalty");
            String issuekey = (String)((LinkedHashMap)obj).get("issuekey");
            String userkey = (String)((LinkedHashMap)obj).get("userkey");
            String path = (String)((LinkedHashMap)obj).get("path");
            String dcrmk = (String)((LinkedHashMap)obj).get("comment");
            result = this.configService.externalApproval(approvalty, issuekey, userkey, path, dcrmk);
        }
        catch (Exception e) {
            result.setErrorCode("400");
            result.setResultMsg(e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

