/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.entity.signUserMngEntity;
import kr.osci.apps.kapproval.jsm.JsmJql;
import kr.osci.apps.kapproval.service.impl.issueRegServiceImpl;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Path(value="/jsm")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsmController {
    private static final Logger log = LoggerFactory.getLogger(JsmController.class);
    @Autowired
    private issueRegServiceImpl issueRegService;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final ActiveObjects activeObjects;
    private Gson gson = new Gson();

    public JsmController(IssueManager issueManager, ActiveObjects activeObjects) {
        this.issueManager = issueManager;
        this.activeObjects = activeObjects;
    }

    @GET
    @Path(value="/get/jqlList")
    public Response saveSettingLineType(@QueryParam(value="value") String value, @QueryParam(value="userKey") String userKey) throws KappExceptionHandler {
        KappResult result = new KappResult();
        ArrayList arrayList = new ArrayList();
        try {
            switch (JsmJql.valueOf(value)) {
                case ALL: {
                    arrayList = this.getjqlList(userKey, "ALL");
                    break;
                }
                case WAIT: {
                    arrayList = this.getjqlList(userKey, "N");
                    break;
                }
                case APPROVED: {
                    arrayList = this.getjqlList(userKey, "Y");
                    break;
                }
                case REJECT: {
                    arrayList = this.getjqlList(userKey, "X");
                    break;
                }
            }
        }
        catch (Exception e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
        }
        result.setResultData(arrayList);
        return Response.ok((Object)this.gson.toJson(result)).build();
    }

    public ArrayList getjqlList(String userkey, String status) {
        ArrayList issueList = new ArrayList();
        ApplicationUser applicationUser = ComponentAccessor.getUserManager().getUserByKey(userkey);
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        try {
            signUserMngEntity[] signUserMngEntity2 = (signUserMngEntity[])this.activeObjects.find(signUserMngEntity.class, Query.select().where(" APPRVOAL_USERKEY = ? ", new Object[]{userkey}));
            List<signUserMngEntity> entityList = Arrays.stream(signUserMngEntity2).collect(Collectors.toList());
            entityList = JsmController.distinctArray(entityList, "ISSUE_KEY");
            entityList.stream().forEach(item -> {
                signUserMngEntity approvals = (signUserMngEntity)item;
                if ("ALL".equals(status)) {
                    if (approvals.getPortalId() != null && approvals.getPrjType() != null && this.getIssue(approvals.getIssueKey()) != null && !approvals.getPortalId().equals("") && approvals.getPrjType().equals("jiraSerivceDesk")) {
                        HashMap<String, String> issueMap = new HashMap<String, String>();
                        Issue issue = this.getIssue(approvals.getIssueKey());
                        IssueType issueType = issue.getIssueType();
                        issueMap.put("IssueKey", issue.getKey());
                        issueMap.put("description", issue.getDescription());
                        issueMap.put("summary", issue.getSummary());
                        issueMap.put("creator", issue.getCreator().getDisplayName());
                        issueMap.put("statusName", issue.getStatus().getName());
                        issueMap.put("reporter", issue.getReporter().getDisplayName());
                        issueMap.put("serviceName", issue.getProjectObject().getName());
                        issueMap.put("contextPath", baseUrl);
                        issueMap.put("iconUrl", issueType.getIconUrl());
                        issueMap.put("potalID", approvals.getPortalId());
                        issueList.add(issueMap);
                    }
                } else if (approvals.getStatus().equals(status) && approvals.getPortalId() != null && approvals.getPrjType() != null && this.getIssue(approvals.getIssueKey()) != null && !approvals.getPortalId().equals("") && approvals.getPrjType().equals("jiraSerivceDesk")) {
                    HashMap<String, String> issueMap = new HashMap<String, String>();
                    Issue issue = this.getIssue(approvals.getIssueKey());
                    IssueType issueType = issue.getIssueType();
                    issueMap.put("IssueKey", issue.getKey());
                    issueMap.put("description", issue.getDescription());
                    issueMap.put("summary", issue.getSummary());
                    issueMap.put("creator", issue.getCreator().getDisplayName());
                    issueMap.put("statusName", issue.getStatus().getName());
                    issueMap.put("reporter", issue.getReporter().getDisplayName());
                    issueMap.put("serviceName", issue.getProjectObject().getName());
                    issueMap.put("contextPath", baseUrl);
                    issueMap.put("iconUrl", issueType.getIconUrl());
                    issueMap.put("potalID", approvals.getPortalId());
                    issueList.add(issueMap);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return issueList;
    }

    private Issue getIssue(String issuekey) {
        try {
            MutableIssue issue = this.issueManager.getIssueObject(issuekey);
            return issue;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            return null;
        }
    }

    private static List<signUserMngEntity> distinctArray(List<signUserMngEntity> target, Object key) {
        if (target != null) {
            target = target.stream().filter(JsmController.distinctByKey(o -> o.getIssueKey())).collect(Collectors.toList());
        }
        return target;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

