/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.controller;

import com.google.gson.Gson;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kr.osci.apps.kapproval.common.KappExceptionHandler;
import kr.osci.apps.kapproval.common.KappResult;
import kr.osci.apps.kapproval.service.impl.orgServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@Named
@Path(value="/file")
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    private Gson gson = new Gson();
    @Autowired
    private orgServiceImpl orgService;

    @POST
    @Path(value="/csv/upload")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response csvSaveData(@RequestBody Object jsObject) {
        KappResult result = new KappResult();
        try {
            result = this.orgService.saveCsvData(jsObject);
        }
        catch (Exception | KappExceptionHandler e) {
            result.setResultCode(400);
            result.setErrorCode(e.getMessage());
            result.setResultMsg("fail Reason ::::: " + e.getMessage());
        }
        return Response.ok((Object)this.gson.toJson(result)).build();
    }
}

