/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.common;

import javax.servlet.http.HttpServletRequest;
import kr.osci.apps.kapproval.common.KappBaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class KappExceptionHandler
extends Throwable {
    private static final Logger log = LoggerFactory.getLogger(KappBaseController.class);

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public void httpRequestMethodNotSupportedExceptionHandler(HttpServletRequest req, Exception e) {
        log.error("******************* Error *******************");
        if (e.getCause() != null) {
            log.error("Error Message >> " + e.getCause().getMessage());
        } else {
            log.error("Error Message >> " + e.getMessage());
        }
        e.printStackTrace();
        log.error("**********************************************");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public void requestParameterExceptionHandler(HttpServletRequest req, Exception e) {
        log.error("******************* Error *******************");
        if (e.getCause() != null) {
            log.error("Error Message >> " + e.getCause().getMessage());
        } else {
            log.error("Error Message >> " + e.getMessage());
        }
        e.printStackTrace();
        log.error("**********************************************");
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public void typeMismatchException(HttpServletRequest req, Exception e) {
        log.error("******************* Error *******************");
        if (e.getCause() != null) {
            log.error("Error Message >> " + e.getCause().getMessage());
        } else {
            log.error("Error Message >> " + e.getMessage());
        }
        e.printStackTrace();
        log.error("**********************************************");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void defaultErrorHandler(HttpServletRequest req, Exception e) {
        if (!e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
            log.error("******************* Error *******************");
            if (e.getCause() != null) {
                log.error("Error Message >> " + e.getCause().getMessage());
            } else {
                log.error("Error Message >> " + e.getMessage());
            }
            e.printStackTrace();
            log.error("**********************************************");
        }
    }
}

