/*
 * Decompiled with CFR 0.152.
 */
package kr.osci.apps.kapproval.License;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import javax.inject.Inject;
import kr.osci.apps.kapproval.License.ConditionEvaluator;
import kr.osci.apps.kapproval.License.ConditionType;

public class ConditionEvaluatorImpl
implements ConditionEvaluator {
    @ComponentImport
    private final PluginLicenseManager licenseManager;

    @Inject
    public ConditionEvaluatorImpl(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public boolean evaluate(ConditionType type) {
        switch (type) {
            case LICENSED: {
                return this.isLicenseValid();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLicenseValid() {
        String errorMessage = "";
        if (!this.licenseManager.getLicense().isDefined()) return false;
        PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
        if (!license.getError().isDefined()) return true;
        switch ((LicenseError)license.getError().get()) {
            case EXPIRED: {
                return false;
            }
            case TYPE_MISMATCH: {
                return false;
            }
            case USER_MISMATCH: {
                return false;
            }
            case VERSION_MISMATCH: {
                return false;
            }
            case EDITION_MISMATCH: {
                return false;
            }
            case ROLE_EXCEEDED: {
                return false;
            }
            case ROLE_UNDEFINED: {
                return false;
            }
            default: {
                return false;
            }
        }
    }
}

