/*
 * Decompiled with CFR 0.152.
 */
package com.okapya.jira.sil.connector.descriptors;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.keplerrominfo.common.util.MutableString;
import com.keplerrominfo.jira.commons.ivm.AbstractCustomFieldDescriptor;
import com.keplerrominfo.sil.lang.SILContext;
import com.keplerrominfo.sil.lang.SILException;
import com.keplerrominfo.sil.lang.SILValue;
import com.keplerrominfo.sil.lang.SILValueFactory;
import com.keplerrominfo.sil.lang.type.AbstractDefaultOpsSILType;
import com.keplerrominfo.sil.lang.type.TypeInst;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ChecklistDescriptor
extends AbstractCustomFieldDescriptor<Collection<Object>, MutableString> {
    public ChecklistDescriptor(Issue issue, CustomField customField) {
        super(issue, customField);
    }

    public AbstractDefaultOpsSILType<MutableString> getType() {
        return TypeInst.STRING;
    }

    public Collection<Object> toJiraValue(SILContext silContext, SILValue<MutableString> silValue) {
        CustomFieldType customFieldType = this.getCustomField().getCustomFieldType();
        ArrayList<Object> checklistItems = new ArrayList<Object>();
        try {
            JSONArray jsonArray = new JSONArray(silValue.toStringValue());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Object checklistItem = customFieldType.getSingularObjectFromString(jsonObject.toString());
                checklistItems.add(checklistItem);
            }
        }
        catch (Exception ex) {
            if (ex instanceof SILException) {
                throw (SILException)ex;
            }
            throw new SILException(String.format("Could not convert %s to a ChecklistItem collection", silValue), (Throwable)ex);
        }
        return checklistItems;
    }

    public SILValue<MutableString> toSILValue(SILContext silContext, Collection<Object> checklistItems) {
        StringBuilder sb = new StringBuilder().append('[');
        try {
            Method toJsonMethodInfo = null;
            Iterator<Object> iterator = checklistItems.iterator();
            while (iterator.hasNext()) {
                Object checklistItem = iterator.next();
                if (toJsonMethodInfo == null) {
                    toJsonMethodInfo = checklistItem.getClass().getMethod("toJson", new Class[0]);
                }
                sb.append(toJsonMethodInfo.invoke(checklistItem, new Object[0]));
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
        }
        catch (Exception ex) {
            throw new SILException(String.format("Could not convert %s to a Json Array", checklistItems), (Throwable)ex);
        }
        sb.append(']');
        return SILValueFactory.string((String)sb.toString());
    }
}

