/*
 * Decompiled with CFR 0.152.
 */
package com.okapya.jira.sil.connector;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.keplerrominfo.jira.commons.ivm.CustomFieldDescriptorFactory;
import com.keplerrominfo.jira.commons.ivm.CustomFieldDescriptorRegistry;
import com.keplerrominfo.sil.lang.SILType;
import com.keplerrominfo.sil.lang.type.TypeInst;
import com.okapya.jira.sil.connector.descriptors.ChecklistDescriptorFactory;
import com.okapya.jira.sil.connector.types.ChecklistItemType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={LifecycleAware.class})
@Component
public class ConnectorPluginLauncher
implements LifecycleAware {
    private static final String CHECKLIST_FIELD_TYPE_KEY = "com.okapya.jira.checklist:checklist";
    private static final Log LOG = LogFactory.getLog(ConnectorPluginLauncher.class);
    private final CustomFieldDescriptorRegistry customFieldDescriptorRegistry;

    @Autowired
    public ConnectorPluginLauncher(@ComponentImport CustomFieldDescriptorRegistry customFieldDescriptorRegistry) {
        this.customFieldDescriptorRegistry = customFieldDescriptorRegistry;
    }

    public void onStart() {
        try {
            ChecklistItemType checklistItemType = ChecklistItemType.getInstance();
            TypeInst.registerStatic((String)checklistItemType.getName(), (SILType)checklistItemType);
            this.customFieldDescriptorRegistry.register(CHECKLIST_FIELD_TYPE_KEY, (CustomFieldDescriptorFactory)new ChecklistDescriptorFactory());
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to register the Checklist SIL Connector. Please make sure the SIL Engine app is installed first.", (Throwable)e);
        }
    }

    public void onStop() {
        try {
            ChecklistItemType checklistItemType = ChecklistItemType.getInstance();
            TypeInst.unregisterStatic((String)checklistItemType.getName());
            this.customFieldDescriptorRegistry.unregister("com.okapya.jira.checklist");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to unregister the Checklist SIL Connector.", (Throwable)e);
        }
    }
}

