<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
                xmlns:html="http://www.w3.org/TR/REC-html40"
                xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>XML Sitemap</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <style type="text/css">
                    body {
                        font-size: 18px;
                        color: #252525;
                    }

                    table {
                        border-collapse: collapse;
                        text-align: center;
                    }

                    th {
                        font-weight: 700;
                        border: 1px solid #000;
                        padding: 10px 20px;
                    }

                    #sitemap tbody td {
                        padding: 10px 20px;
                        border: 1px solid #000;
                    }

                    #sitemap tr:nth-child(odd) td {
                        background-color: #fbfff2;
                    }

                    #sitemap tr:nth-child(even) td {
                        background-color: #fbf2f2;
                    }
                    td:nth-child(1) , th:nth-child(1){
                        text-align: left;
                    }
                    #content {
                        margin: 0 auto;
                        width: 1000px;
                    }
                    .expl {
                        margin: 18px 3px;
                        line-height: 1.2em;
                    }
                    a {
                        color: #0000ff;
                        text-decoration: none;
                    }
                    a:hover {
                        text-decoration: underline;
                    }
                </style>
            </head>
            <body>
                <div id="content">
                    <h1>XML Sitemap</h1>
                    <p>This is an XML Sitemap, meant for consumption by search engines.</p>
                    <p>Generated with the help of <a href="https://zagdozar.com/apps/sitemap">Sitemap for confluence</a></p>

                    <p class="expl">
                        This XML Sitemap contains <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/> URLs.
                    </p>
                    <table id="sitemap" cellpadding="3">
                        <thead>
                            <tr>
                                <th width="*">URL</th>
                                <th width="10%">Mobile</th>
                                <th title="Last Modification Time" width="30%">Last Mod.</th>														
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:for-each select="sitemap:urlset/sitemap:url">
                                <tr>
                                    <td>
                                        <xsl:variable name="itemURL">
                                            <xsl:value-of select="sitemap:loc"/>
                                        </xsl:variable>
                                        <a href="{$itemURL}">
                                            <xsl:value-of select="sitemap:loc"/>
                                        </a>
                                    </td>
                                    <td>
                                        <xsl:variable name="itemURL">
                                            <xsl:value-of select="xhtml:link/@href"/>
                                        </xsl:variable>
                                        <a href="{$itemURL}">Mobile</a>
                                    </td>
                                    <td>
                                        <xsl:value-of select="concat(concat(substring(sitemap:lastmod,0,11),'__'), substring(sitemap:lastmod,12,5))"/>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </tbody>
                    </table>

                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>



