/*
 * Decompiled with CFR 0.152.
 */
package com.zagdozar.sima.filter;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.zagdozar.sima.action.SitemapServlet;
import com.zagdozar.sima.helper.Auth;
import com.zagdozar.sima.model.Config;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class MainFilter
implements Filter {
    private String skipParam = "skip";
    private Config _config = new Config();
    private SitemapServlet _site = new SitemapServlet();
    private Auth _auth = new Auth();
    private SpaceManager _spaceManager;
    private SettingsManager _settingsManager;
    private TransactionTemplate _transactionTemplate;
    private PluginSettingsFactory _pluginSettingsFactory;
    private PermissionManager _permissionManager;
    private PluginLicenseManager _pluginLicenseManager;

    MainFilter(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport SettingsManager settingsManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager) {
        this._transactionTemplate = transactionTemplate;
        this._pluginSettingsFactory = pluginSettingsFactory;
        this._pluginLicenseManager = pluginLicenseManager;
        this._settingsManager = settingsManager;
        this._permissionManager = permissionManager;
        this._spaceManager = spaceManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this._site.init(this._spaceManager, this._settingsManager, this._transactionTemplate, this._pluginSettingsFactory, this._permissionManager);
        this._auth.init(this._pluginLicenseManager);
        HttpServletResponse hres = (HttpServletResponse)response;
        HttpServletRequest hreq = (HttpServletRequest)request;
        if (this.handle(hres, hreq)) {
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean handle(HttpServletResponse hres, HttpServletRequest hreq) throws IOException, ServletException {
        if (hreq.getParameter(this.skipParam) != null) {
            return false;
        }
        String uri = this.findUriNoContext(hreq);
        if (this._auth.isValid() && uri.equals("/sitemap.xml")) {
            this._site.doGet(hreq, hres);
            return true;
        }
        return false;
    }

    private String findUriNoContext(HttpServletRequest hreq) {
        String uri = hreq.getRequestURI();
        String context = hreq.getContextPath();
        return uri.substring(context.length());
    }

    public void destroy() {
    }
}

