/*
 * Decompiled with CFR 0.152.
 */
package com.zagdozar.sima.action;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.zagdozar.sima.action.PageInfo;
import com.zagdozar.sima.model.ChangeFreqValues;
import com.zagdozar.sima.model.Config;
import com.zagdozar.sima.model.PriorityValues;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class SitemapServlet
extends HttpServlet {
    private DateFormat _format;
    private Date _minDate;
    private Config _config = new Config();
    private Set<String> excludeUrls = new HashSet<String>();
    private SpaceManager _spaceManager;
    private SettingsManager _settingsManager;
    private TransactionTemplate _transactionTemplate;
    private PluginSettingsFactory _pluginSettingsFactory;
    private PermissionManager _permissionManager;
    private String _baseUrl = "";
    private boolean _withMobile = false;
    private String _changeFreq = null;
    private int _priority = 0;
    private boolean _showHtml = false;

    public SitemapServlet() {
        this._format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this._format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.loadData();
        response.setContentType("text/xml;charset=utf-8");
        PrintWriter pp = response.getWriter();
        pp.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this._showHtml) {
            pp.write(String.format("<?xml-stylesheet type='text/xsl' href='%s/download/resources/com.zagdozar.sitemap:sima.xsl/xsl/sitemap.xsl'?>\n", request.getContextPath()));
        }
        pp.write("<urlset xmlns='http://www.sitemaps.org/schemas/sitemap/0.9' xmlns:xhtml='http://www.w3.org/1999/xhtml'>\n");
        this.addPages(pp);
        pp.write("</urlset>\n");
    }

    private void addPages(PrintWriter pp) {
        List spaces = this._spaceManager.getAllSpaces();
        ArrayList<PageInfo> pages = new ArrayList<PageInfo>();
        for (Space space : spaces) {
            this.addPages(pages, space.getHomePage(), this._changeFreq, 80);
        }
        pages.sort(new Comparator<PageInfo>(){

            @Override
            public int compare(PageInfo aa, PageInfo bb) {
                return -aa.date.compareTo(bb.date);
            }
        });
        String cssMobile = this.cssMobileQuery();
        for (PageInfo page : pages) {
            if (this.isExcludeUrl(page.url)) continue;
            pp.write(String.format("  <url>\n", new Object[0]));
            pp.write(String.format("    <loc>%s</loc>\n", page.url));
            if (this._withMobile) {
                pp.write(String.format("    <xhtml:link rel='alternate' media='%s' href='%s' />\n", cssMobile, page.urlMobile));
            }
            pp.write(String.format("    <lastmod>%s</lastmod>\n", this._format.format(page.date)));
            if (page.changeFreq != null) {
                pp.write(String.format("    <changefreq>%s</changefreq>\n", page.changeFreq));
            }
            if (this._priority != 0) {
                pp.write(String.format("    <priority>%s</priority>\n", this.findPriority(page.priority)));
            }
            pp.write(String.format("  </url>\n", new Object[0]));
        }
    }

    private void addPages(ArrayList<PageInfo> pages, Page root, String changefreq, int priority) {
        if (root == null) {
            return;
        }
        this.add(pages, root, this._changeFreq, priority);
        for (Page page : root.getChildren()) {
            this.addPages(pages, page, this._changeFreq, priority - 1);
        }
    }

    private void add(ArrayList<PageInfo> pages, Page page, String changeFreq, int priority) {
        if (!this._permissionManager.hasPermission(null, Permission.VIEW, (Object)page)) {
            return;
        }
        PageInfo pi = new PageInfo();
        pi.url = this.findUrlMain(page);
        pi.urlMobile = this.findUrlMobile(page);
        pi.date = this.findLastModified(page);
        pi.priority = priority;
        pi.changeFreq = changeFreq;
        pages.add(pi);
    }

    private String findPriority(int pp) {
        if (pp < 0 || pp > 100) {
            pp = 50;
        }
        String fmt = pp % 10 == 0 ? "%.1f" : "%.2f";
        return String.format(fmt, (double)pp / 100.0);
    }

    private void loadMinDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this._minDate = formatter.parse("");
        }
        catch (ParseException ee) {
            this._minDate = null;
        }
    }

    private void loadExcludeUrls() {
    }

    private boolean isExcludeUrl(String url) {
        String uri = SitemapServlet.encodeUriUTF8(SitemapServlet.findUriPath(url));
        return this.excludeUrls.contains(uri);
    }

    private Date findLastModified(Page page) {
        Date modify = page.getLastModificationDate();
        if (this._minDate == null) {
            return modify;
        }
        if (this._minDate.after(modify)) {
            return this._minDate;
        }
        return modify;
    }

    private String cssMobileQuery() {
        return "only screen and (max-width: 500px)";
    }

    private static String encodeUriUTF8(String uri) {
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException ee) {
            return "";
        }
    }

    private static String findUriPath(String uri) {
        try {
            URL url = new URL(uri);
            return url.getPath();
        }
        catch (MalformedURLException ee) {
            return "";
        }
    }

    public void init(SpaceManager spaceManage, SettingsManager settingsManager, TransactionTemplate transactionTemplate, PluginSettingsFactory pluginSettingsFactory, PermissionManager permissionManager) {
        this._spaceManager = spaceManage;
        this._transactionTemplate = transactionTemplate;
        this._pluginSettingsFactory = pluginSettingsFactory;
        this._permissionManager = permissionManager;
        this._settingsManager = settingsManager;
        this._permissionManager = permissionManager;
    }

    private void loadData() {
        this._config.load(this._transactionTemplate, this._pluginSettingsFactory, null);
        this._baseUrl = this.findBaseUrl();
        this._withMobile = this._config.valWithMobile();
        this._priority = PriorityValues.find(this._config.getPriority());
        this._changeFreq = ChangeFreqValues.find(this._config.getChangeFreq());
        this._showHtml = this._config.valShowHtml();
    }

    private String findBaseUrl() {
        String baseUrl = this._settingsManager.getGlobalSettings().getBaseUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private String findUrlMain(Page page) {
        return this._baseUrl + page.getUrlPath();
    }

    private String findUrlMobile(Page page) {
        return this._baseUrl + String.format("/plugins/servlet/mobile?contentId=%d#content/view/%d", page.getId(), page.getId());
    }
}

