/*
 * Decompiled with CFR 0.152.
 */
package com.zagdozar.sima.action;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.zagdozar.sima.helper.Auth;
import com.zagdozar.sima.model.ChangeFreqValues;
import com.zagdozar.sima.model.PriorityValues;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class SettingsServlet
extends HttpServlet {
    private Auth _auth = new Auth();
    private LoginUriProvider _loginUriProvider;
    private TemplateRenderer _renderer;
    private UserManager _userManager;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this._userManager.getRemoteUser();
        if (user == null || !this._userManager.isSystemAdmin(user.getUserKey())) {
            this.redirectLogin(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("pluginValid", Boolean.valueOf(this._auth.isValid()));
        params.put("changeFreqValues", ChangeFreqValues.data);
        params.put("priorityValues", PriorityValues.data);
        this._renderer.render("vmd/admin/settings.vm", params, (Writer)response.getWriter());
    }

    private void redirectLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI requestUri = this.findRequestUri(request);
        response.sendRedirect(this._loginUriProvider.getLoginUri(requestUri).toASCIIString());
    }

    private URI findRequestUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public void setLoginUriProvider(LoginUriProvider value) {
        this._loginUriProvider = value;
    }

    public void setTemplateRenderer(TemplateRenderer value) {
        this._renderer = value;
    }

    public void setUserManager(UserManager value) {
        this._userManager = value;
    }

    SettingsServlet(@ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport UserManager userManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this._loginUriProvider = loginUriProvider;
        this._renderer = renderer;
        this._userManager = userManager;
        this._auth.init(pluginLicenseManager);
    }
}

