/*
 * Decompiled with CFR 0.152.
 */
package com.zagdozar.sima.action;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.zagdozar.sima.model.Config;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/")
@Scanned
public class ConfigResource {
    private PluginSettingsFactory _pluginSettingsFactory;
    private TransactionTemplate _transactionTemplate;
    private UserManager _userManager;

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Config config = new Config();
        Object oo = config.load(this._transactionTemplate, this._pluginSettingsFactory, null);
        return Response.ok((Object)oo).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(Config config, @Context HttpServletRequest request) {
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        config.save(this._transactionTemplate, this._pluginSettingsFactory, null);
        return Response.noContent().build();
    }

    private boolean isAuthorized(HttpServletRequest request) {
        UserProfile user = this._userManager.getRemoteUser();
        return user != null && this._userManager.isSystemAdmin(user.getUserKey());
    }

    ConfigResource(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport UserManager userManager) {
        this._pluginSettingsFactory = pluginSettingsFactory;
        this._transactionTemplate = transactionTemplate;
        this._userManager = userManager;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory value) {
        this._pluginSettingsFactory = value;
    }

    public void set_transactionTemplate(TransactionTemplate value) {
        this._transactionTemplate = value;
    }

    public void setUserManager(UserManager value) {
        this._userManager = value;
    }
}

