/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel.proxy;

import com.testingbot.tunnel.App;
import com.testingbot.tunnel.Statistics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Promise;

public class CustomConnectHandler
extends ConnectHandler {
    private boolean debugMode = false;
    private final String proxyHost;
    private final int proxyPort;
    private String proxyAuth = null;

    public CustomConnectHandler(App app) {
        String proxy = app.getProxy();
        if (proxy != null) {
            int colon = proxy.indexOf(58);
            if (colon != -1) {
                this.proxyHost = proxy.substring(0, colon);
                this.proxyPort = Integer.parseInt(proxy.substring(colon + 1));
            } else {
                this.proxyHost = proxy;
                this.proxyPort = 80;
            }
        } else {
            this.proxyHost = null;
            this.proxyPort = -1;
        }
        if (app.getProxyAuth() != null) {
            this.proxyAuth = Base64.getEncoder().encodeToString(app.getProxyAuth().getBytes());
        }
    }

    public void setDebugMode(boolean mode) {
        this.debugMode = mode;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Enumeration<String> headerNames;
        String method = request.getMethod();
        Statistics.addRequest();
        if (HttpMethod.CONNECT.is(request.getMethod())) {
            Logger.getLogger(CustomConnectHandler.class.getName()).log(Level.INFO, "[{0}] {1} ({2})", new Object[]{method, request.getRequestURL().toString().split(":443")[0].replaceAll("http:", "https:"), response.toString().substring(9, 12)});
        }
        if (this.debugMode && (headerNames = request.getHeaderNames()) != null) {
            StringBuilder sb = new StringBuilder();
            while (headerNames.hasMoreElements()) {
                String header = headerNames.nextElement();
                sb.append(header).append(": ").append(request.getHeader(header)).append(System.getProperty("line.separator"));
            }
            Logger.getLogger(CustomConnectHandler.class.getName()).log(Level.INFO, sb.toString());
        }
        super.handle(target, baseRequest, request, response);
    }

    @Override
    protected void connectToServer(HttpServletRequest request, String host, int port, Promise<SocketChannel> promise) {
        if (this.proxyHost == null) {
            super.connectToServer(request, host, port, promise);
        } else {
            this.connectToProxy(request, promise);
        }
    }

    private void connectToProxy(HttpServletRequest request, Promise<SocketChannel> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            channel.connect(this.newConnectAddress(this.proxyHost, this.proxyPort));
            Selector selector = Selector.open();
            channel.register(selector, 8);
            while (selector.select() > 0) {
                Set<SelectionKey> keys = selector.selectedKeys();
                Iterator<SelectionKey> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    iterator.remove();
                    if (key.isConnectable()) {
                        if (!channel.finishConnect()) {
                            throw new IOException("Failure: channel.finishConnect()");
                        }
                        channel.register(selector, 1);
                        StringBuilder connect = new StringBuilder();
                        connect.append(request.getMethod()).append(' ').append(request.getPathInfo()).append(' ').append(request.getProtocol());
                        Enumeration<String> headerNames = request.getHeaderNames();
                        while (headerNames.hasMoreElements()) {
                            String headerName = headerNames.nextElement();
                            String headerValue = request.getHeader(headerName);
                            connect.append('\n').append(headerName).append(": ").append(headerValue);
                        }
                        if (this.proxyAuth != null) {
                            connect.append("\nProxy-Authorization: Basic ").append(this.proxyAuth);
                        }
                        connect.append("\r\n\r\n");
                        ByteBuffer buffer = ByteBuffer.wrap(connect.toString().getBytes());
                        while (buffer.hasRemaining()) {
                            channel.write(buffer);
                        }
                        continue;
                    }
                    if (!key.isReadable() || !channel.isConnected()) continue;
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    StringBuilder response = new StringBuilder();
                    while (channel.read(buffer) > 0) {
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            response.append((char)buffer.get());
                        }
                    }
                    if (!response.toString().contains("200")) {
                        throw new IOException("Channel error response:\n" + response);
                    }
                    try {
                        selector.close();
                    }
                    catch (IOException e) {
                        LOG.ignore(e);
                    }
                    promise.succeeded(channel);
                    return;
                }
            }
        }
        catch (IOException x) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException t) {
                    LOG.ignore(t);
                }
            }
            promise.failed(x);
        }
    }
}

