/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import com.testingbot.tunnel.App;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PidPoller {
    private File pidFile;
    private Timer timer;
    private final Thread cleanupThread;

    public PidPoller(App app) {
        String fileName = "testingbot-tunnel.pid";
        if (app.getTunnelIdentifier() != null && !app.getTunnelIdentifier().isEmpty()) {
            fileName = "testingbot-tunnel-" + app.getTunnelIdentifier() + ".pid";
        }
        final String pidFileName = fileName;
        this.cleanupThread = new Thread(){

            @Override
            public void run() {
                File f = new File(pidFileName);
                if (f.exists()) {
                    f.delete();
                }
            }
        };
        this.pidFile = new File(fileName);
        if (!this.pidFile.exists()) {
            try {
                FileWriter fw = new FileWriter(this.pidFile.getAbsoluteFile());
                try (BufferedWriter bw = new BufferedWriter(fw);){
                    bw.write("TestingBot Tunnel, Remove this file to shutdown the tunnel");
                }
                Logger.getLogger(PidPoller.class.getName()).log(Level.INFO, "Pid file: {0}", this.pidFile.getAbsoluteFile().toString());
            }
            catch (IOException ex) {
                Logger.getLogger(PidPoller.class.getName()).log(Level.SEVERE, "Can't create testingbot pidfile in current directory");
                return;
            }
        }
        Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new PollTask(), 5000L, 5000L);
    }

    public void cancel() {
        Runtime.getRuntime().removeShutdownHook(this.cleanupThread);
        this.timer.cancel();
    }

    class PollTask
    extends TimerTask {
        PollTask() {
        }

        @Override
        public void run() {
            if (!PidPoller.this.pidFile.exists()) {
                Logger.getLogger(PidPoller.class.getName()).log(Level.INFO, "{0} pidFile was removed, shutting down Tunnel", PidPoller.this.pidFile.toString());
                PidPoller.this.timer.cancel();
                System.exit(0);
            }
        }
    }
}

