/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import com.testingbot.tunnel.App;
import com.testingbot.tunnel.proxy.CustomConnectHandler;
import com.testingbot.tunnel.proxy.TunnelProxyServlet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public final class HttpProxy {
    private final App app;
    private final Server httpProxy;
    private final int randomNumber = (int)(Math.random() * 50.0 + 1.0);
    private final Thread shutDownHook;

    public HttpProxy(App app) {
        this.app = app;
        this.httpProxy = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        ServerConnector connector = new ServerConnector(this.httpProxy, new HttpConnectionFactory(http_config));
        connector.setPort(app.getJettyPort());
        connector.setIdleTimeout(400000L);
        this.httpProxy.setConnectors(new Connector[]{connector});
        this.httpProxy.setStopAtShutdown(true);
        ServletHolder servletHolder = new ServletHolder(TunnelProxyServlet.class);
        servletHolder.setInitParameter("idleTimeout", "120000");
        servletHolder.setInitParameter("timeout", "120000");
        if (app.getFastFail() != null && app.getFastFail().length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String domain : app.getFastFail()) {
                if (!domain.contains(":")) {
                    domain = domain + ":80";
                }
                sb.append(domain).append(",");
            }
            servletHolder.setInitParameter("blackList", sb.toString());
        }
        if (app.isDebugMode()) {
            servletHolder.setInitParameter("tb_debug", "true");
        }
        if (app.getProxy() != null) {
            servletHolder.setInitParameter("proxy", app.getProxy());
        }
        if (app.getProxyAuth() != null) {
            servletHolder.setInitParameter("proxyAuth", app.getProxyAuth());
        }
        if (app.getBasicAuth() != null) {
            servletHolder.setInitParameter("basicAuth", String.join((CharSequence)",", app.getBasicAuth()));
        }
        servletHolder.setInitParameter("jetty", String.valueOf(app.getJettyPort()));
        HandlerCollection handlers = new HandlerCollection();
        this.httpProxy.setHandler(handlers);
        ServletContextHandler context = new ServletContextHandler(handlers, "/", 1);
        context.addServlet(servletHolder, "/*");
        context.setAttribute("extra_headers", app.getCustomHeaders());
        CustomConnectHandler proxy = new CustomConnectHandler(app);
        proxy.setDebugMode(app.isDebugMode());
        if (app.getFastFail() != null && app.getFastFail().length > 0) {
            for (String domain : app.getFastFail()) {
                if (!domain.contains(":")) {
                    domain = domain + ":443";
                }
                proxy.getBlackListHosts().add(domain);
            }
        }
        handlers.addHandler(proxy);
        this.start();
        this.shutDownHook = new Thread(new ShutDownHook(this.httpProxy));
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    public void stop() {
        Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
        try {
            this.httpProxy.stop();
        }
        catch (Exception ex) {
            Logger.getLogger(HttpProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void start() {
        try {
            this.httpProxy.start();
        }
        catch (Exception ex) {
            Logger.getLogger(HttpProxy.class.getName()).log(Level.SEVERE, "Could not set up local http proxy. Please make sure this program can open port {0} on this computer.", Integer.toString(this.app.getJettyPort()));
            System.exit(1);
        }
    }

    private ServerSocket _findAvailableSocket() {
        int[] ports;
        for (int port : ports = new int[]{80, 888, 2000, 2001, 2020, 2222, 3000, 3001, 3030, 3333, 4000, 4001, 4040, 4502, 4503, 5000, 5001, 5050, 5555, 6000, 6001, 6060, 6666, 7000, 7070, 7777, 8000, 8001, 8080, 8888, 9000, 9001, 9090, 9999}) {
            try {
                return new ServerSocket(port);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public boolean testProxy() {
        int port;
        try {
            ServerSocket serverSocket = this._findAvailableSocket();
            if (serverSocket == null) {
                return true;
            }
            port = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (IOException ex) {
            return true;
        }
        Server server = new Server(port);
        server.setHandler(new TestHandler());
        try {
            server.start();
        }
        catch (Exception e) {
            return true;
        }
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String url = "https://api.testingbot.com/v1/tunnel/test";
            HttpPost postRequest = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("client_key", this.app.getClientKey()));
            nameValuePairs.add(new BasicNameValuePair("client_secret", this.app.getClientSecret()));
            nameValuePairs.add(new BasicNameValuePair("tunnel_id", Integer.toString(this.app.getTunnelID())));
            nameValuePairs.add(new BasicNameValuePair("test_port", Integer.toString(port)));
            postRequest.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs));
            HttpResponse response = httpClient.execute(postRequest);
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF8"));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            try {
                server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return response.getStatusLine().getStatusCode() == 201 && sb.indexOf("test=" + this.randomNumber) > -1;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private class ShutDownHook
    implements Runnable {
        private final Server proxy;

        ShutDownHook(Server proxy) {
            this.proxy = proxy;
        }

        @Override
        public void run() {
            try {
                this.proxy.stop();
            }
            catch (Exception ex) {
                Logger.getLogger(HttpProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class TestHandler
    extends AbstractHandler {
        private TestHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(200);
            baseRequest.setHandled(true);
            response.getWriter().println("test=" + HttpProxy.this.randomNumber);
        }
    }
}

