/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import com.testingbot.tunnel.App;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class Doctor {
    private final App app;

    public Doctor(App app) {
        this.app = app;
        app.setFreeJettyPort();
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            uris.add(new URI("https://testingbot.com"));
            uris.add(new URI("http://hub.testingbot.com"));
            uris.add(new URI("https://api.testingbot.com/v1/browsers"));
            uris.add(new URI("https://www.google.com/"));
        }
        catch (URISyntaxException e) {
            Logger.getLogger(Doctor.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        this.performChecks(uris);
    }

    public void performChecks(ArrayList<URI> uris) {
        try {
            for (URI uri : uris) {
                this.performCheck(uri);
            }
        }
        catch (UnknownHostException e) {
            Logger.getLogger(Doctor.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        this.checkOpenPorts();
    }

    public void checkOpenPorts() {
        boolean canOpenJetty = this.checkPortOpen(this.app.getJettyPort());
        if (!canOpenJetty) {
            Logger.getLogger(Doctor.class.getName()).log(Level.SEVERE, "Cannot open proxy port {0}.\nDoes this process have the correct permissions?", Integer.toString(this.app.getJettyPort()));
        } else {
            Logger.getLogger(Doctor.class.getName()).log(Level.INFO, "OK - Proxy port {0} can be opened", Integer.toString(this.app.getJettyPort()));
        }
        boolean canOpenSEPort = this.checkPortOpen(this.app.getSeleniumPort());
        if (!canOpenSEPort) {
            Logger.getLogger(Doctor.class.getName()).log(Level.SEVERE, "Cannot open Selenium port {0}.\nPerhaps another process is using this port? Or this process does not have the correct permission?", Integer.toString(this.app.getSeleniumPort()));
        } else {
            Logger.getLogger(Doctor.class.getName()).log(Level.INFO, "OK - Selenium port {0} can be opened", Integer.toString(this.app.getSeleniumPort()));
        }
    }

    private boolean checkPortOpen(int port) {
        try {
            try (ServerSocket socket = new ServerSocket(port);){
                socket.getLocalPort();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void performCheck(URI uri) throws UnknownHostException {
        Logger.getLogger(Doctor.class.getName()).log(Level.INFO, "Resolving {0}", new Object[]{uri.toString()});
        InetAddress address = InetAddress.getByName(uri.getHost());
        Logger.getLogger(Doctor.class.getName()).log(Level.INFO, "OK - Resolved {0} to {1}", new Object[]{uri.toString(), address.getHostAddress()});
        if (this.checkConnection(uri)) {
            Logger.getLogger(Doctor.class.getName()).log(Level.INFO, "OK - URL {0} can be reached.", uri.toString());
        } else {
            Logger.getLogger(Doctor.class.getName()).log(Level.SEVERE, "URL {0} can not be reached.", uri.toString());
        }
    }

    private boolean checkConnection(URI uri) {
        HttpResponse response;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet getRequest = new HttpGet(uri);
        try {
            response = httpClient.execute(getRequest);
        }
        catch (IOException ex) {
            return false;
        }
        return response.getStatusLine().getStatusCode() == 200;
    }
}

