/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import com.testingbot.tunnel.Api;
import com.testingbot.tunnel.Doctor;
import com.testingbot.tunnel.HttpForwarder;
import com.testingbot.tunnel.HttpProxy;
import com.testingbot.tunnel.InsightServer;
import com.testingbot.tunnel.LocalWebServer;
import com.testingbot.tunnel.LogFormatter;
import com.testingbot.tunnel.PidPoller;
import com.testingbot.tunnel.Statistics;
import com.testingbot.tunnel.TestingBotLogHandler;
import com.testingbot.tunnel.proxy.ProxyAuth;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import ssh.SSHTunnel;
import ssh.TunnelPoller;

public class App {
    public static final Float VERSION = Float.valueOf(3.4f);
    private Api api;
    private String clientKey;
    private String clientSecret;
    private String readyFile;
    private int seleniumPort = 4445;
    private String[] fastFail;
    private SSHTunnel tunnel;
    private String tunnelIdentifier;
    private String serverIP;
    private final Map<String, String> customHeaders = new HashMap<String, String>();
    private int hubPort = 4444;
    private int tunnelID = 0;
    private int jettyPort = 0;
    private boolean noProxy = false;
    private boolean bypassSquid = false;
    private boolean debugMode = false;
    private HttpProxy httpProxy;
    private String proxy;
    private String proxyAuth;
    private String[] basicAuth;
    private String pac = null;
    private int metricsPort = 8003;
    private int sshPort = 0;
    private PidPoller pidPoller;
    private TunnelPoller poller;
    private HttpForwarder httpForwarder;

    public static void main(String ... args) throws Exception {
        PosixParser cmdLinePosixParser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "Displays help text");
        options.addOption("d", "debug", false, "Enables debug messages");
        Option readyfile = new Option("f", "readyfile", true, "This file will be touched when the tunnel is ready for usage");
        readyfile.setArgName("FILE");
        options.addOption(readyfile);
        Option seleniumPort = new Option("P", "se-port", true, "The local port your Selenium test should connect to.");
        seleniumPort.setArgName("PORT");
        options.addOption(seleniumPort);
        Option fastFail = new Option("F", "fast-fail-regexps", true, "Specify domains you don't want to proxy, comma separated.");
        fastFail.setArgName("OPTIONS");
        options.addOption(fastFail);
        OptionBuilder.withLongOpt("metrics-port");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Use the specified port to access metrics. Default port 8003");
        Option metrics = OptionBuilder.create();
        options.addOption(metrics);
        Option proxy = new Option("Y", "proxy", true, "Specify an upstream proxy.");
        proxy.setArgName("PROXYHOST:PROXYPORT");
        options.addOption(proxy);
        Option basicAuth = new Option("a", "auth", true, "Performs Basic Authentication for specific hosts.");
        basicAuth.setArgs(-2);
        basicAuth.setArgName("host:port:user:passwd");
        options.addOption(basicAuth);
        OptionBuilder.withLongOpt("pac");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Proxy autoconfiguration. Should be a http(s) URL");
        Option pac = OptionBuilder.create();
        options.addOption(pac);
        Option proxyAuth = new Option("z", "proxy-userpwd", true, "Username and password required to access the proxy configured with --proxy.");
        proxyAuth.setArgName("user:pwd");
        options.addOption(proxyAuth);
        Option logfile = new Option("l", "logfile", true, "Write logging to a file.");
        logfile.setArgName("FILE");
        options.addOption(logfile);
        Option identifier = new Option("i", "tunnel-identifier", true, "Add an identifier to this tunnel connection.\n In case of multiple tunnels, specify this identifier in your desired capabilities to use this specific tunnel connection.");
        identifier.setArgName("id");
        options.addOption(identifier);
        Option hubPort = new Option("p", "hubport", true, "Use this if you want to connect to port 80 on our hub instead of the default port 4444");
        hubPort.setArgName("HUBPORT");
        options.addOption(hubPort);
        Option extraHeaders = new Option(null, "extra-headers", true, "Inject extra headers in the requests the tunnel makes.");
        extraHeaders.setArgName("JSON Map with Header Key and Value");
        options.addOption(extraHeaders);
        Option dns = new Option("dns", "dns", true, "Use a custom DNS server. For example: 8.8.8.8");
        dns.setArgName("server");
        options.addOption(dns);
        Option localweb = new Option("w", "web", true, "Point to a directory for testing. Creates a local webserver.");
        localweb.setArgName("directory");
        options.addOption(localweb);
        options.addOption("x", "noproxy", false, "Do not start a local proxy (requires user provided proxy server on port 8087)");
        options.addOption("q", "nocache", false, "Bypass our Caching Proxy running on our tunnel VM.");
        options.addOption("j", "localproxy", true, "The port to launch the local proxy on (default 8087)");
        options.addOption(null, "doctor", false, "Perform checks to detect possible misconfiguration or problems.");
        options.addOption("v", "version", false, "Displays the current version of this program");
        Log.setLog(new TestingBotLogHandler());
        System.setProperty("org.eclipse.jetty.LEVEL", "OFF");
        Statistics.setStartTime(System.currentTimeMillis());
        try {
            String[] userdata;
            CommandLine commandLine = cmdLinePosixParser.parse(options, args);
            if (commandLine.hasOption("help")) {
                HelpFormatter help = new HelpFormatter();
                help.setWidth(180);
                help.printHelp("java -jar testingbot-tunnel.jar API_KEY API_SECRET [OPTIONS]", options);
                System.exit(0);
            } else if (commandLine.hasOption("version")) {
                System.out.println("Version: testingbot-tunnel.jar " + VERSION);
                System.exit(0);
            }
            Logger logger = Logger.getLogger(App.class.getName());
            logger.setUseParentHandlers(false);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(new LogFormatter());
            logger.addHandler(handler);
            App app = new App();
            if (commandLine.hasOption("debug")) {
                Log.setLog(new JavaUtilLog());
                Logger.getLogger(App.class.getName()).log(Level.INFO, "Running in debug-mode");
                Logger.getLogger(App.class.getName()).setLevel(Level.ALL);
                app.setDebugMode(true);
                Logger rootLogger = LogManager.getLogManager().getLogger("");
                rootLogger.setLevel(Level.ALL);
                for (Handler h : rootLogger.getHandlers()) {
                    h.setLevel(Level.ALL);
                }
            } else {
                Logger.getLogger(App.class.getName()).setLevel(Level.INFO);
            }
            if (commandLine.hasOption("logfile")) {
                try {
                    FileHandler handlerFile = new FileHandler(commandLine.getOptionValue("logfile"));
                    handlerFile.setFormatter(new LogFormatter());
                    handlerFile.setLevel(Level.ALL);
                    Logger.getLogger(App.class.getName()).addHandler(handlerFile);
                    Logger.getLogger(App.class.getName()).log(Level.INFO, "Logging to file {0}", commandLine.getOptionValue("logfile"));
                }
                catch (IOException | SecurityException e) {
                    System.err.println("Cannot write logfile to " + commandLine.getOptionValue("logfile") + ".\nMake sure the directory exists and that we have the proper rights to write to this directory.");
                }
            }
            String clientKey = null;
            String clientSecret = null;
            if (commandLine.hasOption("doctor")) {
                app.doctor();
                return;
            }
            System.out.println("----------------------------------------------------------------");
            System.out.println("  TestingBot Tunnel v" + VERSION + "                        ");
            System.out.println("  Questions or suggestions, please visit https://testingbot.com ");
            System.out.println("----------------------------------------------------------------");
            if (commandLine.getArgs().length < 2 && (userdata = app.getUserData()).length == 2) {
                clientKey = userdata[0];
                clientSecret = userdata[1];
            }
            if (commandLine.getArgs().length == 0 && clientKey == null) {
                throw new ParseException("Missing required arguments API_KEY API_SECRET\nYou can get these two values from https://testingbot.com/members/user/edit");
            }
            if (commandLine.getArgs().length == 1 && clientKey == null) {
                throw new ParseException("Missing required argument API_SECRET\nYou can get this from https://testingbot.com/members/user/edit");
            }
            if (clientKey != null && clientSecret != null) {
                app.clientKey = clientKey;
                app.clientSecret = clientSecret;
            } else {
                app.clientKey = commandLine.getArgs()[0].trim();
                app.clientSecret = commandLine.getArgs()[1].trim();
            }
            if (commandLine.hasOption("fast-fail-regexps")) {
                String line = commandLine.getOptionValue("fast-fail-regexps");
                app.fastFail = line.split(",");
                Logger.getLogger(App.class.getName()).log(Level.INFO, "Fast-fail mode set for {0}", line);
            }
            if (commandLine.hasOption("proxy")) {
                String line = commandLine.getOptionValue("proxy");
                app.setProxy(line);
            }
            if (commandLine.hasOption("extra-headers")) {
                String extraHeadersValue = commandLine.getOptionValue("extra-headers");
                JSONObject obj = JSONObject.fromObject(extraHeadersValue);
                Iterator keyIterator = obj.keys();
                while (keyIterator.hasNext()) {
                    String key = (String)keyIterator.next();
                    String value = obj.getString(key);
                    app.addCustomHeader(key, value);
                }
            }
            if (commandLine.hasOption("metrics-port")) {
                String line = commandLine.getOptionValue("metrics-port");
                app.setMetricsPort(Integer.parseInt(line));
            }
            if (commandLine.hasOption("tunnel-identifier")) {
                String identifierValue = commandLine.getOptionValue("tunnel-identifier");
                app.setTunnelIdentifier(identifierValue.substring(0, Math.min(identifierValue.length(), 50)));
            }
            if (commandLine.hasOption("auth")) {
                for (String optionValue : commandLine.getOptionValues("auth")) {
                    if (optionValue.split(":").length >= 4) continue;
                    throw new ParseException("ERROR: Auth value must contain host:port:user:password value: " + optionValue);
                }
                app.setBasicAuth(commandLine.getOptionValues("auth"));
            }
            if (commandLine.hasOption("proxy-userpwd")) {
                String line = commandLine.getOptionValue("proxy-userpwd");
                app.setProxyAuth(line);
            }
            if (commandLine.hasOption("noproxy")) {
                app.noProxy = true;
            }
            if (commandLine.hasOption("pac")) {
                app.pac = commandLine.getOptionValue("pac");
            }
            if (commandLine.hasOption("localproxy")) {
                app.setJettyPort(Integer.parseInt(commandLine.getOptionValue("localproxy")));
            } else {
                app.setFreeJettyPort();
            }
            if (commandLine.hasOption("readyfile")) {
                app.readyFile = commandLine.getOptionValue("readyfile").trim();
            }
            if (commandLine.hasOption("nocache")) {
                Logger.getLogger(App.class.getName()).log(Level.INFO, "Disable Caching. All requests will go through the tunnel.");
                app.bypassSquid = true;
            }
            if (commandLine.hasOption("hubport")) {
                app.hubPort = Integer.parseInt(commandLine.getOptionValue("hubport"));
                if (app.hubPort != 80 && app.hubPort != 4444) {
                    throw new ParseException("The hub port must either be 80 or 4444");
                }
            }
            if (commandLine.hasOption("dns")) {
                System.setProperty("sun.net.spi.nameservice.nameservers", commandLine.getOptionValue("dns"));
                System.setProperty("sun.net.spi.nameservice.provider.1", "dns,sun");
            }
            if (commandLine.hasOption("web")) {
                LocalWebServer localWebServer = new LocalWebServer(commandLine.getOptionValue("web"));
            }
            if (commandLine.hasOption("se-port")) {
                app.seleniumPort = Integer.parseInt(commandLine.getOptionValue("se-port"));
            }
            app.init();
            app.boot();
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            System.exit(0);
        }
    }

    private String[] getUserData() {
        if (System.getenv("TESTINGBOT_KEY") != null && System.getenv("TESTINGBOT_SECRET") != null) {
            return new String[]{System.getenv("TESTINGBOT_KEY"), System.getenv("TESTINGBOT_SECRET")};
        }
        File dataFile = new File(System.getProperty("user.home") + File.separator + ".testingbot");
        if (dataFile.exists()) {
            try {
                FileInputStream fstream = new FileInputStream(dataFile.getAbsolutePath());
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String strLine = br.readLine();
                return strLine.split(":");
            }
            catch (IOException fstream) {
                // empty catch block
            }
        }
        String[] empty = new String[]{""};
        return empty;
    }

    public void init() {
        Thread cleanupThread = new Thread(){

            @Override
            public void run() {
                File f;
                if (App.this.readyFile != null && (f = new File(App.this.readyFile)).exists()) {
                    f.delete();
                }
                if (App.this.tunnel != null) {
                    App.this.tunnel.stop();
                }
                try {
                    System.out.println("Shutting down your personal Tunnel Server.");
                    App.this.api.destroyTunnel();
                }
                catch (Exception ex) {
                    Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }

    public void boot() throws Exception {
        this.api = new Api(this);
        JSONObject tunnelData = new JSONObject();
        try {
            tunnelData = this.api.createTunnel();
        }
        catch (Exception e) {
            System.err.println("Creating a new tunnel failed, please make sure you're supplying correct credentials and that you can connect to the TestingBot network.\nUse --doctor to verify if everything is set up correctly.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (tunnelData.has("error")) {
            System.err.println("An error ocurred: " + tunnelData.getString("error"));
            if (tunnelData.getString("error").contains("401")) {
                System.err.println("Missing required arguments API_KEY API_SECRET\nYou can get these two values from https://testingbot.com/members/user/edit");
            }
            System.exit(1);
        }
        this.trackPid();
        this.startInsightServer();
        if (tunnelData.has("id")) {
            this.tunnelID = Integer.parseInt(tunnelData.getString("id"));
            this.api.setTunnelID(this.tunnelID);
        }
        if (Float.valueOf(tunnelData.getString("version")).floatValue() > VERSION.floatValue()) {
            System.err.println("A new version (" + tunnelData.getString("version") + ") is available for download at https://testingbot.com\nYou have version " + VERSION);
        }
        Logger.getLogger(App.class.getName()).log(Level.INFO, "Please wait while your personal Tunnel Server is being setup. Shouldn't take more than a minute.\nWhen the tunnel is ready you will see a message \"You may start your tests.\"");
        if (tunnelData.getString("state").equals("READY")) {
            this.tunnelReady(tunnelData);
        } else {
            this.poller = new TunnelPoller(this, tunnelData.getString("id"));
        }
    }

    public void startInsightServer() {
        InsightServer insight = new InsightServer(this);
    }

    public void trackPid() {
        this.pidPoller = new PidPoller(this);
    }

    public void stop() {
        if (this.tunnel != null) {
            this.tunnel.stop(true);
        }
        if (this.httpForwarder != null) {
            this.httpForwarder.stop();
        }
        if (this.poller != null) {
            this.poller.cancel();
        }
        try {
            System.out.println("Shutting down your personal Tunnel Server.");
            this.api.destroyTunnel();
        }
        catch (Exception ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void tunnelReady(JSONObject apiResponse) {
        try {
            String _serverIP = apiResponse.getString("ip");
            this.tunnel = new SSHTunnel(this, _serverIP);
            if (this.tunnel.isAuthenticated()) {
                this.serverIP = _serverIP;
                Logger.getLogger(App.class.getName()).log(Level.INFO, "Successfully authenticated, setting up forwarding.");
                this.tunnel.createPortForwarding();
                this.startProxies();
                Logger.getLogger(App.class.getName()).log(Level.INFO, "The Tunnel is ready, ip: {0}\nYou may start your tests.", _serverIP);
                Logger.getLogger(App.class.getName()).log(Level.INFO, "To stop the tunnel, press CTRL+C");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(App.class.getName()).log(Level.INFO, "Something went wrong while setting up the Tunnel.");
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void startProxies() {
        this.httpForwarder = new HttpForwarder(this);
        if (!this.httpForwarder.testForwarding()) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, "! Forwarder testing failed, localhost port {0} does not seem to be able to reach our hub (hub.testingbot.com)", Integer.toString(this.getSeleniumPort()));
        }
        if (!this.noProxy) {
            this.httpProxy = new HttpProxy(this);
            if (this.getProxy() == null && !this.httpProxy.testProxy()) {
                Logger.getLogger(App.class.getName()).log(Level.SEVERE, "! Tunnel might not work properly, test failed");
            }
        }
        if (this.readyFile != null) {
            File f = new File(this.readyFile);
            if (f.exists()) {
                f.setLastModified(System.currentTimeMillis());
            } else {
                try {
                    FileWriter fw = new FileWriter(f.getAbsoluteFile());
                    try (BufferedWriter bw = new BufferedWriter(fw);){
                        bw.write("TestingBot Tunnel Ready");
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(App.class.getName()).log(Level.SEVERE, "Could not create readyfile. Please make sure the director exists and we can write to this directory.", ex);
                }
            }
        }
    }

    public void doctor() {
        Doctor doctor = new Doctor(this);
    }

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public int getTunnelID() {
        return this.tunnelID;
    }

    public Api getApi() {
        return this.api;
    }

    public int getJettyPort() {
        return this.jettyPort;
    }

    public void setFreeJettyPort() {
        try {
            ServerSocket serverSocket = this._findAvailableSocket();
            if (serverSocket == null) {
                return;
            }
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            this.setJettyPort(port);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ServerSocket _findAvailableSocket() {
        try {
            return new ServerSocket(0);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public int getHubPort() {
        return this.hubPort;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientKey(String key) {
        this.clientKey = key;
    }

    public void setClientSecret(String secret) {
        this.clientSecret = secret;
    }

    public void setProxy(String p) {
        this.proxy = p;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String[] getFastFail() {
        return this.fastFail;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void addCustomHeader(String key, String value) {
        this.customHeaders.put(key, value);
    }

    public int getSeleniumPort() {
        return this.seleniumPort;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public boolean isBypassingSquid() {
        return this.bypassSquid;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getProxyAuth() {
        return this.proxyAuth;
    }

    public void setProxyAuth(String proxyAuth) {
        this.proxyAuth = proxyAuth;
        String[] splitted = proxyAuth.split(":");
        Authenticator.setDefault(new ProxyAuth(splitted[0], splitted[1]));
    }

    public String getTunnelIdentifier() {
        return this.tunnelIdentifier;
    }

    public void setTunnelIdentifier(String tunnelIdentifier) {
        this.tunnelIdentifier = tunnelIdentifier;
    }

    public String getPac() {
        return this.pac;
    }

    public void setJettyPort(int jettyPort) {
        Logger.getLogger(App.class.getName()).log(Level.INFO, "Setting up Local Proxy Port {0}", Integer.toString(jettyPort));
        this.jettyPort = jettyPort;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    public String[] getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(String[] basicAuth) {
        this.basicAuth = basicAuth;
    }

    public int getSSHPort() {
        if (this.sshPort == 0) {
            try {
                ServerSocket serverSocket = this._findAvailableSocket();
                if (serverSocket == null) {
                    this.sshPort = 4446;
                    return this.sshPort;
                }
                int port = serverSocket.getLocalPort();
                serverSocket.close();
                this.sshPort = port;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sshPort;
    }
}

