/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.variables;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.EnvironmentVariableAccessorImpl;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.testingbot.bamboo.config.MappedBuildConfiguration;
import com.testingbot.bamboo.variables.DefaultVariableModifier;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Bamboo3Modifier
extends DefaultVariableModifier {
    private static final Logger logger = Logger.getLogger(Bamboo3Modifier.class);
    private final EnvironmentVariableAccessor environmentVariableAccessor;

    public Bamboo3Modifier(MappedBuildConfiguration config, BuildDefinition definition, BuildContext buildContext, EnvironmentVariableAccessor environmentVariableAccessor, CustomVariableContext customVariableContext) {
        super(config, definition, buildContext, customVariableContext);
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    @Override
    public void populateVariables(VariableContext variableContext) {
        this.createSeleniumVariableContext(variableContext);
    }

    @Override
    public void storeVariables() {
        String envBuffer = this.createSeleniumEnvironmentVariables();
        Map envMap = this.environmentVariableAccessor.splitEnvironmentAssignments(envBuffer, false);
        try {
            Class<TaskDefinition> taskDefinitionClass = TaskDefinition.class;
            if (taskDefinitionClass != null) {
                List taskDefinitions = this.definition.getTaskDefinitions();
                for (TaskDefinition taskDefinition : taskDefinitions) {
                    Map configuration = taskDefinition.getConfiguration();
                    String originalEnv = StringUtils.defaultString((String)configuration.get("environmentVariables"));
                    Map origMap = this.environmentVariableAccessor.splitEnvironmentAssignments(originalEnv, false);
                    for (Map.Entry entry : envMap.entrySet()) {
                        if (!((String)entry.getKey()).startsWith("SELENIUM_") && !((String)entry.getKey()).startsWith("TB_") && !((String)entry.getKey()).startsWith("TESTINGBOT_") && !((String)entry.getKey()).equals("TUNNEL_IDENTIFIER")) continue;
                        origMap.put((String)entry.getKey(), "${bamboo." + (String)entry.getKey() + "}");
                    }
                    configuration.put("environmentVariables", Bamboo3Modifier.joinEnvMap(origMap));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to process environment variables", (Throwable)e);
        }
    }

    @Nullable
    private static String joinEnvMap(Map<String, String> origMap) {
        return org.apache.commons.lang3.StringUtils.join(Iterables.transform(origMap.entrySet(), (Function)CreateEnvironmentAssignment.INSTANCE).iterator(), (String)" ");
    }

    private static enum CreateEnvironmentAssignment implements Function<Map.Entry<String, String>, String>
    {
        INSTANCE;


        public String apply(@Nullable Map.Entry<String, String> input) {
            return String.format("%s=\"%s\"", EnvironmentVariableAccessorImpl.forceLegalIdentifier((String)((String)((Map.Entry)Preconditions.checkNotNull(input)).getKey())), ((Map.Entry)Preconditions.checkNotNull(input)).getValue());
        }
    }
}

