/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.admin.action;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.lang.StringUtils;

public class ConfigureAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private String tbKey;
    private String tbSecret;

    public ConfigureAction(PluginAccessor pluginAccessor) {
        this.setAdministrationConfigurationAccessor((AdministrationConfigurationAccessor)ComponentLocator.getComponent(AdministrationConfigurationAccessor.class));
        this.setAdministrationConfigurationManager((AdministrationConfigurationManager)ComponentLocator.getComponent(AdministrationConfigurationManager.class));
        this.setAdministrationConfigurationPersister((AdministrationConfigurationPersister)ComponentLocator.getComponent(AdministrationConfigurationPersister.class));
    }

    public String doEdit() {
        AdministrationConfiguration adminConfig = this.getAdministrationConfiguration();
        this.setKey(adminConfig.getSystemProperty("tb.key"));
        this.setSecret(adminConfig.getSystemProperty("tb.secret"));
        return "input";
    }

    public String doSave() {
        AdministrationConfiguration adminConfig = this.getAdministrationConfiguration();
        adminConfig.setSystemProperty("tb.key", this.getKey());
        adminConfig.setSystemProperty("tb.secret", this.getSecret());
        this.administrationConfigurationManager.saveAdministrationConfiguration(adminConfig);
        if (ActionContext.getContext() != null && ActionContext.getContext().getApplication() != null) {
            this.getBamboo().restartComponentsFollowingConfigurationChange();
        }
        this.addActionMessage(this.getText("config.updated"));
        return "success";
    }

    public void validate() {
        if (StringUtils.isBlank(this.tbKey)) {
            this.addFieldError("tbKey", "TestingBot Key is required.");
        }
        if (StringUtils.isBlank(this.tbSecret)) {
            this.addFieldError("tbSecret", "TestingBot Secret is required.");
        }
    }

    public String getKey() {
        return this.tbKey;
    }

    public void setKey(String key) {
        this.tbKey = key;
    }

    public String getSecret() {
        return this.tbSecret;
    }

    public void setSecret(String secret) {
        this.tbSecret = secret;
    }
}

