/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.action;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import com.testingbot.bamboo.AbstractTestingBotBuildPlugin;
import com.testingbot.bamboo.config.MappedBuildConfiguration;
import com.testingbot.bamboo.tunnel.TestingBotTunnel;
import com.testingbot.models.TestingbotTest;
import com.testingbot.testingbotrest.TestingbotApiException;
import com.testingbot.testingbotrest.TestingbotREST;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PostBuildAction
extends AbstractTestingBotBuildPlugin
implements CustomBuildProcessor {
    private static final Logger logger = Logger.getLogger(PostBuildAction.class);
    public static final String TESTINGBOT_SESSION_ID = "TestingBotSessionID";
    private static final Pattern SESSION_ID_PATTERN = Pattern.compile("TestingBotSessionID=([0-9A-z\\-]+)(?:.test-name=(.*))?");
    private static final String JOB_NAME_PATTERN = "\\b({0})\\b";
    private PlanManager planManager;
    private BuildLoggerManager buildLoggerManager;
    private StorageLocationService storageLocationService;
    private CustomVariableContext customVariableContext;

    protected MappedBuildConfiguration getBuildConfiguration(BuildContext buildContext) {
        return new MappedBuildConfiguration(buildContext.getBuildDefinition().getCustomConfiguration());
    }

    @NotNull
    public BuildContext call() {
        logger.info((Object)"TB PostBuildAction");
        MappedBuildConfiguration config = this.getBuildConfiguration(this.buildContext);
        if (config.isEnabled()) {
            try {
                this.recordJobResult(config);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            if (config.isTunnelEnabled()) {
                final BuildLogger buildLogger = this.getBuildLoggerManager().getLogger(this.buildContext.getResultKey());
                PrintStream printLogger = new PrintStream((OutputStream)new NullOutputStream()){

                    @Override
                    public void println(String x) {
                        buildLogger.addBuildLogEntry(x);
                    }
                };
                if (TestingBotTunnel.tunnel != null) {
                    TestingBotTunnel.tunnel.stop();
                    TestingBotTunnel.tunnel = null;
                }
            }
        }
        return this.buildContext;
    }

    public void init(@NotNull BuildContext context) {
        this.buildContext = context;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    protected void recordJobResult(MappedBuildConfiguration config) throws IOException {
        boolean foundLogEntry = false;
        logger.info((Object)"Checking log interceptor entries");
        CurrentBuildResult buildResult = this.buildContext.getBuildResult();
        for (Map.Entry entry : buildResult.getCustomBuildData().entrySet()) {
            if (!((String)entry.getKey()).contains("TB_JOB_ID") || !this.processLine(config, (String)entry.getValue())) continue;
            foundLogEntry = true;
        }
        logger.info((Object)"Reading from log file");
        StorageLocationService storageLocationService = this.getStorageLocationService();
        File logFile = storageLocationService.getLogFile((ResultKey)this.buildContext.getPlanResultKey());
        List lines = FileUtils.readLines((File)logFile);
        for (Object object : lines) {
            String line = (String)object;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing line: " + line));
            }
            if (!this.processLine(config, line)) continue;
            foundLogEntry = true;
        }
        logger.info((Object)"Reading from build logger output");
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(this.buildContext.getResultKey());
        for (LogEntry logEntry : buildLogger.getLastNLogEntries(100)) {
            if (!this.processLine(config, logEntry.getLog())) continue;
            foundLogEntry = true;
        }
        if (!foundLogEntry) {
            logger.warn((Object)"No TestingBot Session IDs found in the build output");
        }
    }

    protected boolean processLine(MappedBuildConfiguration config, String line) {
        String sessionId = null;
        String jobName = null;
        Matcher m = SESSION_ID_PATTERN.matcher(line);
        while (m.find()) {
            sessionId = m.group(1);
            if (m.groupCount() != 2) continue;
            jobName = m.group(2);
        }
        if (sessionId == null) {
            sessionId = StringUtils.substringBetween(line, "TestingBotSessionID=", " ");
        }
        if (sessionId == null) {
            sessionId = StringUtils.substringAfter(line, "TestingBotSessionID=");
        }
        if (sessionId != null && !sessionId.equalsIgnoreCase("null")) {
            if (sessionId.trim().equals("")) {
                logger.error((Object)("Session id for line" + line + " was blank"));
                return false;
            }
            this.storeBuildNumber(config, sessionId, jobName);
            return true;
        }
        return false;
    }

    protected void storeBuildNumber(MappedBuildConfiguration config, String sessionId, String jobName) {
        TestingbotREST tbClient = this.getRESTClient(config);
        logger.info((Object)("Updating Test " + sessionId + " via TestingBot API"));
        try {
            TestingbotTest testInformation = tbClient.getTest(sessionId);
            if (!testInformation.getName().isEmpty()) {
                Boolean testPassed = this.hasTestPassed(testInformation.getName());
                if (testPassed != null) {
                    testInformation.setSuccess(testPassed);
                }
            } else {
                testInformation.setName(jobName);
            }
            if (testInformation.getBuild() == null || testInformation.getBuild().isEmpty()) {
                testInformation.setBuild(this.getBuildNumber());
            }
            tbClient.updateTest(testInformation);
        }
        catch (TestingbotApiException testingbotApiException) {
            // empty catch block
        }
    }

    protected TestingbotREST getRESTClient(MappedBuildConfiguration config) {
        return new TestingbotREST(config.getTempKey(), config.getTempSecret());
    }

    private Boolean hasTestPassed(String name) {
        TestResults testResults = this.findTestResult(name);
        if (testResults != null) {
            return testResults.getState().equals((Object)TestState.SUCCESS);
        }
        return this.buildContext.getBuildResult().getBuildState().equals((Object)BuildState.SUCCESS);
    }

    private TestResults findTestResult(String name) {
        if (name == null) {
            return null;
        }
        TestResults testResult = this.findTestResult(name, this.buildContext.getBuildResult().getFailedTestResults());
        if (testResult == null) {
            testResult = this.findTestResult(name, this.buildContext.getBuildResult().getSuccessfulTestResults());
        }
        return testResult;
    }

    private TestResults findTestResult(String name, Collection<TestResults> testResults) {
        for (TestResults testResult : testResults) {
            Pattern jobNamePattern = Pattern.compile(MessageFormat.format(JOB_NAME_PATTERN, name));
            Matcher matcher = jobNamePattern.matcher(testResult.getActualMethodName());
            if (!name.equals(testResult.getActualMethodName()) && !name.contains(testResult.getActualMethodName()) && !matcher.find()) continue;
            return testResult;
        }
        return null;
    }

    protected String getBuildNumber() {
        return this.getBuildContextToUse().getBuildResultKey();
    }

    private BuildContext getBuildContextToUse() {
        return this.buildContext.getParentBuildContext() == null ? this.buildContext : this.buildContext.getParentBuildContext();
    }

    public BuildLoggerManager getBuildLoggerManager() {
        if (this.buildLoggerManager == null) {
            this.buildLoggerManager = (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
        }
        return this.buildLoggerManager;
    }

    public StorageLocationService getStorageLocationService() {
        if (this.storageLocationService == null) {
            this.storageLocationService = (StorageLocationService)ContainerManager.getComponent((String)"storageLocationService");
        }
        return this.storageLocationService;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

